/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.executableitems.manager;

import com.ssomar.executableitems.EIDisplayModule;
import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemLoader;
import com.ssomar.executableitems.executableitems.activators.ActivatorEIFeature;
import com.ssomar.executableitems.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.executableitems.listeners.optimize.OptimizedSlotsVerification;
import com.ssomar.executableitems.utils.ItemStackNoTypeForNBTAPI;
import com.ssomar.executableitems.utils.UtilNBTAPI;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.api.executableitems.config.ExecutableItemsManagerInterface;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.recognition.Recognition;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.sobject.manager.ManagerWithBuildable;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.strings.StringConverter;
import de.tr7zw.nbtapi.NBT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ExecutableItemsManager
extends SObjectWithFileManager<ExecutableItem>
implements ExecutableItemsManagerInterface,
ManagerWithBuildable<ExecutableItem> {
    private static ExecutableItemsManager instance;
    private Map<String, ExecutableItem> objectsWithCustomRecognition;
    private NamespacedKey key;

    public ExecutableItemsManager() {
        super((SPlugin)ExecutableItems.plugin, "ExecutableItem");
        if (!SCore.is1v13Less()) {
            this.key = new NamespacedKey((Plugin)ExecutableItems.getPluginSt(), "EI-ID");
        }
        this.objectsWithCustomRecognition = new HashMap<String, ExecutableItem>();
    }

    public static ExecutableItemsManager getInstance() {
        if (instance == null) {
            instance = new ExecutableItemsManager();
        }
        return instance;
    }

    public void actionOnObjectWhenLoading(ExecutableItem newExecutableItem) {
        if (!newExecutableItem.getRecognitions().isClassicRecognition()) {
            this.objectsWithCustomRecognition.put(newExecutableItem.getId(), newExecutableItem);
        }
        if (newExecutableItem.getDisplayConditions().getEnableFeature().getValue().booleanValue()) {
            EIDisplayModule.getInstance().addLoadedID(newExecutableItem.getId());
        }
        SsomarDev.testMsg((String)("ON ExecutableItem LOADING : " + newExecutableItem.getId()), (boolean)false);
        for (SActivator activator : newExecutableItem.getActivators().getActivators().values()) {
            SOption option = activator.getOption();
            if (!(activator instanceof ActivatorEIFeature)) continue;
            ActivatorEIFeature activatorEI = (ActivatorEIFeature)activator;
            OptimizedEventsHandler.getInstance().read(option);
            OptimizedEventsHandler.getInstance().read(activatorEI);
            OptimizedSlotsVerification.getInstance().addAllDetailedSlotsOptimized(option, activatorEI.getDetailedSlots().getSlots());
        }
    }

    public void actionOnObjectWhenReloading(ExecutableItem newExecutableItem) {
        if (!newExecutableItem.getRecognitions().isClassicRecognition()) {
            this.objectsWithCustomRecognition.put(newExecutableItem.getId(), newExecutableItem);
        } else {
            this.objectsWithCustomRecognition.remove(newExecutableItem.getId());
        }
        if (newExecutableItem.getDisplayConditions().getEnableFeature().getValue().booleanValue()) {
            EIDisplayModule.getInstance().addLoadedID(newExecutableItem.getId());
        } else {
            EIDisplayModule.getInstance().getLoadedIDs().remove(newExecutableItem.getId());
        }
    }

    public Optional<ExecutableItem> methodObjectLoading(String s) {
        return ExecutableItemLoader.getInstance().getObjectById(s, false);
    }

    public boolean isValidID(String id) {
        for (ExecutableItem item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Optional<ExecutableItemInterface> getExecutableItem(String s) {
        for (ExecutableItem item : this.getLoadedObjects()) {
            if (!item.getId().equals(s)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public Optional<ExecutableItemInterface> getExecutableItem(ItemStack itemStack) {
        return Optional.ofNullable(this.getExecutableItem(itemStack, new ArrayList<String>()));
    }

    public List<String> getExecutableItemIdsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (ExecutableItem item : this.getLoadedObjects()) {
            list.add(item.getId());
        }
        return list;
    }

    public List<ExecutableItemInterface> getAllExecutableItems() {
        ArrayList<ExecutableItemInterface> list = new ArrayList<ExecutableItemInterface>();
        for (ExecutableItem item : this.getLoadedObjects()) {
            list.add(item);
        }
        return list;
    }

    @Nullable
    public ExecutableItem getExecutableItem(ItemStack item, List<String> whiteListedID) {
        return this.getExecutableItem(item, whiteListedID, new DynamicMeta(null));
    }

    @Nullable
    public ExecutableItem getExecutableItem(ItemStack item, List<String> whiteListedID, @NotNull DynamicMeta dynamicMeta) {
        boolean hasItemMeta;
        ItemMeta itemMeta = null;
        String id = "";
        if (SCore.is1v13Less()) {
            try {
                id = (String)NBT.get((ItemStack)item, UtilNBTAPI.getID);
            }
            catch (NullPointerException nullPointerException) {}
        } else if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.itemCheckWithNBTAPI.name()) && SCore.hasNBTAPI) {
            try {
                id = (String)NBT.get((ItemStack)new ItemStackNoTypeForNBTAPI(item), UtilNBTAPI.getID);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            String idCalc;
            if (dynamicMeta.getMeta() == null) {
                boolean bl = hasItemMeta = item != null && (itemMeta = item.getItemMeta()) != null;
                if (!hasItemMeta) {
                    return null;
                }
            } else {
                hasItemMeta = true;
                itemMeta = dynamicMeta.getMeta();
            }
            id = (idCalc = (String)itemMeta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING)) == null ? "" : idCalc;
        }
        if (!id.isEmpty()) {
            for (ExecutableItem infoItem : this.getAllObjects()) {
                if (!infoItem.getId().equals(id)) continue;
                return infoItem;
            }
        } else {
            for (ExecutableItem infoItem : this.objectsWithCustomRecognition.values()) {
                if (dynamicMeta.getMeta() == null) {
                    boolean bl = hasItemMeta = item != null && (itemMeta = item.getItemMeta()) != null;
                    if (!hasItemMeta) {
                        return null;
                    }
                } else {
                    hasItemMeta = true;
                    itemMeta = dynamicMeta.getMeta();
                }
                if (!whiteListedID.isEmpty() && !whiteListedID.contains(infoItem.getId()) || infoItem.getRecognitions().isClassicRecognition()) continue;
                List lR = infoItem.getRecognitions().getCustomRecognitions();
                boolean valid = true;
                boolean pass = false;
                for (Recognition r : lR) {
                    switch (r) {
                        case LORE: {
                            if (!(infoItem.getLore().getValue().size() != 0 || hasItemMeta && itemMeta.hasLore())) {
                                pass = true;
                                break;
                            }
                            if (!hasItemMeta) break;
                            pass = true;
                            if (itemMeta.hasLore()) {
                                ArrayList<String> verifLore = new ArrayList<String>();
                                for (String s : Objects.requireNonNull(itemMeta.getLore())) {
                                    if (s.contains(MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.USE))) continue;
                                    verifLore.add(s);
                                }
                                if (StringConverter.decoloredString((String)infoItem.getLore().toString()).equals(StringConverter.decoloredString((String)((Object)verifLore).toString()))) break;
                                valid = false;
                                break;
                            }
                            valid = false;
                            break;
                        }
                        case MATERIAL: {
                            pass = true;
                            if (infoItem.getMaterial().getValue().get() == item.getType()) break;
                            valid = false;
                            break;
                        }
                        case NAME: {
                            if (!hasItemMeta) break;
                            pass = true;
                            if (StringConverter.deconvertColor((String)infoItem.getName()).equals(StringConverter.deconvertColor((String)itemMeta.getDisplayName()))) break;
                            valid = false;
                            break;
                        }
                    }
                }
                if (!pass || !valid) continue;
                return infoItem;
            }
        }
        return null;
    }

    public Optional<SObject> getObject(ItemStack itemStack) {
        return Optional.ofNullable(this.getExecutableItem(itemStack, new ArrayList<String>()));
    }

    public Map<String, ExecutableItem> getObjectsWithCustomRecognition() {
        return this.objectsWithCustomRecognition;
    }
}

