/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.optimize;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.executableitems.activators.ActivatorEIFeature;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.item.ItemClickInventoryItemListener;
import com.ssomar.executableitems.listeners.item.ItemEnterInventoryListener;
import com.ssomar.executableitems.listeners.item.ItemEnterInventoryListener1v12Plus;
import com.ssomar.executableitems.listeners.item.ItemLeaveInventoryListener;
import com.ssomar.executableitems.listeners.item.ItemLeaveInventoryListener1v12Plus;
import com.ssomar.executableitems.listeners.player.custom.PlayerAllClickListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBedEnterListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBeforeDeathListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBlockBreakListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBlockBreakWithEBListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBlockHitEntityListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBlockHitPlayerListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBlockPlaceListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBreakShieldOfPlayerListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBrushBlockListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBucketEntityListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerBucketFillListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerChangeWorldListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerClickOnEntityListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerClickOnPlayerListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerConnectionListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerConsumeListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerConsumeTheEIListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerCustomLaunchListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDeathListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDeselectTheEIListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDisableFlyListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDisableGlideListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDisableSneakListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDisableSprintListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDisconnectListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerDismountEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerDropItemEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerDropTheEIEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEIBreakEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEditBookEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEnableFlyEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEnableGlideEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEnableSneakEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEnableSprintEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerEquipEIEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerExpChangeListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerFertilizeBlockEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerFishBlockEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerFishEntityEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerFishFishEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerFishNothingEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerFishPlayerEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerFishXiaomomiFishListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerHarvestBlockListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerHitEntityEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerHitPlayerEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerInventoryClickEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerItemBreakEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerJumpEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerKickListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerKillEntityEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerKillPlayerEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerLeaveBedEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerLeftClickEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerMendTheEIListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerOpenInventoryListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerPortalListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerReceiveEffectEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerReceiveHitByEntityEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerReceiveHitByPlayerEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerReceiveHitGlobalEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerRegainHealthListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerRespawnEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerRightClickEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerRiptideListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerSelectTheEIEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerSetSpawnListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerShearEntityEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerShieldBreakByPlayerListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerSpawnChangeListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerSwapHandTheEIListener;
import com.ssomar.executableitems.listeners.player.custom.PlayerTargetedByAnEntityEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerTrampleCropEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerUnequipEIEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerWalkEvent;
import com.ssomar.executableitems.listeners.player.custom.PlayerWriteCommandEvent;
import com.ssomar.executableitems.listeners.player.lands.PlayerEnterLandsEventEI;
import com.ssomar.executableitems.listeners.player.lands.PlayerLeaveLandsEventEI;
import com.ssomar.executableitems.listeners.projectiles.ProjectileHitBlockEvent;
import com.ssomar.executableitems.listeners.projectiles.ProjectileHitEntityEvent;
import com.ssomar.executableitems.listeners.projectiles.ProjectileHitPlayerEvent;
import com.ssomar.executableitems.usedapi.ProtocolibAPI;
import com.ssomar.score.SCore;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.Couple;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.sevents.EventName;
import com.ssomar.sevents.registration.DynamicRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class OptimizedEventsHandler {
    private static OptimizedEventsHandler instance;
    private Map<Option, Couple<List<EventName>, Listener>> registered;
    private Map<SOption, List<String>> associations;

    public OptimizedEventsHandler() {
        this.init();
    }

    public static OptimizedEventsHandler getInstance() {
        if (instance == null) {
            instance = new OptimizedEventsHandler();
        }
        return instance;
    }

    public void init() {
        this.registered = new HashMap<Option, Couple<List<EventName>, Listener>>();
        this.associations = new HashMap<SOption, List<String>>();
    }

    public void reload() {
        for (Couple<List<EventName>, Listener> couple : this.registered.values()) {
            if (couple == null) continue;
            if (couple.getElem1() != null) {
                for (EventName eN : (List)couple.getElem1()) {
                    DynamicRegistration.getInstance().unregister(eN, (JavaPlugin)ExecutableItems.plugin);
                }
            }
            if (couple.getElem2() == null) continue;
            HandlerList.unregisterAll((Listener)((Listener)couple.getElem2()));
        }
        this.init();
    }

    public void read(ActivatorEIFeature activator) {
        String parentInfo = activator.getParentInfo() + activator.getId();
        SOption option = activator.getOption();
        if (this.associations.containsKey(option)) {
            List<String> list = this.associations.get(option);
            if (list.contains(parentInfo)) {
                return;
            }
            list.add(parentInfo);
            this.associations.put(option, list);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(parentInfo);
            this.associations.put(option, list);
        }
    }

    public void read(SOption option) {
        if (!(option instanceof Option)) {
            return;
        }
        Option o = (Option)option;
        if (!this.registered.containsKey(o)) {
            ArrayList<EventName> eventsName = new ArrayList<EventName>();
            Object mainListerner = null;
            switch (o) {
                case EI_ENTER_IN_THE_PLAYER_INVENTORY: {
                    if (SCore.is1v12Less()) {
                        mainListerner = ItemEnterInventoryListener.getInstance();
                        break;
                    }
                    mainListerner = ItemEnterInventoryListener1v12Plus.getInstance();
                    break;
                }
                case EI_LEAVE_THE_PLAYER_INVENTORY: {
                    mainListerner = SCore.is1v12Less() ? ItemLeaveInventoryListener.getInstance() : ItemLeaveInventoryListener1v12Plus.getInstance();
                    if (!SCore.hasProtocolLib) break;
                    ProtocolibAPI.listenCustomDropEventFromProtocolib();
                    break;
                }
                case EI_CLICK_ON_ANOTHER_INVENTORY_ITEM: {
                    mainListerner = ItemClickInventoryItemListener.getInstance();
                    break;
                }
                case PLAYER_RIGHT_CLICK: {
                    eventsName.add(EventName.PLAYER_RIGHT_CLICK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RIGHT_CLICK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerRightClickEvent();
                    break;
                }
                case PLAYER_ALL_CLICK: {
                    eventsName.add(EventName.PLAYER_RIGHT_CLICK_EVENT);
                    eventsName.add(EventName.PLAYER_LEFT_CLICK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RIGHT_CLICK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_LEFT_CLICK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerAllClickListener();
                    break;
                }
                case PLAYER_LEFT_CLICK: {
                    eventsName.add(EventName.PLAYER_LEFT_CLICK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_LEFT_CLICK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerLeftClickEvent();
                    break;
                }
                case PLAYER_CONSUME: {
                    mainListerner = new PlayerConsumeListener();
                    break;
                }
                case PLAYER_CONSUME_THE_EI: {
                    mainListerner = new PlayerConsumeTheEIListener();
                    break;
                }
                case PLAYER_DROP_ITEM: {
                    mainListerner = new PlayerDropItemEvent();
                    break;
                }
                case PLAYER_DROP_THE_EI: {
                    mainListerner = new PlayerDropTheEIEvent();
                    break;
                }
                case PLAYER_CLICK_ON_PLAYER: {
                    eventsName.add(EventName.PLAYER_RIGHT_CLICK_ON_PLAYER_EVENT);
                    eventsName.add(EventName.PLAYER_LEFT_CLICK_ON_PLAYER_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RIGHT_CLICK_ON_PLAYER_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_LEFT_CLICK_ON_PLAYER_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerClickOnPlayerListener();
                    break;
                }
                case PLAYER_ENABLE_FLY: {
                    eventsName.add(EventName.PLAYER_ENABLE_FLY_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_ENABLE_FLY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerEnableFlyEvent();
                    break;
                }
                case PLAYER_ENABLE_GLIDE: {
                    eventsName.add(EventName.PLAYER_ENABLE_GLIDE_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_ENABLE_GLIDE_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerEnableGlideEvent();
                    break;
                }
                case PLAYER_ENABLE_SNEAK: {
                    eventsName.add(EventName.PLAYER_ENABLE_SNEAK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_ENABLE_SNEAK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerEnableSneakEvent();
                    break;
                }
                case PLAYER_ENABLE_SPRINT: {
                    eventsName.add(EventName.PLAYER_ENABLE_SPRINT_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_ENABLE_SPRINT_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerEnableSprintEvent();
                    break;
                }
                case PLAYER_EXPERIENCE_CHANGE: {
                    mainListerner = new PlayerExpChangeListener();
                    break;
                }
                case PLAYER_BED_ENTER: {
                    mainListerner = new PlayerBedEnterListener();
                    break;
                }
                case PLAYER_BED_LEAVE: {
                    mainListerner = new PlayerLeaveBedEvent();
                    break;
                }
                case PLAYER_BEFORE_DEATH: {
                    eventsName.add(EventName.PLAYER_BEFORE_DEATH_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_BEFORE_DEATH_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerBeforeDeathListener();
                    break;
                }
                case PLAYER_BLOCK_BREAK: {
                    if (Dependency.EXECUTABLE_BLOCKS.isInstalled()) {
                        mainListerner = new PlayerBlockBreakWithEBListener();
                        break;
                    }
                    mainListerner = new PlayerBlockBreakListener();
                    break;
                }
                case PLAYER_BLOCK_HIT_OF_ENTITY: {
                    mainListerner = new PlayerBlockHitEntityListener();
                    break;
                }
                case PLAYER_BLOCK_HIT_OF_PLAYER: {
                    mainListerner = new PlayerBlockHitPlayerListener();
                    break;
                }
                case PLAYER_BLOCK_PLACE: {
                    mainListerner = new PlayerBlockPlaceListener();
                    break;
                }
                case PLAYER_BREAK_SHIELD_OF_PLAYER: {
                    mainListerner = new PlayerBreakShieldOfPlayerListener();
                    break;
                }
                case PLAYER_SHIELD_BREAK_BY_PLAYER: {
                    mainListerner = new PlayerShieldBreakByPlayerListener();
                    break;
                }
                case PLAYER_BRUSH_BLOCK: {
                    mainListerner = new PlayerBrushBlockListener();
                    break;
                }
                case PLAYER_CHANGE_WORLD: {
                    mainListerner = new PlayerChangeWorldListener();
                    break;
                }
                case PLAYER_CLICK_ON_ENTITY: {
                    eventsName.add(EventName.PLAYER_RIGHT_CLICK_ON_ENTITY_EVENT);
                    eventsName.add(EventName.PLAYER_LEFT_CLICK_ON_ENTITY_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RIGHT_CLICK_ON_ENTITY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_LEFT_CLICK_ON_ENTITY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerClickOnEntityListener();
                    break;
                }
                case PLAYER_CONNECTION: {
                    mainListerner = new PlayerConnectionListener();
                    break;
                }
                case PLAYER_DISCONNECT: {
                    mainListerner = new PlayerDisconnectListener();
                    break;
                }
                case PLAYER_DISMOUNT: {
                    if (!SCore.isPaperOrFork()) break;
                    mainListerner = new PlayerDismountEvent();
                    break;
                }
                case PLAYER_DEATH: {
                    mainListerner = new PlayerDeathListener();
                    break;
                }
                case PLAYER_DISABLE_FLY: {
                    eventsName.add(EventName.PLAYER_DISABLE_FLY_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_DISABLE_FLY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerDisableFlyListener();
                    break;
                }
                case PLAYER_DISABLE_GLIDE: {
                    eventsName.add(EventName.PLAYER_DISABLE_GLIDE_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_DISABLE_GLIDE_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerDisableGlideListener();
                    break;
                }
                case PLAYER_DISABLE_SNEAK: {
                    eventsName.add(EventName.PLAYER_DISABLE_SNEAK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_DISABLE_SNEAK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerDisableSneakListener();
                    break;
                }
                case PLAYER_DISABLE_SPRINT: {
                    eventsName.add(EventName.PLAYER_DISABLE_SPRINT_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_DISABLE_SPRINT_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerDisableSprintListener();
                    break;
                }
                case PLAYER_EDIT_BOOK: {
                    mainListerner = new PlayerEditBookEvent();
                    break;
                }
                case PLAYER_FERTILIZE_BLOCK: {
                    mainListerner = new PlayerFertilizeBlockEvent();
                    break;
                }
                case PLAYER_FILL_BUCKET: {
                    mainListerner = new PlayerBucketFillListener();
                    break;
                }
                case PLAYER_FISH_BLOCK: {
                    eventsName.add(EventName.PLAYER_FISH_BLOCK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_FISH_BLOCK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerFishBlockEvent();
                    break;
                }
                case PLAYER_FISH_ENTITY: {
                    eventsName.add(EventName.PLAYER_FISH_ENTITY_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_FISH_ENTITY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerFishEntityEvent();
                    break;
                }
                case PLAYER_FISH_FISH: {
                    eventsName.add(EventName.PLAYER_FISH_FISH_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_FISH_FISH_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerFishFishEvent();
                    break;
                }
                case PLAYER_FISH_NOTHING: {
                    if (SCore.is1v13Less()) break;
                    eventsName.add(EventName.PLAYER_FISH_NOTHING_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_FISH_NOTHING_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerFishNothingEvent();
                    break;
                }
                case PLAYER_FISH_PLAYER: {
                    eventsName.add(EventName.PLAYER_FISH_PLAYER_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_FISH_PLAYER_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerFishPlayerEvent();
                    break;
                }
                case PLAYER_FISH_XIAOMOMI_FISH: {
                    if (!Dependency.CUSTOM_FISHING.isInstalled()) break;
                    mainListerner = new PlayerFishXiaomomiFishListener();
                    break;
                }
                case PLAYER_ITEM_BREAK: {
                    mainListerner = new PlayerItemBreakEvent();
                    break;
                }
                case PLAYER_HIT_ENTITY: {
                    mainListerner = new PlayerHitEntityEvent();
                    break;
                }
                case PLAYER_HIT_PLAYER: {
                    mainListerner = new PlayerHitPlayerEvent();
                    break;
                }
                case PLAYER_EI_BREAK: {
                    mainListerner = new PlayerEIBreakEvent();
                    break;
                }
                case PLAYER_JUMP: {
                    eventsName.add(EventName.PLAYER_JUMP_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_JUMP_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerJumpEvent();
                    break;
                }
                case PLAYER_KILL_ENTITY: {
                    eventsName.add(EventName.PLAYER_KILL_ENTITY_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_KILL_ENTITY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerKillEntityEvent();
                    break;
                }
                case PLAYER_KILL_PLAYER: {
                    eventsName.add(EventName.PLAYER_KILL_PLAYER_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_KILL_PLAYER_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerKillPlayerEvent();
                    break;
                }
                case PLAYER_OPEN_INVENTORY: {
                    mainListerner = new PlayerOpenInventoryListener();
                    break;
                }
                case PLAYER_HARVEST_BLOCK: {
                    mainListerner = new PlayerHarvestBlockListener();
                    break;
                }
                case PLAYER_MEND_THE_EI: {
                    mainListerner = new PlayerMendTheEIListener();
                    break;
                }
                case PLAYER_KICK: {
                    mainListerner = new PlayerKickListener();
                    break;
                }
                case PLAYER_PORTAL: {
                    mainListerner = new PlayerPortalListener();
                    break;
                }
                case PLAYER_WRITE_COMMAND: {
                    mainListerner = new PlayerWriteCommandEvent();
                    break;
                }
                case PLAYER_REGAIN_HEALTH: {
                    mainListerner = new PlayerRegainHealthListener();
                    break;
                }
                case PLAYER_RIPTIDE: {
                    mainListerner = new PlayerRiptideListener();
                    break;
                }
                case PLAYER_BUCKET_ENTITY: {
                    mainListerner = new PlayerBucketEntityListener();
                    break;
                }
                case PLAYER_RECEIVE_HIT_BY_ENTITY: {
                    eventsName.add(EventName.PLAYER_RECEIVE_HIT_BY_ENTITY_EVENT);
                    eventsName.add(EventName.PROJECTILE_HIT_PLAYER);
                    DynamicRegistration.getInstance().register(EventName.PROJECTILE_HIT_PLAYER, (JavaPlugin)ExecutableItems.plugin);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RECEIVE_HIT_BY_ENTITY_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerReceiveHitByEntityEvent();
                    break;
                }
                case PLAYER_RECEIVE_HIT_BY_PLAYER: {
                    eventsName.add(EventName.PLAYER_RECEIVE_HIT_BY_PLAYER_EVENT);
                    eventsName.add(EventName.PROJECTILE_HIT_PLAYER);
                    DynamicRegistration.getInstance().register(EventName.PROJECTILE_HIT_PLAYER, (JavaPlugin)ExecutableItems.plugin);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RECEIVE_HIT_BY_PLAYER_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerReceiveHitByPlayerEvent();
                    break;
                }
                case PLAYER_RECEIVE_HIT_GLOBAL: {
                    eventsName.add(EventName.PLAYER_RECEIVE_HIT_GLOBAL_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RECEIVE_HIT_GLOBAL_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerReceiveHitGlobalEvent();
                    break;
                }
                case PLAYER_RESPAWN: {
                    mainListerner = new PlayerRespawnEvent();
                    break;
                }
                case PLAYER_SHEAR_ENTITY: {
                    mainListerner = new PlayerShearEntityEvent();
                    break;
                }
                case PLAYER_SPAWN_CHANGE: {
                    if (SCore.isPaperOrFork()) {
                        mainListerner = new PlayerSetSpawnListener();
                        break;
                    }
                    mainListerner = new PlayerSpawnChangeListener();
                    break;
                }
                case PLAYER_TARGETED_BY_AN_ENTITY: {
                    mainListerner = new PlayerTargetedByAnEntityEvent();
                    break;
                }
                case PLAYER_TRAMPLE_CROP: {
                    eventsName.add(EventName.PLAYER_TRAMPLE_CROP_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_TRAMPLE_CROP_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerTrampleCropEvent();
                    break;
                }
                case INVENTORY_CLICK: {
                    mainListerner = new PlayerInventoryClickEvent();
                    break;
                }
                case PLAYER_ENTER_IN_THEIR_LAND: {
                    if (!SCore.hasLands) break;
                    mainListerner = new PlayerEnterLandsEventEI();
                    break;
                }
                case PLAYER_LEAVE_THEIR_LAND: {
                    if (!SCore.hasLands) break;
                    mainListerner = new PlayerLeaveLandsEventEI();
                    break;
                }
                case PLAYER_EQUIP_THE_EI: {
                    eventsName.add(EventName.PLAYER_EQUIP_ARMOR_EVENT);
                    eventsName.add(EventName.PLAYER_RIGHT_CLICK_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_EQUIP_ARMOR_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_RIGHT_CLICK_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerEquipEIEvent();
                    break;
                }
                case PLAYER_UNEQUIP_THE_EI: {
                    eventsName.add(EventName.PLAYER_EQUIP_ARMOR_EVENT);
                    DynamicRegistration.getInstance().register(EventName.PLAYER_EQUIP_ARMOR_EVENT, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new PlayerUnequipEIEvent();
                    break;
                }
                case PROJECTILE_HIT_BLOCK: {
                    eventsName.add(EventName.PROJECTILE_HIT_BLOCK);
                    DynamicRegistration.getInstance().register(EventName.PROJECTILE_HIT_BLOCK, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new ProjectileHitBlockEvent();
                    break;
                }
                case PROJECTILE_HIT_ENTITY: {
                    eventsName.add(EventName.PROJECTILE_HIT_ENTITY);
                    DynamicRegistration.getInstance().register(EventName.PROJECTILE_HIT_ENTITY, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new ProjectileHitEntityEvent();
                    break;
                }
                case PROJECTILE_HIT_PLAYER: {
                    eventsName.add(EventName.PROJECTILE_HIT_PLAYER);
                    DynamicRegistration.getInstance().register(EventName.PROJECTILE_HIT_PLAYER, (JavaPlugin)ExecutableItems.plugin);
                    mainListerner = new ProjectileHitPlayerEvent();
                    break;
                }
                case PLAYER_LAUNCH_PROJECTILE: {
                    break;
                }
                case PLAYER_CUSTOM_LAUNCH: {
                    mainListerner = new PlayerCustomLaunchListener();
                    break;
                }
                case PLAYER_RECEIVE_EFFECT: {
                    mainListerner = new PlayerReceiveEffectEvent();
                    break;
                }
                case PLAYER_WALK: {
                    mainListerner = new PlayerWalkEvent();
                    break;
                }
                case PLAYER_SELECT_THE_EI: {
                    mainListerner = new PlayerSelectTheEIEvent();
                    break;
                }
                case PLAYER_DESELECT_THE_EI: {
                    mainListerner = new PlayerDeselectTheEIListener();
                    break;
                }
                case PLAYER_SWAPHAND_THE_EI: {
                    mainListerner = new PlayerSwapHandTheEIListener();
                }
            }
            if (mainListerner != null) {
                ExecutableItems.plugin.getServer().getPluginManager().registerEvents((Listener)mainListerner, (Plugin)ExecutableItems.plugin);
                this.registered.put(o, (Couple<List<EventName>, Listener>)new Couple(eventsName, mainListerner));
            }
        }
    }

    public void displayOptimisation() {
        Utils.sendConsoleMsg((String)"&bExecutableItems &7================ &f[ExecutableItems Check Options] &7================");
        Utils.sendConsoleMsg((String)"&7All options available in ExecutableItems: ");
        Utils.sendConsoleMsg((String)"&atrue&7: an ExecutableItem has an activator that use it.");
        Utils.sendConsoleMsg((String)"&cfalse&7: no ExecutableItem require this event. (better performance)");
        Utils.sendConsoleMsg((String)"&7Use only what you need, more false = better performance");
        ExecutableItems.plugin.getServer().getLogger().info("");
        for (Option o : Option.values()) {
            String color = "&a";
            if (!this.registered.containsKey(o)) {
                color = "&c";
            }
            Utils.sendConsoleMsg((String)("&e" + o + " >> " + color + this.registered.containsKey(o)));
        }
        ExecutableItems.plugin.getServer().getLogger().info("");
        for (SOption o : this.associations.keySet()) {
            Utils.sendConsoleMsg((String)("&e" + o + " >> &7" + this.associations.get(o)));
        }
        Utils.sendConsoleMsg((String)"&bExecutableItems &7================ &f[ExecutableItems Check Options] &7================");
    }
}

