/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtility {
    private static final int BUFFER_SIZE = 4096;

    public void zip(List<File> listFiles, String destZipFile) throws FileNotFoundException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destZipFile));
        for (File file : listFiles) {
            if (file.isDirectory()) {
                this.zipDirectory(file, file.getName(), zos);
                continue;
            }
            this.zipFile(file, zos);
        }
        zos.flush();
        zos.close();
    }

    public void zip(String[] files, String destZipFile) throws FileNotFoundException, IOException {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            listFiles.add(new File(files[i]));
        }
        this.zip(listFiles, destZipFile);
    }

    private void zipDirectory(File folder, String parentFolder, ZipOutputStream zos) throws FileNotFoundException, IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.zipDirectory(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            long bytesRead = 0L;
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
                bytesRead += (long)read;
            }
            zos.closeEntry();
        }
    }

    private void zipFile(File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        zos.putNextEntry(new ZipEntry(file.getName()));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        long bytesRead = 0L;
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = bis.read(bytesIn)) != -1) {
            zos.write(bytesIn, 0, read);
            bytesRead += (long)read;
        }
        zos.closeEntry();
    }
}

