/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.executableitems.activators;

import com.ssomar.score.SCore;
import com.ssomar.score.sobject.sactivator.OptionGlobal;
import com.ssomar.score.sobject.sactivator.SOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Option implements SOption,
Serializable
{
    EI_ENTER_IN_THE_PLAYER_INVENTORY("EI_ENTER_IN_THE_PLAYER_INVENTORY"),
    EI_LEAVE_THE_PLAYER_INVENTORY("EI_LEAVE_THE_PLAYER_INVENTORY"),
    EI_CLICK_ON_ANOTHER_INVENTORY_ITEM("EI_CLICK_ON_ANOTHER_INVENTORY_ITEM"),
    EI_CLICKED_BY_ANOTHER_INVENTORY_ITEM("EI_CLICKED_BY_ANOTHER_INVENTORY_ITEM"),
    INVENTORY_CLICK("INVENTORY_CLICK"),
    PLAYER_ALL_CLICK("PLAYER_ALL_CLICK"),
    PLAYER_BED_ENTER("PLAYER_BED_ENTER"),
    PLAYER_BED_LEAVE("PLAYER_BED_LEAVE"),
    PLAYER_BEFORE_DEATH("PLAYER_BEFORE_DEATH"),
    PLAYER_BLOCK_BREAK("PLAYER_BLOCK_BREAK"),
    PLAYER_BLOCK_HIT_OF_PLAYER("PLAYER_BLOCK_HIT_OF_PLAYER"),
    PLAYER_BLOCK_HIT_OF_ENTITY("PLAYER_BLOCK_HIT_OF_ENTITY"),
    PLAYER_BLOCK_PLACE("PLAYER_BLOCK_PLACE"),
    PLAYER_BRUSH_BLOCK("PLAYER_BRUSH_BLOCK"),
    PLAYER_BREAK_SHIELD_OF_PLAYER("PLAYER_BREAK_SHIELD_OF_PLAYER"),
    PLAYER_SHIELD_BREAK_BY_PLAYER("PLAYER_SHIELD_BREAK_BY_PLAYER"),
    PLAYER_BUCKET_ENTITY("PLAYER_BUCKET_ENTITY"),
    PLAYER_CHANGE_WORLD("PLAYER_CHANGE_WORLD"),
    PLAYER_CLICK_ON_ENTITY("PLAYER_CLICK_ON_ENTITY"),
    PLAYER_CLICK_ON_PLAYER("PLAYER_CLICK_ON_PLAYER"),
    PLAYER_CONNECTION("PLAYER_CONNECTION"),
    PLAYER_CONSUME("PLAYER_CONSUME"),
    PLAYER_CONSUME_THE_EI("PLAYER_CONSUME_THE_EI"),
    PLAYER_CUSTOM_LAUNCH("PLAYER_CUSTOM_LAUNCH"),
    PLAYER_DEATH("PLAYER_DEATH"),
    PLAYER_DISCONNECT("PLAYER_DISCONNECT", "PLAYER_DECONNECTION"),
    PLAYER_DISABLE_FLY("PLAYER_DISABLE_FLY"),
    PLAYER_DISABLE_GLIDE("PLAYER_DISABLE_GLIDE"),
    PLAYER_DISABLE_SNEAK("PLAYER_DISABLE_SNEAK", "PLAYER_DESACTIVE_SNEAK"),
    PLAYER_DISABLE_SPRINT("PLAYER_DISABLE_SPRINT", "PLAYER_DESACTIVE_SPRINT"),
    PLAYER_DESELECT_THE_EI("PLAYER_DESELECT_THE_EI"),
    PLAYER_DISMOUNT("PLAYER_DISMOUNT"),
    PLAYER_DROP_ITEM("PLAYER_DROP_ITEM"),
    PLAYER_DROP_THE_EI("PLAYER_DROP_THE_EI"),
    PLAYER_EDIT_BOOK("PLAYER_EDIT_BOOK"),
    PLAYER_EI_BREAK("PLAYER_EI_BREAK"),
    PLAYER_EQUIP_THE_EI("PLAYER_EQUIP_THE_EI"),
    PLAYER_ENABLE_FLY("PLAYER_ENABLE_FLY", "PLAYER_ACTIVE_FLY"),
    PLAYER_ENABLE_GLIDE("PLAYER_ENABLE_GLIDE"),
    PLAYER_ENABLE_SNEAK("PLAYER_ENABLE_SNEAK", "PLAYER_ACTIVE_SNEAK"),
    PLAYER_ENABLE_SPRINT("PLAYER_ENABLE_SPRINT", "PLAYER_ACTIVE_SPRINT"),
    PLAYER_ENTER_IN_THEIR_LAND("PLAYER_ENTER_IN_THEIR_LAND", "PLAYER_ENTER_IN_HIS_LAND"),
    PLAYER_ENTER_IN_THEIR_PLOT("PLAYER_ENTER_IN_THEIR_PLOT", "PLAYER_ENTER_IN_HIS_PLOT"),
    PLAYER_EXPERIENCE_CHANGE("PLAYER_EXPERIENCE_CHANGE"),
    PLAYER_FERTILIZE_BLOCK("PLAYER_FERTILIZE_BLOCK"),
    PLAYER_FILL_BUCKET("PLAYER_FILL_BUCKET"),
    PLAYER_FISH_BLOCK("PLAYER_FISH_BLOCK"),
    PLAYER_FISH_ENTITY("PLAYER_FISH_ENTITY"),
    PLAYER_FISH_FISH("PLAYER_FISH_FISH"),
    PLAYER_FISH_NOTHING("PLAYER_FISH_NOTHING"),
    PLAYER_FISH_PLAYER("PLAYER_FISH_PLAYER"),
    PLAYER_FISH_XIAOMOMI_FISH("PLAYER_FISH_XIAOMOMI_FISH"),
    PLAYER_HARVEST_BLOCK("PLAYER_HARVEST_BLOCK"),
    PLAYER_HIT_ENTITY("PLAYER_HIT_ENTITY"),
    PLAYER_HIT_PLAYER("PLAYER_HIT_PLAYER"),
    PLAYER_ITEM_BREAK("PLAYER_ITEM_BREAK"),
    PLAYER_JUMP("PLAYER_JUMP"),
    PLAYER_KICK("PLAYER_KICK"),
    PLAYER_KILL_ENTITY("PLAYER_KILL_ENTITY"),
    PLAYER_KILL_PLAYER("PLAYER_KILL_PLAYER"),
    PLAYER_LAUNCH_PROJECTILE("PLAYER_LAUNCH_PROJECTILE"),
    PLAYER_LEAVE_THEIR_LAND("PLAYER_LEAVE_THEIR_LAND", "PLAYER_LEAVE_HIS_LAND"),
    PLAYER_LEAVE_THEIR_PLOT("PLAYER_LEAVE_THEIR_PLOT", "PLAYER_LEAVE_HIS_PLOT"),
    PLAYER_LEFT_CLICK("PLAYER_LEFT_CLICK"),
    PLAYER_MEND_THE_EI("PLAYER_MEND_THE_EI"),
    PLAYER_OPEN_INVENTORY("PLAYER_OPEN_INVENTORY"),
    PLAYER_PICKUP_THE_EI("PLAYER_PICKUP_THE_EI"),
    PLAYER_PORTAL("PLAYER_PORTAL"),
    PLAYER_WALK("PLAYER_WALK"),
    PLAYER_WRITE_COMMAND("PLAYER_WRITE_COMMAND"),
    PLAYER_RECEIVE_EFFECT("player_receive_effect"),
    PLAYER_RECEIVE_HIT_BY_ENTITY("player_receive_hit_by_entity"),
    PLAYER_RECEIVE_HIT_BY_PLAYER("player_receive_hit_by_player"),
    PLAYER_RECEIVE_HIT_GLOBAL("player_receive_hit_global"),
    PLAYER_REGAIN_HEALTH("PLAYER_REGAIN_HEALTH"),
    PLAYER_RESPAWN("PLAYER_RESPAWN"),
    PLAYER_RIGHT_CLICK("PLAYER_RIGHT_CLICK"),
    PLAYER_RIPTIDE("PLAYER_RIPTIDE"),
    PLAYER_SELECT_THE_EI("PLAYER_SELECT_THE_EI"),
    PLAYER_SHEAR_ENTITY("PLAYER_SHEAR_ENTITY"),
    PLAYER_SWAPHAND_THE_EI("PLAYER_SWAPHAND_THE_EI"),
    PLAYER_SPAWN_CHANGE("PLAYER_SPAWN_CHANGE"),
    PLAYER_TARGETED_BY_AN_ENTITY("PLAYER_TARGETED_BY_AN_ENTITY"),
    PLAYER_TRAMPLE_CROP("PLAYER_TRAMPLE_CROP"),
    PLAYER_UNEQUIP_THE_EI("PLAYER_UNEQUIP_THE_EI"),
    PROJECTILE_ENTER_IN_LIQUID("PROJECTILE_ENTER_IN_LIQUID"),
    PROJECTILE_HIT_BLOCK("PROJECTILE_HIT_BLOCK"),
    PROJECTILE_HIT_ENTITY("PROJECTILE_HIT_ENTITY"),
    PROJECTILE_HIT_PLAYER("PROJECTILE_HIT_PLAYER");

    private String[] names;

    private Option(String ... names) {
        this.names = names;
    }

    public static List<SOption> getPremiumOptionSt() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(EI_ENTER_IN_THE_PLAYER_INVENTORY);
        result.add(EI_LEAVE_THE_PLAYER_INVENTORY);
        result.add(INVENTORY_CLICK);
        result.add(PLAYER_ENABLE_FLY);
        result.add(PLAYER_ENABLE_SNEAK);
        result.add(PLAYER_ENABLE_SPRINT);
        result.add(PLAYER_BED_ENTER);
        result.add(PLAYER_BED_LEAVE);
        result.add(PLAYER_BLOCK_BREAK);
        result.add(PLAYER_BLOCK_HIT_OF_PLAYER);
        result.add(PLAYER_BLOCK_HIT_OF_ENTITY);
        result.add(PLAYER_BLOCK_PLACE);
        result.add(PLAYER_BREAK_SHIELD_OF_PLAYER);
        result.add(PLAYER_SHIELD_BREAK_BY_PLAYER);
        result.add(PLAYER_BRUSH_BLOCK);
        result.add(PLAYER_CLICK_ON_ENTITY);
        result.add(PLAYER_HIT_ENTITY);
        result.add(PLAYER_CONNECTION);
        result.add(PLAYER_DISABLE_SNEAK);
        result.add(PLAYER_DISABLE_SPRINT);
        result.add(PLAYER_DESELECT_THE_EI);
        result.add(PLAYER_DROP_THE_EI);
        result.add(PLAYER_EDIT_BOOK);
        result.add(PLAYER_EQUIP_THE_EI);
        result.add(PLAYER_ENTER_IN_THEIR_LAND);
        result.add(PLAYER_ENTER_IN_THEIR_PLOT);
        result.add(PLAYER_UNEQUIP_THE_EI);
        result.add(PLAYER_FERTILIZE_BLOCK);
        result.add(PLAYER_FISH_BLOCK);
        result.add(PLAYER_FISH_ENTITY);
        result.add(PLAYER_FISH_FISH);
        result.add(PLAYER_FISH_NOTHING);
        result.add(PLAYER_FISH_PLAYER);
        result.add(PLAYER_ITEM_BREAK);
        result.add(PLAYER_EI_BREAK);
        result.add(PLAYER_JUMP);
        result.add(PLAYER_KILL_ENTITY);
        result.add(PLAYER_KILL_PLAYER);
        result.add(PLAYER_LEAVE_THEIR_PLOT);
        result.add(PLAYER_PICKUP_THE_EI);
        result.add(PLAYER_WALK);
        result.add(PLAYER_RECEIVE_EFFECT);
        result.add(PLAYER_RECEIVE_HIT_BY_ENTITY);
        result.add(PLAYER_RECEIVE_HIT_BY_PLAYER);
        result.add(PLAYER_RECEIVE_HIT_GLOBAL);
        result.add(PLAYER_RESPAWN);
        result.add(PLAYER_SELECT_THE_EI);
        result.add(PLAYER_SHEAR_ENTITY);
        result.add(PROJECTILE_ENTER_IN_LIQUID);
        result.add(PROJECTILE_HIT_BLOCK);
        result.add(PROJECTILE_HIT_ENTITY);
        result.add(PLAYER_WRITE_COMMAND);
        result.add(PLAYER_TARGETED_BY_AN_ENTITY);
        result.add((SOption)OptionGlobal.LOOP);
        return result;
    }

    public static String getPremiumOptionAsString() {
        StringBuilder sb = new StringBuilder("");
        for (SOption option : Option.getPremiumOptionSt()) {
            sb.append(option.toString());
            sb.append(" ");
        }
        sb.substring(0, sb.length() - 1);
        return sb.toString();
    }

    public static List<Option> getOptionWithCustomProjectile() {
        ArrayList<Option> result = new ArrayList<Option>();
        return result;
    }

    public static List<Option> getOptionWithDetailedDamageCauses() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_BLOCK_HIT_OF_ENTITY);
        result.add(PLAYER_BLOCK_HIT_OF_PLAYER);
        result.add(PLAYER_DEATH);
        result.add(PLAYER_HIT_ENTITY);
        result.add(PLAYER_HIT_PLAYER);
        result.add(PLAYER_RECEIVE_HIT_BY_ENTITY);
        result.add(PLAYER_RECEIVE_HIT_BY_PLAYER);
        result.add(PLAYER_RECEIVE_HIT_GLOBAL);
        return result;
    }

    public static List<Option> getOptionWithCommand() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_WRITE_COMMAND);
        return result;
    }

    public static List<Option> getOptionWithDrops() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_KILL_ENTITY);
        result.add(PLAYER_KILL_PLAYER);
        result.add(PLAYER_BLOCK_BREAK);
        result.add(PLAYER_FISH_FISH);
        return result;
    }

    public static List<Option> getOptionWithDetailedClick() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_CLICK_ON_PLAYER);
        result.add(PLAYER_CLICK_ON_ENTITY);
        result.add(INVENTORY_CLICK);
        return result;
    }

    public static List<Option> getOptionWithDetailedEffects() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_RECEIVE_EFFECT);
        return result;
    }

    public static List<Option> getOptionWithoutDetailedSlots() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_DROP_THE_EI);
        result.add(PLAYER_EQUIP_THE_EI);
        result.add(PLAYER_UNEQUIP_THE_EI);
        result.add(PLAYER_PICKUP_THE_EI);
        result.add(PLAYER_DESELECT_THE_EI);
        result.add(PLAYER_SELECT_THE_EI);
        result.add(PLAYER_CONSUME_THE_EI);
        result.add(PLAYER_MEND_THE_EI);
        result.add(EI_CLICK_ON_ANOTHER_INVENTORY_ITEM);
        result.add(EI_CLICKED_BY_ANOTHER_INVENTORY_ITEM);
        return result;
    }

    public static List<Option> getOptionWithOnlyTypeClick() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PLAYER_RIGHT_CLICK);
        result.add(PLAYER_LEFT_CLICK);
        result.add(PLAYER_ALL_CLICK);
        return result;
    }

    public static List<Option> getOptionResultOfProjectile() {
        ArrayList<Option> result = new ArrayList<Option>();
        result.add(PROJECTILE_ENTER_IN_LIQUID);
        result.add(PROJECTILE_HIT_BLOCK);
        result.add(PROJECTILE_HIT_ENTITY);
        result.add(PROJECTILE_HIT_PLAYER);
        return result;
    }

    public static List<Option> getOptionWithRequiredThings() {
        return Arrays.asList(Option.values());
    }

    public static List<SOption> getOptionWithTargetBlockSt() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(PLAYER_FILL_BUCKET);
        result.add(PLAYER_RIGHT_CLICK);
        result.add(PLAYER_LEFT_CLICK);
        result.add(PLAYER_ALL_CLICK);
        result.add(PLAYER_BLOCK_BREAK);
        result.add(PLAYER_BLOCK_PLACE);
        result.add(PLAYER_BRUSH_BLOCK);
        result.add(PROJECTILE_ENTER_IN_LIQUID);
        result.add(PROJECTILE_HIT_BLOCK);
        result.add(PLAYER_FERTILIZE_BLOCK);
        result.add(PLAYER_FISH_BLOCK);
        result.add(PLAYER_TRAMPLE_CROP);
        result.add(PLAYER_HARVEST_BLOCK);
        return result;
    }

    public static List<SOption> getOptionWithTargetItemSt() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(PLAYER_DROP_ITEM);
        result.add(PLAYER_CONSUME);
        result.add(EI_CLICK_ON_ANOTHER_INVENTORY_ITEM);
        result.add(EI_CLICKED_BY_ANOTHER_INVENTORY_ITEM);
        return result;
    }

    public static List<SOption> getOptionWithTargetEntitySt() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(PLAYER_KILL_ENTITY);
        result.add(PLAYER_CLICK_ON_ENTITY);
        result.add(PLAYER_RECEIVE_HIT_BY_ENTITY);
        result.add(PROJECTILE_HIT_ENTITY);
        result.add(PLAYER_FISH_ENTITY);
        result.add(PLAYER_FISH_FISH);
        result.add(PLAYER_SHEAR_ENTITY);
        result.add(PLAYER_DISMOUNT);
        result.add(PLAYER_LAUNCH_PROJECTILE);
        result.add(PLAYER_CUSTOM_LAUNCH);
        result.add(PLAYER_TARGETED_BY_AN_ENTITY);
        result.add(PLAYER_HIT_ENTITY);
        result.add(PLAYER_BUCKET_ENTITY);
        result.add(PLAYER_BLOCK_HIT_OF_ENTITY);
        result.add(PLAYER_DROP_THE_EI);
        result.add(PLAYER_FISH_NOTHING);
        return result;
    }

    public static List<SOption> getOptionWithTargetPlayerSt() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(PLAYER_KILL_PLAYER);
        result.add(PLAYER_CLICK_ON_PLAYER);
        result.add(PLAYER_RECEIVE_HIT_BY_PLAYER);
        result.add(PROJECTILE_HIT_PLAYER);
        result.add(PLAYER_FISH_PLAYER);
        result.add(PLAYER_HIT_PLAYER);
        result.add(PLAYER_BLOCK_HIT_OF_PLAYER);
        result.add(PLAYER_BREAK_SHIELD_OF_PLAYER);
        result.add(PLAYER_SHIELD_BREAK_BY_PLAYER);
        return result;
    }

    public List<SOption> getPremiumOption() {
        List<SOption> opts = Option.getPremiumOptionSt();
        opts.addAll(super.getPremiumOption());
        return opts;
    }

    public boolean isValidOption(String entry) {
        for (Option option : Option.values()) {
            for (String name : option.getNames()) {
                if (!name.equalsIgnoreCase(entry)) continue;
                return true;
            }
        }
        return super.isValidOption(entry);
    }

    public SOption getOption(String entry) {
        for (Option option : Option.values()) {
            for (String name : option.getNames()) {
                if (!name.equalsIgnoreCase(entry)) continue;
                return option;
            }
        }
        return super.getOption(entry);
    }

    public List<SOption> getValues() {
        ArrayList<SOption> result = new ArrayList<SOption>(Arrays.asList(Option.values()));
        result.addAll(super.getValues());
        if (!SCore.is1v20Plus()) {
            result.remove(PLAYER_BRUSH_BLOCK);
        }
        return result;
    }

    public SOption getDefaultValue() {
        return PLAYER_ALL_CLICK;
    }

    public boolean containsThisName(String entry) {
        for (String name : this.getNames()) {
            if (!name.equalsIgnoreCase(entry)) continue;
            return true;
        }
        return super.containsThisName(entry);
    }

    public String[] getNames() {
        return this.names;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public List<SOption> getOptionWithBlock() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.addAll(super.getOptionWithBlock());
        return result;
    }

    public List<SOption> getOptionWithOwner() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.addAll(super.getOptionWithOwner());
        return result;
    }

    public List<SOption> getOptionWithPlayer() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.addAll(Arrays.asList(Option.values()));
        result.add((SOption)OptionGlobal.CUSTOM_TRIGGER);
        result.addAll(super.getOptionWithPlayer());
        return result;
    }

    public List<SOption> getOptionWithEntity() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.addAll(super.getOptionWithEntity());
        return result;
    }

    public List<SOption> getOptionWithTargetBlock() {
        List<SOption> opts = Option.getOptionWithTargetBlockSt();
        opts.addAll(super.getOptionWithTargetBlock());
        return opts;
    }

    public List<SOption> getOptionWithTargetItem() {
        List<SOption> opts = Option.getOptionWithTargetItemSt();
        opts.addAll(super.getOptionWithTargetItem());
        return opts;
    }

    public List<SOption> getOptionWithTargetEntity() {
        List<SOption> opts = Option.getOptionWithTargetEntitySt();
        opts.addAll(super.getOptionWithTargetEntity());
        return opts;
    }

    public List<SOption> getOptionWithTargetPlayer() {
        List<SOption> opts = Option.getOptionWithTargetPlayerSt();
        opts.addAll(super.getOptionWithTargetPlayer());
        return opts;
    }

    public List<SOption> getOptionWithWorld() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.addAll(Arrays.asList(Option.values()));
        result.add((SOption)OptionGlobal.CUSTOM_TRIGGER);
        result.addAll(super.getOptionWithWorld());
        return result;
    }

    public List<SOption> getOptionWithItem() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.addAll(Arrays.asList(Option.values()));
        result.addAll(super.getOptionWithItem());
        result.add((SOption)OptionGlobal.CUSTOM_TRIGGER);
        result.removeAll(Option.getOptionResultOfProjectile());
        return result;
    }

    public boolean isLoopOption() {
        return super.isLoopOption();
    }

    public String getName() {
        return this.name();
    }
}

