/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners;

import com.bgsoftware.wildstacker.api.WildStackerAPI;
import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.item.ItemEnterInventoryListener;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.usedapi.MyCoreProtectAPI;
import com.ssomar.score.utils.backward_compatibility.SoundUtils;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class PlayerPickupLimit1v8
implements Listener {
    private static SendMessage sm = new SendMessage();
    private static final boolean DEBUG = true;

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void playerPickup(PlayerPickupItemEvent e) {
        Player p = e.getPlayer();
        PlayerPickupLimit1v8.onPickup(p, e.getItem(), (Cancellable)e, (Event)e);
    }

    @EventHandler
    public void onplayerTransferInventory(InventoryClickEvent e) {
        PlayerPickupLimit1v8.onInvTransfer(e);
    }

    public static void onInvTransfer(InventoryClickEvent e) {
        Inventory inv = null;
        try {
            inv = e.getClickedInventory();
        }
        catch (Exception ex) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player) || inv == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        ItemStack itemP = e.getClick() == ClickType.NUMBER_KEY ? p.getInventory().getItem(e.getHotbarButton()) : e.getCurrentItem();
        ExecutableItemObject ei = new ExecutableItemObject(itemP);
        if (!ei.isValid()) {
            return;
        }
        if (inv.getType() != InventoryType.PLAYER) {
            int cpt = 0;
            int limit = GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.pickupLimit.name(), 100000);
            if (limit == -1) {
                limit = 100000;
            } else {
                for (ItemStack item : p.getInventory().getContents()) {
                    if (item == null || !new ExecutableItemObject(item).isValid()) continue;
                    cpt += item.getAmount();
                }
                if (itemP == null) {
                    return;
                }
                if (cpt + itemP.getAmount() > limit) {
                    e.setCancelled(true);
                    sm.sendMessage(p, StringConverter.coloredString((String)MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.PICKUP_LIMIT_MESSAGE)).replaceAll("%limit%", "" + GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.pickupLimit.name(), 100000)));
                    return;
                }
            }
        }
    }

    public static void onPickup(Player p, Item itemForm, Cancellable e, Event event) {
        int quantity;
        if (CommandsHandler.getInstance().hasStopPickup(p)) {
            e.setCancelled(true);
            return;
        }
        ItemStack item = itemForm.getItemStack();
        PlayerInventory playerInventory = p.getInventory();
        boolean pickup = false;
        int initialQuantity = quantity = item.getAmount();
        int quantityCanceled = 0;
        int quandtityDelete = 0;
        if (SCore.hasWildStacker) {
            quantity = WildStackerAPI.getItemAmount((Item)itemForm);
        }
        SsomarDev.testMsg((String)("Quantity: " + quantity), (boolean)true);
        for (int i = 0; i < initialQuantity; ++i) {
            SsomarDev.testMsg((String)("i: " + i), (boolean)true);
            ItemStack addItem = item.clone();
            addItem.setAmount(1);
            ExecutableItemObject ei = new ExecutableItemObject(addItem);
            if (ei.isValid()) {
                SsomarDev.testMsg((String)"Limit check", (boolean)true);
                int cpt = 0;
                int limit = GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.pickupLimit.name(), 100000);
                if (p.getItemOnCursor() != null && new ExecutableItemObject(p.getItemOnCursor()).isValid()) {
                    cpt = 1;
                }
                if (limit != -1) {
                    for (ItemStack it : playerInventory.getContents()) {
                        if (it == null || !new ExecutableItemObject(it).isValid()) continue;
                        cpt += it.getAmount();
                    }
                    if (cpt >= limit) {
                        ++quantityCanceled;
                        continue;
                    }
                }
                int firstEmpty = playerInventory.firstEmpty();
                Map<Integer, ItemStack> map = PlayerPickupLimit1v8.allQtyNotCheck(playerInventory, addItem);
                for (Map.Entry<Integer, ItemStack> entry : map.entrySet()) {
                    if (entry.getValue().getAmount() >= addItem.getMaxStackSize()) continue;
                    firstEmpty = entry.getKey();
                    break;
                }
                SsomarDev.testMsg((String)"Generate pickup event", (boolean)true);
                EventInfo eInfo = new EventInfo((Event)e);
                eInfo.setPlayer(Optional.of(p));
                eInfo.setMainHand(true);
                eInfo.setSlot(Optional.of(firstEmpty));
                ExecutableItem infoItem = ei.getConfig();
                boolean canceledOrDeleted = false;
                for (SActivator activator : infoItem.getActivators().getActivators().values()) {
                    if (!activator.getOption().equals((Object)Option.PLAYER_PICKUP_THE_EI)) continue;
                    activator.runWithException((Object)ei, eInfo);
                    if (addItem.getType() == Material.AIR) {
                        SsomarDev.testMsg((String)"1) Deleted with usage", (boolean)true);
                        ++quandtityDelete;
                        canceledOrDeleted = true;
                        continue;
                    }
                    if (!((Cancellable)eInfo.getEventSource()).isCancelled()) continue;
                    SsomarDev.testMsg((String)"Canceled with usage", (boolean)true);
                    ++quantityCanceled;
                    canceledOrDeleted = true;
                }
                if (canceledOrDeleted) continue;
                SsomarDev.testMsg((String)"Generate enter event", (boolean)true);
                ItemEnterInventoryListener.getInstance();
                ItemEnterInventoryListener.activeItemEnterInventory(addItem, firstEmpty, p, event);
                if (addItem.getType() == Material.AIR) {
                    ++quandtityDelete;
                    SsomarDev.testMsg((String)"2) Deleted with usage", (boolean)true);
                    continue;
                }
                HashMap notGiven = playerInventory.addItem(new ItemStack[]{addItem});
                if (SCore.hasCoreProtect) {
                    new MyCoreProtectAPI().addPickup(itemForm.getLocation(), addItem, p);
                }
                SsomarDev.testMsg((String)("add item to inventory > " + notGiven.size()), (boolean)true);
                pickup = true;
                if (!notGiven.isEmpty()) continue;
                --quantity;
                continue;
            }
            return;
        }
        SsomarDev.testMsg((String)("Pickup ? " + pickup + " drop on the floor > " + quantity + " quantity deleted > " + quandtityDelete + " quantity canceled > " + quantityCanceled), (boolean)true);
        if (pickup) {
            Sound sound = SoundUtils.getSound((String)"ITEM_PICKUP");
            p.getLocation().getWorld().playSound(p.getLocation(), sound, 0.3f, 1.0f);
        }
        e.setCancelled(true);
        if (initialQuantity == quantityCanceled) {
            SsomarDev.testMsg((String)"Canceled all quantity", (boolean)true);
            return;
        }
        int finalQuantityDrop = quantity - quandtityDelete;
        if (finalQuantityDrop == 0) {
            itemForm.remove();
        } else {
            itemForm.remove();
            item.setAmount(finalQuantityDrop);
            p.getWorld().dropItem(p.getLocation(), item);
        }
    }

    public static Map<Integer, ItemStack> allQtyNotCheck(PlayerInventory inventory, ItemStack checkItem) {
        HashMap<Integer, ItemStack> result = new HashMap<Integer, ItemStack>();
        int i = 0;
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack != null && itemStack.isSimilar(checkItem)) {
                result.put(i, itemStack);
            }
            ++i;
        }
        return result;
    }
}

