/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.restrictions;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.executableitems.listeners.player.custom.PlayerInventoryClickEvent;
import com.ssomar.executableitems.usedapi.CustomCraftingHook;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.custom.restrictions.RestrictionEnum;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Horse;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ResctrictionsEvt
implements Listener {
    public SendMessage sm = new SendMessage();
    private boolean debug = false;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerArmorStandManipulateEvent(PlayerArmorStandManipulateEvent e) {
        ItemStack item = e.getPlayerItem();
        Player p = e.getPlayer();
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ExecutableItemObject ei = new ExecutableItemObject(item);
        if (!ei.isValid()) {
            return;
        }
        ExecutableItem infoItem = ei.getConfig();
        if (infoItem.getRestrictions().is(RestrictionEnum.CANCEL_ARMORSTAND)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDropItemEvent(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        ExecutableItemObject ei = new ExecutableItemObject(item);
        if (!ei.isValid()) {
            return;
        }
        if (ei.getConfig().getRestrictions().is(RestrictionEnum.CANCEL_DROP)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTryToDropItemEvent(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        ExecutableItemsManager iM = ExecutableItemsManager.getInstance();
        InventoryAction iAction = e.getAction();
        ClickType clickType = e.getClick();
        if (iAction.equals((Object)InventoryAction.SWAP_WITH_CURSOR)) {
            ItemStack itemS = e.getCurrentItem();
            if (itemS == null) {
                return;
            }
            ExecutableItemObject ei = new ExecutableItemObject(itemS);
            if (!ei.isValid()) {
                return;
            }
            ExecutableItem infoItem = ei.getConfig();
            if (SCore.is1v11Less()) {
                for (ItemStack i : p.getInventory().getContents()) {
                    if (i != null) continue;
                    return;
                }
            } else {
                for (ItemStack i : p.getInventory().getStorageContents()) {
                    if (i != null) continue;
                    return;
                }
            }
            if (infoItem.getRestrictions().is(RestrictionEnum.CANCEL_DROP)) {
                e.setCancelled(true);
            }
        } else if (iAction.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            ItemStack itemS = e.getCursor();
            if (itemS == null) {
                return;
            }
            ExecutableItemObject ei = new ExecutableItemObject(itemS);
            if (!ei.isValid()) {
                return;
            }
            ExecutableItem infoItem = ei.getConfig();
            boolean moreThanOneSlotEmpty = false;
            for (ItemStack i : p.getInventory().getStorageContents()) {
                if (i != null) continue;
                if (moreThanOneSlotEmpty) {
                    return;
                }
                moreThanOneSlotEmpty = true;
            }
            if (infoItem.getRestrictions().is(RestrictionEnum.CANCEL_DROP)) {
                e.setCancelled(true);
            }
        } else if (iAction.equals((Object)InventoryAction.DROP_ONE_SLOT)) {
            ItemStack itemS = e.getCurrentItem();
            if (itemS == null) {
                return;
            }
            ExecutableItemObject ei = new ExecutableItemObject(itemS);
            if (!ei.isValid()) {
                return;
            }
            ExecutableItem infoItem = ei.getConfig();
            if (infoItem.getRestrictions().is(RestrictionEnum.CANCEL_DROP)) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent e) {
        ItemStack item = e.getItem();
        Player p = e.getPlayer();
        ExecutableItemObject ei = new ExecutableItemObject(item);
        if (!ei.isValid()) {
            return;
        }
        ExecutableItem infoItem = ei.getConfig();
        if (e.hasBlock()) {
            if (e.getClickedBlock().getType().equals((Object)Material.FLOWER_POT) && infoItem.getRestrictions().is(RestrictionEnum.CANCEL_PLACE)) {
                e.setCancelled(true);
            } else if (!SCore.is1v13Less() && !e.useInteractedBlock().equals((Object)Event.Result.DENY) && e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && e.getClickedBlock().getType().equals((Object)Material.COMPOSTER) && infoItem.getRestrictions().is(RestrictionEnum.CANCEL_COMPOSTER)) {
                e.setCancelled(true);
            }
            if (SCore.is1v19Plus() && e.getClickedBlock().getType().equals((Object)Material.LECTERN) && infoItem.getRestrictions().is(RestrictionEnum.CANCEL_LECTERN)) {
                e.setCancelled(true);
            }
            if (SCore.is1v20Plus() && e.getClickedBlock().getType().equals((Object)Material.DECORATED_POT) && infoItem.getRestrictions().is(RestrictionEnum.CANCEL_DECORATED_POT)) {
                e.setCancelled(true);
            }
        }
        if (SCore.is1v19Plus() && item.getType() == Material.GOAT_HORN && infoItem.getRestrictions().is(RestrictionEnum.CANCEL_HORN)) {
            e.setCancelled(true);
            p.stopAllSounds();
            p.setCooldown(Material.GOAT_HORN, 0);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        ItemStack item = e.getItemInHand();
        ExecutableItemObject ei = new ExecutableItemObject(item);
        if (!ei.isValid()) {
            return;
        }
        ExecutableItem infoItem = ei.getConfig();
        boolean haveInteraction = false;
        String itemType = item.getType().toString();
        if (item.getType().toString().contains("SHOVEL")) {
            haveInteraction = true;
        } else if (itemType.contains("WOODEN_AXE") || itemType.contains("STONE_AXE") || itemType.contains("IRON_AXE") || itemType.contains("GOLDEN_AXE") || itemType.contains("DIAMOND_AXE") || itemType.contains("NETHERITE_AXE")) {
            haveInteraction = true;
        } else if (itemType.contains("HOE")) {
            haveInteraction = true;
        } else if (itemType.contains("FLINT_AND_STEEL")) {
            haveInteraction = true;
        }
        boolean cancelInteractions = infoItem.getRestrictions().is(RestrictionEnum.CANCEL_TOOL_INTERACTIONS);
        if (cancelInteractions && haveInteraction) {
            e.setCancelled(true);
        } else if (!cancelInteractions && haveInteraction) {
            return;
        }
        if (infoItem.getRestrictions().is(RestrictionEnum.CANCEL_PLACE)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerShearEntityEvent(PlayerShearEntityEvent e) {
        ItemStack item = e.getItem();
        ExecutableItemObject ei = new ExecutableItemObject(item);
        if (!ei.isValid()) {
            return;
        }
        ExecutableItem infoItem = ei.getConfig();
        boolean cancelInteractions = infoItem.getRestrictions().is(RestrictionEnum.CANCEL_TOOL_INTERACTIONS);
        if (cancelInteractions) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareCraft(CraftItemEvent e) {
        boolean cancel = false;
        for (ItemStack item : e.getInventory().getMatrix()) {
            if (cancel) break;
            ExecutableItemObject ei = new ExecutableItemObject(item);
            if (!ei.isValid()) continue;
            ExecutableItem config = ei.getConfig();
            boolean cancelCraft = config.getRestrictions().is(RestrictionEnum.CANCEL_CRAFT);
            boolean cancelAllCraft = config.getRestrictions().is(RestrictionEnum.CANCEL_ALL_CRAFT);
            if (!cancelCraft && !cancelAllCraft) continue;
            if (cancelCraft && !cancelAllCraft) {
                SsomarDev.testMsg((String)("CRAFT >>> " + CustomCraftingHook.isCustomCraft(e)), (boolean)true);
                if (CustomCraftingHook.isCustomCraft(e)) continue;
            }
            cancel = true;
        }
        if (cancel) {
            e.setCancelled(true);
            this.sm.sendMessage((CommandSender)e.getWhoClicked(), MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.CANCEL_CRAFT));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onItemDragInventory(InventoryDragEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        InventoryType iType = e.getInventory().getType();
        SsomarDev.testMsg((String)">>> Action : 1 Drag Event", (boolean)this.debug);
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Map itemStackMap = e.getNewItems();
        for (Map.Entry entry : itemStackMap.entrySet()) {
            ItemStack item = (ItemStack)entry.getValue();
            ExecutableItemObject ei = new ExecutableItemObject(item);
            if (!ei.isValid()) continue;
            ExecutableItem infoItem = ei.getConfig();
            SsomarDev.testMsg((String)(">>> Action : 2 " + entry.getKey() + " " + entry.getValue()), (boolean)this.debug);
            if (infoItem == null) continue;
            this.doCancel((Event)e, (Cancellable)e, iType, null, ei, p, (Integer)entry.getKey());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onItemMoveInventory(InventoryClickEvent e) {
        ItemStack item2;
        SsomarDev.testMsg((String)(" >>>>> " + e.getInventory().getType() + " slot " + e.getSlot() + " raw slot " + e.getRawSlot()), (boolean)this.debug);
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        ExecutableItemsManager iM = ExecutableItemsManager.getInstance();
        if (e.getClickedInventory() == null) {
            return;
        }
        InventoryType iType = e.getClickedInventory().getType();
        InventoryAction iAction = e.getAction();
        if (iAction.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) && iType == InventoryType.PLAYER) {
            iType = e.getInventory().getType();
        }
        ClickType clickType = e.getClick();
        SsomarDev.testMsg((String)(">>> clikedInv: " + e.getClickedInventory().getType()), (boolean)this.debug);
        SsomarDev.testMsg((String)(">>> Inv: " + e.getInventory().getType()), (boolean)this.debug);
        SsomarDev.testMsg((String)(">>> Action : " + iAction + " iType: " + iType), (boolean)this.debug);
        if (iAction.equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
            ItemStack itemC = e.getCursor();
            if (itemC == null) {
                return;
            }
            ExecutableItemObject ei = new ExecutableItemObject(itemC);
            if (!ei.isValid()) {
                return;
            }
            ExecutableItem infoItem = ei.getConfig();
            if (infoItem.getDisableStack().getValue().booleanValue()) {
                e.setCancelled(true);
            }
            return;
        }
        SsomarDev.testMsg((String)">>> Action : 2", (boolean)this.debug);
        SsomarDev.testMsg((String)(">>> Cursor " + (e.getCursor() != null ? e.getCursor().getType() : null)), (boolean)this.debug);
        SsomarDev.testMsg((String)(">>> Current " + (e.getCurrentItem() != null ? e.getCurrentItem().getType() : null)), (boolean)this.debug);
        try {
            SsomarDev.testMsg((String)(">>> Hotbar " + p.getInventory().getItem(e.getHotbarButton())), (boolean)this.debug);
        }
        catch (Exception itemC) {
            // empty catch block
        }
        ItemStack item = iAction.equals((Object)InventoryAction.PLACE_ALL) || iAction.equals((Object)InventoryAction.PLACE_ONE) || iAction.equals((Object)InventoryAction.PLACE_SOME) || iAction.equals((Object)InventoryAction.SWAP_WITH_CURSOR) ? e.getCursor() : e.getCurrentItem();
        SsomarDev.testMsg((String)(">>> Action : 2.1 >> " + (item != null ? item.getType() : null)), (boolean)this.debug);
        ExecutableItemObject ei = new ExecutableItemObject(item);
        ExecutableItem infoItem = null;
        if (ei.isValid()) {
            infoItem = ei.getConfig();
        }
        ExecutableItem infoItem2 = null;
        ExecutableItemObject ei2 = null;
        if (clickType.equals((Object)ClickType.NUMBER_KEY)) {
            int n = e.getHotbarButton();
            ItemStack item22 = p.getInventory().getItem(n);
            ei2 = new ExecutableItemObject(item22);
            if (ei2.isValid()) {
                infoItem2 = ei2.getConfig();
            }
        } else if (SCore.is1v16Plus() && clickType.equals((Object)ClickType.SWAP_OFFHAND) && (ei2 = new ExecutableItemObject(item2 = p.getInventory().getItemInOffHand())).isValid()) {
            infoItem2 = ei2.getConfig();
        }
        SsomarDev.testMsg((String)">>> Action : 3", (boolean)this.debug);
        if (infoItem == null && infoItem2 == null) {
            SsomarDev.testMsg((String)(">>> Action : 3.1 >" + (Object)((Object)infoItem) + " >> " + (Object)((Object)infoItem2)), (boolean)this.debug);
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        SsomarDev.testMsg((String)">>> Action : 4", (boolean)this.debug);
        if ((clickType.equals((Object)ClickType.NUMBER_KEY) || !SCore.is1v12Less() && clickType.equals((Object)ClickType.SWAP_OFFHAND)) && infoItem2 != null) {
            this.doCancel((Event)e, (Cancellable)e, iType, iAction, ei2, p, e.getRawSlot());
        }
        if (infoItem != null) {
            this.doCancel((Event)e, (Cancellable)e, iType, iAction, ei, p, e.getRawSlot());
        }
    }

    public void doCancel(Event eventSource, Cancellable e, InventoryType iType, @Nullable InventoryAction action, ExecutableItemObject ei, @Nullable Player p, int rawslot) {
        InventoryClickEvent event;
        ExecutableItem item = ei.getConfig();
        ArrayList<InventoryType> cancelChest = new ArrayList<InventoryType>();
        cancelChest.add(InventoryType.CHEST);
        if (!SCore.is1v11Less()) {
            cancelChest.add(InventoryType.SHULKER_BOX);
        }
        cancelChest.add(InventoryType.ENDER_CHEST);
        if (!SCore.is1v13Less()) {
            cancelChest.add(InventoryType.BARREL);
        }
        SsomarDev.testMsg((String)(">>> Action : 3.5 > " + iType), (boolean)this.debug);
        ArrayList<InventoryType> cancelFurnace = new ArrayList<InventoryType>();
        cancelFurnace.add(InventoryType.FURNACE);
        if (!SCore.is1v13Less()) {
            cancelFurnace.add(InventoryType.BLAST_FURNACE);
            cancelFurnace.add(InventoryType.SMOKER);
        }
        if (item.getRestrictions().is(RestrictionEnum.LOCKED_INVENTORY)) {
            SsomarDev.testMsg((String)">>> Action : 5", (boolean)this.debug);
            e.setCancelled(true);
            if (e instanceof InventoryClickEvent) {
                PlayerInventoryClickEvent.runInventoryClick((InventoryClickEvent)e);
            }
            return;
        }
        if (iType.equals((Object)InventoryType.CHEST) && eventSource instanceof InventoryClickEvent) {
            event = (InventoryClickEvent)eventSource;
            if (!SCore.is1v11Less() && event.getClickedInventory() != null && event.getInventory() instanceof AbstractHorseInventory && item.getRestrictions().is(RestrictionEnum.CANCEL_HORSE)) {
                e.setCancelled(true);
                return;
            }
        }
        if (cancelChest.contains(iType)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_DEPOSIT_IN_CHEST)) {
                SsomarDev.testMsg((String)">>> Action : cancel chest", (boolean)this.debug);
                e.setCancelled(true);
                return;
            }
        } else if (cancelFurnace.contains(iType)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_DEPOSIT_IN_FURNACE)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.ANVIL)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_ANVIL)) {
                SsomarDev.testMsg((String)">>> Action : cancel anvil", (boolean)this.debug);
                e.setCancelled(true);
                return;
            }
            if (e instanceof InventoryClickEvent) {
                event = (InventoryClickEvent)e;
                if (((InventoryClickEvent)e).getClickedInventory() instanceof AnvilInventory) {
                    AnvilInventory anvilInventory = (AnvilInventory)((InventoryClickEvent)e).getClickedInventory();
                    if (event.getSlotType() == InventoryType.SlotType.RESULT) {
                        ItemStack result = event.getCurrentItem();
                        ItemStack input = event.getClickedInventory().getItem(0);
                        if (item.getRestrictions().is(RestrictionEnum.CANCEL_ACTION_RENAME_IN_ANVIL) && !StringConverter.decoloredString((String)result.getItemMeta().getDisplayName()).equals(StringConverter.decoloredString((String)input.getItemMeta().getDisplayName()))) {
                            event.setResult(Event.Result.DENY);
                            p.setLevel(p.getLevel());
                            return;
                        }
                        if (item.getRestrictions().is(RestrictionEnum.CANCEL_ACTION_ENCHANT_IN_ANVIL) && result.getItemMeta().getEnchants().size() != input.getItemMeta().getEnchants().size()) {
                            event.setResult(Event.Result.DENY);
                            p.setLevel(p.getLevel());
                            return;
                        }
                    }
                }
            }
        } else if (iType.equals((Object)InventoryType.BREWING)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_BREWING)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.WORKBENCH) || iType.equals((Object)InventoryType.CRAFTING) && rawslot <= 4) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_ALL_CRAFT)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.ENCHANTING)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_ENCHANT_TABLE)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.BEACON)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_BEACON)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.DISPENSER)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_DISPENSER)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.DROPPER)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_DROPPER)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.HOPPER)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_HOPPER)) {
                e.setCancelled(true);
                return;
            }
        } else if (iType.equals((Object)InventoryType.MERCHANT)) {
            if (item.getRestrictions().is(RestrictionEnum.CANCEL_MERCHANT)) {
                e.setCancelled(true);
                return;
            }
        } else if (!SCore.is1v13Less() && !SCore.is1v14() && iType.equals((Object)InventoryType.SMITHING) && item.getRestrictions().is(RestrictionEnum.CANCEL_SMITHING_TABLE)) {
            e.setCancelled(true);
            return;
        }
        if (!SCore.is1v13Less()) {
            if (iType.equals((Object)InventoryType.GRINDSTONE) && item.getRestrictions().is(RestrictionEnum.CANCEL_GRIND_STONE)) {
                e.setCancelled(true);
                return;
            }
            if (iType.equals((Object)InventoryType.STONECUTTER) && item.getRestrictions().is(RestrictionEnum.CANCEL_STONE_CUTTER)) {
                e.setCancelled(true);
                return;
            }
            if (iType.equals((Object)InventoryType.CARTOGRAPHY) && item.getRestrictions().is(RestrictionEnum.CANCEL_CARTOGRAPHY)) {
                e.setCancelled(true);
                return;
            }
            if (iType.equals((Object)InventoryType.LECTERN) && item.getRestrictions().is(RestrictionEnum.CANCEL_LECTERN)) {
                e.setCancelled(true);
                return;
            }
            if (iType.equals((Object)InventoryType.LOOM) && item.getRestrictions().is(RestrictionEnum.CANCEL_LOOM)) {
                e.setCancelled(true);
                return;
            }
        }
        if (SCore.is1v17Plus() && iType.equals((Object)InventoryType.COMPOSTER) && item.getRestrictions().is(RestrictionEnum.CANCEL_COMPOSTER)) {
            e.setCancelled(true);
            return;
        }
        if (SCore.is1v20v4Plus() && iType.equals((Object)InventoryType.CRAFTER) && item.getRestrictions().is(RestrictionEnum.CANCEL_CRAFTER)) {
            e.setCancelled(true);
            return;
        }
        SsomarDev.testMsg((String)">>> Action : 10", (boolean)this.debug);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onIInventoryMoveItemEvent(InventoryMoveItemEvent e) {
        ItemStack item;
        ExecutableItemObject ei;
        InventoryType type = e.getSource().getType();
        if (type.equals((Object)InventoryType.HOPPER) && (ei = new ExecutableItemObject(item = e.getItem())).isValid()) {
            this.doCancel((Event)e, (Cancellable)e, e.getDestination().getType(), null, ei, null, -1);
        }
    }

    @EventHandler
    public void onPlayerItemConsumeEvent(PlayerItemConsumeEvent e) {
        ItemStack item = e.getItem();
        ExecutableItemObject ei = new ExecutableItemObject(item);
        if (!ei.isValid()) {
            return;
        }
        ExecutableItem infoItem = ei.getConfig();
        if (infoItem.getRestrictions().is(RestrictionEnum.CANCEL_CONSUMPTION)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent e) {
        ItemStack item;
        ExecutableItemObject ei2;
        ExecutableItemsManager iM = ExecutableItemsManager.getInstance();
        Player p = e.getPlayer();
        HashMap validItems = new HashMap();
        ItemStack itemHand = SCore.is1v11Less() ? p.getItemInHand() : p.getInventory().getItemInMainHand();
        ExecutableItemObject ei = new ExecutableItemObject(itemHand);
        if (ei.isValid()) {
            HashMap<ItemStack, Integer> slot = new HashMap<ItemStack, Integer>();
            slot.put(itemHand, p.getInventory().getHeldItemSlot());
            validItems.put(ei.getConfig(), slot);
        }
        if (!SCore.is1v11Less() && iM.getExecutableItem(p.getInventory().getItemInOffHand()) != null && (ei2 = new ExecutableItemObject(item = p.getInventory().getItemInOffHand())).isValid()) {
            HashMap<ItemStack, Integer> slot = new HashMap<ItemStack, Integer>();
            slot.put(item, 40);
            validItems.put(ei2.getConfig(), slot);
        }
        for (ExecutableItem item2 : validItems.keySet()) {
            if (e.getRightClicked() instanceof ItemFrame && item2.getRestrictions().is(RestrictionEnum.CANCEL_ITEM_FRAME)) {
                e.setCancelled(true);
                continue;
            }
            if (e.getRightClicked() instanceof Horse && item2.getRestrictions().is(RestrictionEnum.CANCEL_HORSE)) {
                e.setCancelled(true);
                continue;
            }
            if (SCore.is1v11Less() || !(e.getRightClicked() instanceof Llama) && !(e.getRightClicked() instanceof Mule) || !item2.getRestrictions().is(RestrictionEnum.CANCEL_HORSE)) continue;
            e.setCancelled(true);
        }
    }
}

