/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.executableitems;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.editor.ExecutableItemsEditor;
import com.ssomar.executableitems.executableitems.ExecutableItemEditor;
import com.ssomar.executableitems.executableitems.ExecutableItemEditorManager;
import com.ssomar.executableitems.executableitems.ExecutableItemLoader;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.ActivatorEIFeature;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.Instrument.InstrumentFeatures;
import com.ssomar.score.features.custom.ItemBlockStateFeature;
import com.ssomar.score.features.custom.ItemBundleContentFeature;
import com.ssomar.score.features.custom.ItemChargedProjectilesFeature;
import com.ssomar.score.features.custom.ItemSpawnerFeature;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.activators.group.ActivatorsFeature;
import com.ssomar.score.features.custom.armortrim.ArmorTrim;
import com.ssomar.score.features.custom.attributes.group.AttributesGroupFeature;
import com.ssomar.score.features.custom.bannersettings.BannerSettingsFeature;
import com.ssomar.score.features.custom.blocksAttacksFeatures.BlocksAttacksFeatures;
import com.ssomar.score.features.custom.book.BookFeatures;
import com.ssomar.score.features.custom.canbeusedbyowner.CanBeUsedOnlyByOwnerFeatures;
import com.ssomar.score.features.custom.cancelevents.CancelEventFeatures;
import com.ssomar.score.features.custom.consumableFeatures.ConsumableFeatures;
import com.ssomar.score.features.custom.container.ContainerFeatures;
import com.ssomar.score.features.custom.container.ContainerOptions;
import com.ssomar.score.features.custom.displayConditions.DisplayConditionsFeatures;
import com.ssomar.score.features.custom.drop.DropFeatures;
import com.ssomar.score.features.custom.drop.glowdrop.GlowDropManager;
import com.ssomar.score.features.custom.durabilityFeatures.DurabilityFeatures;
import com.ssomar.score.features.custom.enchantments.group.EnchantmentsGroupFeature;
import com.ssomar.score.features.custom.equippableFeatures.EquippableFeatures;
import com.ssomar.score.features.custom.firework.FireworkFeatures;
import com.ssomar.score.features.custom.firework.explosion.FireworkExplosionFeatures;
import com.ssomar.score.features.custom.foodFeatures.FoodFeatures;
import com.ssomar.score.features.custom.givefirstjoin.GiveFirstJoinFeatures;
import com.ssomar.score.features.custom.headfeatures.HeadFeatures;
import com.ssomar.score.features.custom.hiders.Hiders;
import com.ssomar.score.features.custom.itemglow.ItemGlowFeatures;
import com.ssomar.score.features.custom.mf.MyFurnitureFeatures;
import com.ssomar.score.features.custom.nbttags.NBTTags;
import com.ssomar.score.features.custom.potionsettings.PotionSettingsFeature;
import com.ssomar.score.features.custom.rarity.RarityFeatures;
import com.ssomar.score.features.custom.recognition.ListRecognitionFeature;
import com.ssomar.score.features.custom.repairableFeatures.RepairableFeatures;
import com.ssomar.score.features.custom.restrictions.Restrictions;
import com.ssomar.score.features.custom.toolrules.group.ToolRulesGroupFeature;
import com.ssomar.score.features.custom.usage.UsageFeatures;
import com.ssomar.score.features.custom.usecooldown.UseCooldownFeatures;
import com.ssomar.score.features.custom.variables.base.group.VariablesGroupFeature;
import com.ssomar.score.features.custom.weaponFeatures.WeaponFeatures;
import com.ssomar.score.features.menu_organisation.MenuGroup;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColorIntegerFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.list.ListColoredStringFeature;
import com.ssomar.score.features.types.list.ListWorldFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.FixedMaterial;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableItem
extends SObjectWithFileEditable<ExecutableItem, ExecutableItemEditor, ExecutableItemEditorManager>
implements ExecutableItemInterface {
    ColoredStringFeature displayName;
    ListColoredStringFeature lore;
    MaterialFeature material;
    FireworkExplosionFeatures fireworkExplosion;
    FireworkFeatures fireworkFeatures;
    BooleanFeature disableStack;
    IntegerFeature customStackSize;
    FoodFeatures foodFeatures;
    RarityFeatures itemRarity;
    ToolRulesGroupFeature toolRulesGroupFeature;
    ItemGlowFeatures glow;
    InstrumentFeatures instrumentFeatures;
    ItemBlockStateFeature blockState;
    ContainerFeatures container;
    ItemSpawnerFeature spawner;
    ItemBundleContentFeature bundleContent;
    ItemChargedProjectilesFeature chargedProjectiles;
    BooleanFeature glider;
    RepairableFeatures repairable;
    EquippableFeatures equippable;
    UncoloredStringFeature itemModel;
    UncoloredStringFeature tooltipStyle;
    UseCooldownFeatures useCooldown;
    ConsumableFeatures consumableFeatures;
    WeaponFeatures weaponFeatures;
    BlocksAttacksFeatures blocksAttacksFeatures;
    BooleanFeature keepItemOnDeath;
    CanBeUsedOnlyByOwnerFeatures canBeUsedOnlyByTheOwnerFeatures;
    BooleanFeature storeItemInfo;
    BooleanFeature unbreakable;
    UsageFeatures usageFeatures;
    UncoloredStringFeature customModelData;
    DurabilityFeatures durability;
    DropFeatures dropFeatures;
    Hiders hiders;
    EnchantmentsGroupFeature enchantments;
    AttributesGroupFeature attributes;
    GiveFirstJoinFeatures giveFirstJoin;
    Restrictions restrictions;
    CancelEventFeatures cancelEventFeatures;
    DisplayConditionsFeatures displayConditions;
    MyFurnitureFeatures myFurnitureFeatures;
    private ActivatorsFeature activatorsFeature;
    private HeadFeatures headFeatures;
    private PotionSettingsFeature potionSettings;
    private ListWorldFeature whitelistedWorlds;
    private ColorIntegerFeature armorColor;
    private ArmorTrim armorTrim;
    private BannerSettingsFeature bannerSettings;
    private ListRecognitionFeature recognitions;
    private VariablesGroupFeature variables;
    private BookFeatures bookFeatures;
    private Map<String, String> tags;
    private NBTTags nbt;
    private MenuGroup texturesGroup;
    private MenuGroup advancedComponentsGroup;

    public ExecutableItem(FeatureParentInterface parent, String id, String path) {
        super((SPlugin)ExecutableItems.plugin, id, parent, (FeatureSettingsInterface)FeatureSettingsSCore.EXECUTABLEITEM, path, (SObjectWithFileLoader)ExecutableItemLoader.getInstance());
        this.reset();
    }

    public ExecutableItem(String id, String path) {
        super((SPlugin)ExecutableItems.plugin, id, (FeatureSettingsInterface)FeatureSettingsSCore.EXECUTABLEITEM, path, (SObjectWithFileLoader)ExecutableItemLoader.getInstance());
        this.reset();
    }

    public boolean isPremium() {
        return !ExecutableItems.plugin.isLotOfWork();
    }

    public ItemStack getIconItem() {
        return this.buildItem(1, Optional.empty());
    }

    public List<String> getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("\u00a77ID: \u00a7f" + this.getId());
        description.add("\u00a77Path: \u00a7f" + this.getPath());
        description.add("\u00a77Activators: ");
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            description.add("\u00a77- " + activator.getId());
        }
        return description;
    }

    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureAbstract> features = new ArrayList<FeatureAbstract>(Arrays.asList(this.displayName, this.lore, this.material, this.glow, this.nbt, this.disableStack, this.keepItemOnDeath, this.canBeUsedOnlyByTheOwnerFeatures, this.storeItemInfo, this.unbreakable, this.usageFeatures, this.durability, this.dropFeatures, this.enchantments, this.hiders, this.giveFirstJoin, this.restrictions, this.cancelEventFeatures, this.whitelistedWorlds, this.variables, this.activatorsFeature, this.recognitions, this.displayConditions));
        Material mat = (Material)this.material.getValue().get();
        ItemMeta meta = new ItemStack(mat).getItemMeta();
        ArrayList<FeatureAbstract> featuresForItem = new ArrayList<FeatureAbstract>(Arrays.asList(this.foodFeatures, this.blockState, this.bundleContent, this.chargedProjectiles, this.container, this.headFeatures, this.fireworkExplosion, this.fireworkFeatures, this.myFurnitureFeatures, this.consumableFeatures, this.spawner, this.weaponFeatures, this.blocksAttacksFeatures));
        FeatureForItemArgs args = FeatureForItemArgs.create((ItemMeta)meta);
        for (FeatureInterface featureInterface : featuresForItem) {
            FeatureForItem featureForItem;
            if (featureInterface == null || !(featureInterface instanceof FeatureForItem) || !(featureForItem = (FeatureForItem)featureInterface).isAvailable() || !featureForItem.isApplicable(args)) continue;
            features.add((FeatureAbstract)featureInterface);
        }
        if (SCore.is1v20v5Plus()) {
            features.add((FeatureAbstract)this.customStackSize);
            features.add((FeatureAbstract)this.itemRarity);
            features.add((FeatureAbstract)this.toolRulesGroupFeature);
            if (mat.toString().contains("GOAT_HORN")) {
                features.add((FeatureAbstract)this.instrumentFeatures);
            }
        }
        if (SCore.is1v21v2Plus()) {
            features.add((FeatureAbstract)this.glider);
            try {
                if (new ItemStack(mat).getItemMeta() instanceof Repairable) {
                    features.add((FeatureAbstract)this.repairable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            features.add((FeatureAbstract)this.equippable);
            features.add((FeatureAbstract)this.itemModel);
            features.add((FeatureAbstract)this.tooltipStyle);
            features.add((FeatureAbstract)this.useCooldown);
        }
        if (mat.equals((Object)Material.POTION) || !SCore.is1v11Less() && (mat.equals((Object)Material.SPLASH_POTION) || mat.equals((Object)Material.LINGERING_POTION)) || mat.equals((Object)FixedMaterial.getMaterial(Arrays.asList("TIPPED_ARROW")))) {
            features.add((FeatureAbstract)this.potionSettings);
        } else if (mat.equals((Object)Material.LEATHER_BOOTS) || mat.equals((Object)Material.LEATHER_CHESTPLATE) || mat.equals((Object)Material.LEATHER_LEGGINGS) || mat.equals((Object)Material.LEATHER_HELMET) || !SCore.is1v13Less() && mat.equals((Object)Material.LEATHER_HORSE_ARMOR)) {
            features.add((FeatureAbstract)this.armorColor);
        } else if (mat.toString().contains("BANNER") || mat.toString().contains("SHIELD")) {
            features.add((FeatureAbstract)this.bannerSettings);
        } else if (mat.equals((Object)Material.WRITTEN_BOOK)) {
            features.add((FeatureAbstract)this.bookFeatures);
        }
        if (!SCore.is1v13Less()) {
            features.add((FeatureAbstract)this.attributes);
            features.add((FeatureAbstract)this.customModelData);
        }
        if (SCore.is1v20Plus() && (mat.toString().contains("BOOTS") || mat.toString().contains("CHESTPLATE") || mat.toString().contains("LEGGINGS") || mat.toString().contains("HELMET"))) {
            features.add((FeatureAbstract)this.armorTrim);
        }
        features.add((FeatureAbstract)this.texturesGroup);
        features.add((FeatureAbstract)this.advancedComponentsGroup);
        return features;
    }

    public String getParentInfo() {
        return "(Item: " + this.getId() + ")";
    }

    public void reload() {
        if (this.getParent() instanceof ExecutableItem) {
            ExecutableItem item = (ExecutableItem)this.getParent();
            item.setActivatorsFeature(this.activatorsFeature);
            item.setDisplayName(this.displayName);
            item.setLore(this.lore);
            item.setMaterial(this.material);
            item.setHeadFeatures(this.headFeatures);
            item.setDisableStack(this.disableStack);
            item.setCustomStackSize(this.customStackSize);
            item.setKeepItemOnDeath(this.keepItemOnDeath);
            item.setCanBeUsedOnlyByTheOwnerFeatures(this.canBeUsedOnlyByTheOwnerFeatures);
            item.setStoreItemInfo(this.storeItemInfo);
            item.setUnbreakable(this.unbreakable);
            item.setUsageFeatures(this.usageFeatures);
            item.setCustomModelData(this.customModelData);
            item.setDurability(this.durability);
            item.setDropFeatures(this.dropFeatures);
            item.setHiders(this.hiders);
            item.setEnchantments(this.enchantments);
            item.setAttributes(this.attributes);
            item.setGiveFirstJoin(this.giveFirstJoin);
            item.setRestrictions(this.restrictions);
            item.setCancelEventFeatures(this.cancelEventFeatures);
            item.setPotionSettings(this.potionSettings);
            item.setWhitelistedWorlds(this.whitelistedWorlds);
            item.setArmorColor(this.armorColor);
            item.setBannerSettings(this.bannerSettings);
            item.setVariables(this.variables);
            item.setRecognitions(this.recognitions);
            item.setDisplayConditions(this.displayConditions);
            item.setNbt(this.nbt);
            item.setArmorTrim(this.armorTrim);
            item.setFoodFeatures(this.foodFeatures);
            item.setItemRarity(this.itemRarity);
            item.setToolRulesGroupFeature(this.toolRulesGroupFeature);
            item.setGlow(this.glow);
            item.setBookFeatures(this.bookFeatures);
            item.setInstrumentFeatures(this.instrumentFeatures);
            item.setGlider(this.glider);
            item.setRepairable(this.repairable);
            item.setEquippable(this.equippable);
            item.setItemModel(this.itemModel);
            item.setTooltipStyle(this.tooltipStyle);
            item.setUseCooldown(this.useCooldown);
            item.setBlockState(this.blockState);
            item.setContainer(this.container);
            item.setBundleContent(this.bundleContent);
            item.setChargedProjectiles(this.chargedProjectiles);
            item.setFireworkFeatures(this.fireworkFeatures);
            item.setFireworkExplosion(this.fireworkExplosion);
            item.setMyFurnitureFeatures(this.myFurnitureFeatures);
            item.setConsumableFeatures(this.consumableFeatures);
            item.setSpawner(this.spawner);
            item.setWeaponFeatures(this.weaponFeatures);
            item.setBlocksAttacksFeatures(this.blocksAttacksFeatures);
            item.setTexturesGroup(this.texturesGroup);
            item.setAdvancedComponentsGroup(this.advancedComponentsGroup);
            ExecutableItemsManager.getInstance().actionOnObjectWhenReloading(item);
        }
    }

    public ExecutableItem clone(FeatureParentInterface parent) {
        ExecutableItem clone = new ExecutableItem((FeatureParentInterface)this, this.getId(), this.getPath());
        clone.setActivatorsFeature(this.activatorsFeature.clone((FeatureParentInterface)clone));
        clone.setDisplayName(this.displayName.clone((FeatureParentInterface)clone));
        clone.setLore(this.lore.clone((FeatureParentInterface)clone));
        clone.setMaterial(this.material.clone((FeatureParentInterface)clone));
        clone.setDisableStack(this.disableStack.clone((FeatureParentInterface)clone));
        clone.setCustomStackSize(this.customStackSize.clone((FeatureParentInterface)clone));
        clone.setKeepItemOnDeath(this.keepItemOnDeath.clone((FeatureParentInterface)clone));
        clone.setCanBeUsedOnlyByTheOwnerFeatures(this.canBeUsedOnlyByTheOwnerFeatures.clone((FeatureParentInterface)clone));
        clone.setStoreItemInfo(this.storeItemInfo.clone((FeatureParentInterface)clone));
        clone.setUnbreakable(this.unbreakable.clone((FeatureParentInterface)clone));
        clone.setUsageFeatures(this.usageFeatures.clone((FeatureParentInterface)clone));
        clone.setCustomModelData(this.customModelData.clone((FeatureParentInterface)clone));
        clone.setDurability(this.durability.clone((FeatureParentInterface)clone));
        clone.setDropFeatures(this.dropFeatures.clone((FeatureParentInterface)clone));
        clone.setHiders(this.hiders.clone((FeatureParentInterface)clone));
        clone.setEnchantments(this.enchantments.clone((FeatureParentInterface)clone));
        clone.setAttributes(this.attributes.clone((FeatureParentInterface)clone));
        clone.setGiveFirstJoin(this.giveFirstJoin.clone((FeatureParentInterface)clone));
        clone.setRestrictions(this.restrictions.clone((FeatureParentInterface)clone));
        clone.setCancelEventFeatures(this.cancelEventFeatures.clone((FeatureParentInterface)clone));
        clone.setPotionSettings(this.potionSettings.clone((FeatureParentInterface)clone));
        clone.setWhitelistedWorlds(this.whitelistedWorlds.clone((FeatureParentInterface)clone));
        clone.setArmorColor(this.armorColor.clone((FeatureParentInterface)clone));
        clone.setBannerSettings(this.bannerSettings.clone((FeatureParentInterface)clone));
        clone.setVariables(this.variables.clone((FeatureParentInterface)clone));
        clone.setRecognitions(this.recognitions.clone((FeatureParentInterface)clone));
        clone.setDisplayConditions(this.displayConditions.clone((FeatureParentInterface)clone));
        clone.setNbt(this.nbt.clone((FeatureParentInterface)clone));
        clone.setArmorTrim(this.armorTrim.clone((FeatureParentInterface)clone));
        clone.setBookFeatures(this.bookFeatures.clone((FeatureParentInterface)clone));
        if (this.headFeatures != null && this.headFeatures.isAvailable()) {
            clone.setHeadFeatures(this.headFeatures.clone((FeatureParentInterface)clone));
        }
        if (this.foodFeatures != null && this.foodFeatures.isAvailable()) {
            clone.setFoodFeatures(this.foodFeatures.clone((FeatureParentInterface)clone));
        }
        if (this.bundleContent != null && this.bundleContent.isAvailable()) {
            clone.setBundleContent(this.bundleContent.clone((FeatureParentInterface)clone));
        }
        if (this.blockState != null && this.blockState.isAvailable()) {
            clone.setBlockState(this.blockState.clone((FeatureParentInterface)clone));
        }
        if (this.container != null && this.container.isAvailable()) {
            clone.setContainer(this.container.clone((FeatureParentInterface)clone));
        }
        if (this.chargedProjectiles != null && this.chargedProjectiles.isAvailable()) {
            clone.setChargedProjectiles(this.chargedProjectiles.clone((FeatureParentInterface)clone));
        }
        if (this.fireworkFeatures != null && this.fireworkFeatures.isAvailable()) {
            clone.setFireworkFeatures(this.fireworkFeatures.clone((FeatureParentInterface)clone));
        }
        if (this.fireworkExplosion != null && this.fireworkExplosion.isAvailable()) {
            clone.setFireworkExplosion(this.fireworkExplosion.clone((FeatureParentInterface)clone));
        }
        if (this.myFurnitureFeatures != null && this.myFurnitureFeatures.isAvailable()) {
            clone.setMyFurnitureFeatures(this.myFurnitureFeatures.clone((FeatureParentInterface)clone));
        }
        if (this.consumableFeatures != null && this.consumableFeatures.isAvailable()) {
            clone.setConsumableFeatures(this.consumableFeatures.clone((FeatureParentInterface)clone));
        }
        if (this.spawner != null && this.spawner.isAvailable()) {
            clone.setSpawner(this.spawner.clone((FeatureParentInterface)clone));
        }
        if (this.weaponFeatures != null && this.weaponFeatures.isAvailable()) {
            clone.setWeaponFeatures(this.weaponFeatures.clone((FeatureParentInterface)clone));
        }
        if (this.blocksAttacksFeatures != null && this.blocksAttacksFeatures.isAvailable()) {
            clone.setBlocksAttacksFeatures(this.blocksAttacksFeatures.clone((FeatureParentInterface)clone));
        }
        if (SCore.is1v20v5Plus()) {
            clone.setItemRarity(this.itemRarity.clone((FeatureParentInterface)clone));
            clone.setToolRulesGroupFeature(this.toolRulesGroupFeature.clone((FeatureParentInterface)clone));
            clone.setInstrumentFeatures(this.instrumentFeatures.clone((FeatureParentInterface)clone));
        }
        if (SCore.is1v21v2Plus()) {
            clone.setGlider(this.glider.clone((FeatureParentInterface)clone));
            clone.setRepairable(this.repairable.clone((FeatureParentInterface)clone));
            clone.setEquippable(this.equippable.clone((FeatureParentInterface)clone));
            clone.setItemModel(this.itemModel.clone((FeatureParentInterface)clone));
            clone.setTooltipStyle(this.tooltipStyle.clone((FeatureParentInterface)clone));
            clone.setUseCooldown(this.useCooldown.clone((FeatureParentInterface)clone));
        }
        clone.setGlow(this.glow.clone((FeatureParentInterface)clone));
        clone.setTexturesGroup(this.texturesGroup);
        clone.setAdvancedComponentsGroup(this.advancedComponentsGroup);
        return clone;
    }

    public void openEditor(@NotNull Player player) {
        ExecutableItemEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new ExecutableItemsEditor());
    }

    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean premiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.material.load(sPlugin, configurationSection, premiumLoading);
        for (FeatureInterface feature : this.getFeatures()) {
            if (feature == this.material) continue;
            errors.addAll(feature.load(sPlugin, configurationSection, premiumLoading));
        }
        errors.addAll(this.nbt.load(sPlugin, configurationSection, premiumLoading));
        if ((Integer)this.getUsageFeatures().getUsage().getValue().get() == 0) {
            this.getUsageFeatures().getUsage().setValue(Optional.of(1));
            this.hiders.getHideUsage().setValue(true);
        }
        return errors;
    }

    public void save(ConfigurationSection configurationSection) {
        for (FeatureInterface feature : this.getFeatures()) {
            MyFurnitureFeatures myFurnitureFeatures;
            feature.save(configurationSection);
            if (!(feature instanceof MyFurnitureFeatures) || !Dependency.MY_FURNITURE.isEnabled() || !(myFurnitureFeatures = (MyFurnitureFeatures)feature).getEnable().getValue().booleanValue()) continue;
            Optional id = myFurnitureFeatures.getMyFurnitureID().getValueID();
            Optional furnitureOptional = FurnitureManager.getInstance().getFurniture((String)id.get());
            if (!furnitureOptional.isPresent()) continue;
            Furniture furniture = (Furniture)furnitureOptional.get();
            furniture.getEi().setValue(Optional.of(this.getId()));
            furniture.getEi().save();
        }
        configurationSection.set("config_5", (Object)true);
        configurationSection.set("config_update", (Object)(!ExecutableItems.plugin.isLotOfWork() ? 1 : 0));
    }

    public ExecutableItem getValue() {
        return this;
    }

    public ExecutableItem initItemParentEditor(GUI gui, int i) {
        return null;
    }

    public void updateItemParentEditor(GUI gui) {
    }

    public void reset() {
        this.activatorsFeature = new ActivatorsFeature((FeatureParentInterface)this, (SActivator)new ActivatorEIFeature(null, "null"));
        this.displayName = new ColoredStringFeature((FeatureParentInterface)this, Optional.of("&eDefault name"), (FeatureSettingsInterface)FeatureSettingsSCore.name);
        this.lore = new ListColoredStringFeature((FeatureParentInterface)this, new ArrayList<String>(Arrays.asList("&b&oDefault lore")), (FeatureSettingsInterface)FeatureSettingsSCore.lore, Optional.empty());
        this.material = new MaterialFeature((FeatureParentInterface)this, Optional.of(Material.STONE), (FeatureSettingsInterface)FeatureSettingsSCore.material, false);
        this.headFeatures = new HeadFeatures((FeatureParentInterface)this);
        this.disableStack = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.disableStack);
        this.customStackSize = new IntegerFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.customStackSize);
        this.keepItemOnDeath = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.keepItemOnDeath);
        this.canBeUsedOnlyByTheOwnerFeatures = new CanBeUsedOnlyByOwnerFeatures((FeatureParentInterface)this);
        this.storeItemInfo = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.storeItemInfo);
        this.unbreakable = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.unbreakable);
        this.glow = new ItemGlowFeatures((FeatureParentInterface)this);
        this.durability = new DurabilityFeatures((FeatureParentInterface)this);
        this.usageFeatures = new UsageFeatures((FeatureParentInterface)this, this.getId());
        this.customModelData = new UncoloredStringFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.customModelData_ei, false);
        this.dropFeatures = new DropFeatures((FeatureParentInterface)this);
        this.hiders = new Hiders((FeatureParentInterface)this);
        this.enchantments = new EnchantmentsGroupFeature((FeatureParentInterface)this, false);
        this.attributes = new AttributesGroupFeature((FeatureParentInterface)this, false);
        this.giveFirstJoin = new GiveFirstJoinFeatures((FeatureParentInterface)this);
        this.restrictions = new Restrictions((FeatureParentInterface)this, GeneralConfig.getInstance().getRestrictionsDefaultValues());
        this.cancelEventFeatures = new CancelEventFeatures((FeatureParentInterface)this);
        this.tags = new HashMap<String, String>();
        this.nbt = new NBTTags((FeatureParentInterface)this);
        this.potionSettings = new PotionSettingsFeature((FeatureParentInterface)this);
        this.whitelistedWorlds = new ListWorldFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.whitelistedWorlds);
        this.armorColor = new ColorIntegerFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.armorColor);
        this.armorTrim = new ArmorTrim((FeatureParentInterface)this);
        this.fireworkFeatures = new FireworkFeatures((FeatureParentInterface)this);
        this.fireworkExplosion = new FireworkExplosionFeatures((FeatureParentInterface)this);
        this.bannerSettings = new BannerSettingsFeature((FeatureParentInterface)this);
        this.variables = new VariablesGroupFeature((FeatureParentInterface)this);
        this.recognitions = new ListRecognitionFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.recognitions);
        this.displayConditions = new DisplayConditionsFeatures((FeatureParentInterface)this);
        this.foodFeatures = new FoodFeatures((FeatureParentInterface)this);
        this.bookFeatures = new BookFeatures((FeatureParentInterface)this);
        this.myFurnitureFeatures = new MyFurnitureFeatures((FeatureParentInterface)this);
        if (SCore.is1v20v5Plus()) {
            this.itemRarity = new RarityFeatures((FeatureParentInterface)this);
            this.toolRulesGroupFeature = new ToolRulesGroupFeature((FeatureParentInterface)this, true);
            this.instrumentFeatures = new InstrumentFeatures((FeatureParentInterface)this);
            this.blockState = new ItemBlockStateFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.blockState, false);
            this.bundleContent = new ItemBundleContentFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.bundleContent, Optional.empty());
            this.chargedProjectiles = new ItemChargedProjectilesFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.chargedProjectiles, Optional.empty());
            this.container = new ContainerFeatures((FeatureParentInterface)this, ContainerOptions.ONLY_ITEM);
            this.spawner = new ItemSpawnerFeature((FeatureParentInterface)this);
        }
        if (SCore.is1v21v2Plus()) {
            this.glider = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.glider);
            this.repairable = new RepairableFeatures((FeatureParentInterface)this);
            this.equippable = new EquippableFeatures((FeatureParentInterface)this);
            this.itemModel = new UncoloredStringFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.itemModel, false);
            this.tooltipStyle = new UncoloredStringFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.tooltipModel, false);
            this.useCooldown = new UseCooldownFeatures((FeatureParentInterface)this);
        }
        if (SCore.is1v21v4Plus() && SCore.isPaperOrFork()) {
            this.consumableFeatures = new ConsumableFeatures((FeatureParentInterface)this);
        }
        if (SCore.is1v21v5Plus() && SCore.isPaperOrFork()) {
            this.weaponFeatures = new WeaponFeatures((FeatureParentInterface)this);
            this.blocksAttacksFeatures = new BlocksAttacksFeatures((FeatureParentInterface)this);
            if (!this.blocksAttacksFeatures.isAvailable()) {
                this.blocksAttacksFeatures = null;
            }
        }
        this.texturesGroup = new MenuGroup((FeatureParentInterface)this, FeatureSettingsSCore.itemTextures, new FeatureInterface[]{this.customModelData, this.itemModel, this.tooltipStyle});
        this.advancedComponentsGroup = new MenuGroup((FeatureParentInterface)this, FeatureSettingsSCore.itemAdvancedComponents, new FeatureInterface[]{this.glider, this.equippable, this.repairable, this.foodFeatures, this.consumableFeatures, this.itemRarity, this.toolRulesGroupFeature, this.displayConditions, this.useCooldown, this.blockState, this.weaponFeatures, this.blocksAttacksFeatures});
    }

    public ItemStack addExecutableItemInfos(ItemStack itemStack, Optional<Player> playerOpt) {
        return this.buildItem(1, playerOpt, Optional.empty(), Optional.ofNullable(itemStack), new HashMap<String, String>());
    }

    public boolean hasItemPerm(@NotNull Player player, boolean showError) {
        return this.hasPermission(player, showError);
    }

    public Item dropItem(Location location, int i) {
        ItemStack item = this.buildItem(i, Optional.empty(), Optional.empty());
        Item drop = location.getWorld().dropItem(location, item);
        this.actionWhenDropped(drop);
        return drop;
    }

    public Item dropItem(Location location, int amount, Optional<Player> optional, Map<String, Object> settings) {
        ItemStack item = this.buildItem(amount, Optional.empty(), settings);
        return location.getWorld().dropItem(location, item);
    }

    public void actionWhenDropped(final Item item) {
        if (this.dropFeatures.getGlowDrop().getValue().booleanValue()) {
            GlowDropManager.getInstance().addGlow((Entity)item, (ChatColor)this.dropFeatures.getDropColor().getValue().get());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    GlowDropManager.getInstance().removeGlow((Entity)item, (ChatColor)ExecutableItem.this.dropFeatures.getDropColor().getValue().get());
                }
            };
            SCore.schedulerHook.runEntityTask(runnable, null, (Entity)item, 6000L);
        }
        ExecutableItemObject executableItemObject = new ExecutableItemObject(item.getItemStack());
        String name = this.getDisplayName().getColoredValue().orElse("");
        name = executableItemObject.refreshVariables_Owner_Usage_PlaceholdersInString(name, name);
        if (this.dropFeatures.getDisplayNameDrop().getValue().booleanValue()) {
            item.setCustomName(StringConverter.coloredString((String)name));
            item.setCustomNameVisible(true);
        }
    }

    public ItemStack buildItem(int quantity, Optional<Player> playerOpt) {
        return this.buildItem(quantity, playerOpt, Optional.empty(), Optional.empty(), new HashMap<String, String>());
    }

    public ItemStack buildItem(int amount, @Nullable InternalData overrideInternalData) {
        if (overrideInternalData == null) {
            overrideInternalData = new InternalData();
        }
        return this.buildItem(amount, overrideInternalData.getOwnerOptional(), overrideInternalData.getUsageOptional(), Optional.empty(), overrideInternalData.getVariables());
    }

    public ItemStack buildItem(int quantity, Optional<Integer> usageOpt, Optional<Player> playerOpt) {
        return this.buildItem(quantity, playerOpt, usageOpt, Optional.empty(), new HashMap<String, String>());
    }

    public ItemStack buildItem(int quantity, Optional<Player> playerOpt, Map<String, Object> settings) {
        Optional<Integer> usageOpt = Optional.empty();
        if (settings.containsKey("Usage")) {
            int usage = Integer.valueOf((String)settings.get("Usage"));
            usageOpt = Optional.of(usage);
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        if (settings.containsKey("Variables")) {
            Map read = (Map)settings.get("Variables");
            for (String key : read.keySet()) {
                variables.put(key, (String)read.get(key));
            }
        }
        return this.buildItem(quantity, playerOpt, usageOpt, Optional.empty(), variables, settings);
    }

    public ItemStack buildItem(int quantity, Optional<Integer> usageOpt, Optional<Player> playerOpt, Map<String, String> variables) {
        return this.buildItem(quantity, playerOpt, usageOpt, Optional.empty(), variables);
    }

    public ItemStack buildItem(int quantity, Optional<Player> playerOpt, Optional<Integer> usageOpt, Optional<ItemStack> itemStackOpt, Map<String, String> variables) {
        return this.buildItem(quantity, playerOpt, usageOpt, itemStackOpt, variables, new HashMap<String, Object>());
    }

    public ItemStack buildItem(int quantity, Optional<Player> playerOpt, Optional<Integer> usageOpt, Optional<ItemStack> itemStackOpt, Map<String, String> variables, Map<String, Object> settings) {
        ItemStack item = null;
        if (!itemStackOpt.isPresent()) {
            item = this.headFeatures.getHeadOr((Material)this.material.getValue().get());
            item.setAmount(quantity);
        } else {
            item = itemStackOpt.get();
        }
        UUID ownerUUID = null;
        if (playerOpt.isPresent()) {
            ownerUUID = playerOpt.get().getUniqueId();
        }
        int usage = 0;
        if (this.getUsageFeatures().getUsage().getValue().isPresent()) {
            usage = (Integer)this.getUsageFeatures().getUsage().getValue().get();
        }
        if (usageOpt.isPresent()) {
            usage = usageOpt.get();
        }
        ExecutableItemObject ei = new ExecutableItemObject(item, this, ownerUUID, usage);
        item = ei.build();
        ei.getInternalData().getVariableRealsList().buildWithCustomValues(variables, item, ownerUUID);
        DynamicMeta dynamicMeta = new DynamicMeta(item.getItemMeta());
        ei.refreshName(dynamicMeta);
        ei.refreshLore(dynamicMeta);
        ei.refreshCustomModelData(dynamicMeta);
        item.setItemMeta(dynamicMeta.getMeta());
        if (SCore.is1v13Less()) {
            return item;
        }
        if (settings.containsKey("Durability")) {
            int durability = Integer.valueOf((String)settings.get("Durability"));
            item.setDurability((short)durability);
        }
        return item;
    }

    public boolean canBeStacked() {
        return this.getDisableStack().getValue();
    }

    public String getItemName() {
        return this.getDisplayName().getValue().orElse("");
    }

    @Nullable
    public SActivator getActivator(String s) {
        for (SActivator acti : this.activatorsFeature.getActivators().values()) {
            if (!acti.getId().equalsIgnoreCase(this.getId())) continue;
            return acti;
        }
        return null;
    }

    public ActivatorsFeature getActivators() {
        return this.activatorsFeature;
    }

    public boolean hasKeepItemOnDeath() {
        return this.keepItemOnDeath.getValue();
    }

    public void addCooldown(Player player, int cooldown, boolean isInTicks) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEIFeature)) continue;
            ActivatorEIFeature activatorEI = (ActivatorEIFeature)activator;
            activatorEI.getCooldown().addCooldown((Entity)player, (SObject)this, cooldown, isInTicks);
        }
    }

    public void addCooldown(Player player, int cooldown, boolean isInTicks, String activatorId) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEIFeature) || !activatorId.equalsIgnoreCase(activator.getId())) continue;
            ActivatorEIFeature activatorEI = (ActivatorEIFeature)activator;
            activatorEI.getCooldown().addCooldown((Entity)player, (SObject)this, cooldown, isInTicks);
            break;
        }
    }

    public void addGlobalCooldown(int i, boolean b) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEIFeature)) continue;
            ActivatorEIFeature activatorEI = (ActivatorEIFeature)activator;
            activatorEI.getCooldown().addGlobalCooldown(i, b);
        }
    }

    public void addGlobalCooldown(int i, boolean b, String activatorId) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEIFeature) || !activatorId.equalsIgnoreCase(activator.getId())) continue;
            ActivatorEIFeature activatorEI = (ActivatorEIFeature)activator;
            activatorEI.getCooldown().addGlobalCooldown(i, b);
            break;
        }
    }

    public boolean hasCustomModel() {
        return this.customModelData.getValue().isPresent() && !((String)this.customModelData.getValue().get()).equals("-4523");
    }

    public ColoredStringFeature getDisplayName() {
        return this.displayName;
    }

    public void setUsage(int usage) {
        this.usageFeatures.getUsage().setValue(Optional.of(usage));
        this.save(this.getConfigurationSection());
    }

    public ListColoredStringFeature getLore() {
        return this.lore;
    }

    public MaterialFeature getMaterial() {
        return this.material;
    }

    public FireworkExplosionFeatures getFireworkExplosion() {
        return this.fireworkExplosion;
    }

    public FireworkFeatures getFireworkFeatures() {
        return this.fireworkFeatures;
    }

    public BooleanFeature getDisableStack() {
        return this.disableStack;
    }

    public IntegerFeature getCustomStackSize() {
        return this.customStackSize;
    }

    public FoodFeatures getFoodFeatures() {
        return this.foodFeatures;
    }

    public RarityFeatures getItemRarity() {
        return this.itemRarity;
    }

    public ToolRulesGroupFeature getToolRulesGroupFeature() {
        return this.toolRulesGroupFeature;
    }

    public ItemGlowFeatures getGlow() {
        return this.glow;
    }

    public InstrumentFeatures getInstrumentFeatures() {
        return this.instrumentFeatures;
    }

    public ItemBlockStateFeature getBlockState() {
        return this.blockState;
    }

    public ContainerFeatures getContainer() {
        return this.container;
    }

    public ItemSpawnerFeature getSpawner() {
        return this.spawner;
    }

    public ItemBundleContentFeature getBundleContent() {
        return this.bundleContent;
    }

    public ItemChargedProjectilesFeature getChargedProjectiles() {
        return this.chargedProjectiles;
    }

    public BooleanFeature getGlider() {
        return this.glider;
    }

    public RepairableFeatures getRepairable() {
        return this.repairable;
    }

    public EquippableFeatures getEquippable() {
        return this.equippable;
    }

    public UncoloredStringFeature getItemModel() {
        return this.itemModel;
    }

    public UncoloredStringFeature getTooltipStyle() {
        return this.tooltipStyle;
    }

    public UseCooldownFeatures getUseCooldown() {
        return this.useCooldown;
    }

    public ConsumableFeatures getConsumableFeatures() {
        return this.consumableFeatures;
    }

    public WeaponFeatures getWeaponFeatures() {
        return this.weaponFeatures;
    }

    public BlocksAttacksFeatures getBlocksAttacksFeatures() {
        return this.blocksAttacksFeatures;
    }

    public BooleanFeature getKeepItemOnDeath() {
        return this.keepItemOnDeath;
    }

    public CanBeUsedOnlyByOwnerFeatures getCanBeUsedOnlyByTheOwnerFeatures() {
        return this.canBeUsedOnlyByTheOwnerFeatures;
    }

    public BooleanFeature getStoreItemInfo() {
        return this.storeItemInfo;
    }

    public BooleanFeature getUnbreakable() {
        return this.unbreakable;
    }

    public UsageFeatures getUsageFeatures() {
        return this.usageFeatures;
    }

    public UncoloredStringFeature getCustomModelData() {
        return this.customModelData;
    }

    public DurabilityFeatures getDurability() {
        return this.durability;
    }

    public DropFeatures getDropFeatures() {
        return this.dropFeatures;
    }

    public Hiders getHiders() {
        return this.hiders;
    }

    public EnchantmentsGroupFeature getEnchantments() {
        return this.enchantments;
    }

    public AttributesGroupFeature getAttributes() {
        return this.attributes;
    }

    public GiveFirstJoinFeatures getGiveFirstJoin() {
        return this.giveFirstJoin;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public CancelEventFeatures getCancelEventFeatures() {
        return this.cancelEventFeatures;
    }

    public DisplayConditionsFeatures getDisplayConditions() {
        return this.displayConditions;
    }

    public MyFurnitureFeatures getMyFurnitureFeatures() {
        return this.myFurnitureFeatures;
    }

    public ActivatorsFeature getActivatorsFeature() {
        return this.activatorsFeature;
    }

    public HeadFeatures getHeadFeatures() {
        return this.headFeatures;
    }

    public PotionSettingsFeature getPotionSettings() {
        return this.potionSettings;
    }

    public ListWorldFeature getWhitelistedWorlds() {
        return this.whitelistedWorlds;
    }

    public ColorIntegerFeature getArmorColor() {
        return this.armorColor;
    }

    public ArmorTrim getArmorTrim() {
        return this.armorTrim;
    }

    public BannerSettingsFeature getBannerSettings() {
        return this.bannerSettings;
    }

    public ListRecognitionFeature getRecognitions() {
        return this.recognitions;
    }

    public VariablesGroupFeature getVariables() {
        return this.variables;
    }

    public BookFeatures getBookFeatures() {
        return this.bookFeatures;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public NBTTags getNbt() {
        return this.nbt;
    }

    public MenuGroup getTexturesGroup() {
        return this.texturesGroup;
    }

    public MenuGroup getAdvancedComponentsGroup() {
        return this.advancedComponentsGroup;
    }

    public void setDisplayName(ColoredStringFeature displayName) {
        this.displayName = displayName;
    }

    public void setLore(ListColoredStringFeature lore) {
        this.lore = lore;
    }

    public void setMaterial(MaterialFeature material) {
        this.material = material;
    }

    public void setFireworkExplosion(FireworkExplosionFeatures fireworkExplosion) {
        this.fireworkExplosion = fireworkExplosion;
    }

    public void setFireworkFeatures(FireworkFeatures fireworkFeatures) {
        this.fireworkFeatures = fireworkFeatures;
    }

    public void setDisableStack(BooleanFeature disableStack) {
        this.disableStack = disableStack;
    }

    public void setCustomStackSize(IntegerFeature customStackSize) {
        this.customStackSize = customStackSize;
    }

    public void setFoodFeatures(FoodFeatures foodFeatures) {
        this.foodFeatures = foodFeatures;
    }

    public void setItemRarity(RarityFeatures itemRarity) {
        this.itemRarity = itemRarity;
    }

    public void setToolRulesGroupFeature(ToolRulesGroupFeature toolRulesGroupFeature) {
        this.toolRulesGroupFeature = toolRulesGroupFeature;
    }

    public void setGlow(ItemGlowFeatures glow) {
        this.glow = glow;
    }

    public void setInstrumentFeatures(InstrumentFeatures instrumentFeatures) {
        this.instrumentFeatures = instrumentFeatures;
    }

    public void setBlockState(ItemBlockStateFeature blockState) {
        this.blockState = blockState;
    }

    public void setContainer(ContainerFeatures container) {
        this.container = container;
    }

    public void setSpawner(ItemSpawnerFeature spawner) {
        this.spawner = spawner;
    }

    public void setBundleContent(ItemBundleContentFeature bundleContent) {
        this.bundleContent = bundleContent;
    }

    public void setChargedProjectiles(ItemChargedProjectilesFeature chargedProjectiles) {
        this.chargedProjectiles = chargedProjectiles;
    }

    public void setGlider(BooleanFeature glider) {
        this.glider = glider;
    }

    public void setRepairable(RepairableFeatures repairable) {
        this.repairable = repairable;
    }

    public void setEquippable(EquippableFeatures equippable) {
        this.equippable = equippable;
    }

    public void setItemModel(UncoloredStringFeature itemModel) {
        this.itemModel = itemModel;
    }

    public void setTooltipStyle(UncoloredStringFeature tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public void setUseCooldown(UseCooldownFeatures useCooldown) {
        this.useCooldown = useCooldown;
    }

    public void setConsumableFeatures(ConsumableFeatures consumableFeatures) {
        this.consumableFeatures = consumableFeatures;
    }

    public void setWeaponFeatures(WeaponFeatures weaponFeatures) {
        this.weaponFeatures = weaponFeatures;
    }

    public void setBlocksAttacksFeatures(BlocksAttacksFeatures blocksAttacksFeatures) {
        this.blocksAttacksFeatures = blocksAttacksFeatures;
    }

    public void setKeepItemOnDeath(BooleanFeature keepItemOnDeath) {
        this.keepItemOnDeath = keepItemOnDeath;
    }

    public void setCanBeUsedOnlyByTheOwnerFeatures(CanBeUsedOnlyByOwnerFeatures canBeUsedOnlyByTheOwnerFeatures) {
        this.canBeUsedOnlyByTheOwnerFeatures = canBeUsedOnlyByTheOwnerFeatures;
    }

    public void setStoreItemInfo(BooleanFeature storeItemInfo) {
        this.storeItemInfo = storeItemInfo;
    }

    public void setUnbreakable(BooleanFeature unbreakable) {
        this.unbreakable = unbreakable;
    }

    public void setUsageFeatures(UsageFeatures usageFeatures) {
        this.usageFeatures = usageFeatures;
    }

    public void setCustomModelData(UncoloredStringFeature customModelData) {
        this.customModelData = customModelData;
    }

    public void setDurability(DurabilityFeatures durability) {
        this.durability = durability;
    }

    public void setDropFeatures(DropFeatures dropFeatures) {
        this.dropFeatures = dropFeatures;
    }

    public void setHiders(Hiders hiders) {
        this.hiders = hiders;
    }

    public void setEnchantments(EnchantmentsGroupFeature enchantments) {
        this.enchantments = enchantments;
    }

    public void setAttributes(AttributesGroupFeature attributes) {
        this.attributes = attributes;
    }

    public void setGiveFirstJoin(GiveFirstJoinFeatures giveFirstJoin) {
        this.giveFirstJoin = giveFirstJoin;
    }

    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    public void setCancelEventFeatures(CancelEventFeatures cancelEventFeatures) {
        this.cancelEventFeatures = cancelEventFeatures;
    }

    public void setDisplayConditions(DisplayConditionsFeatures displayConditions) {
        this.displayConditions = displayConditions;
    }

    public void setMyFurnitureFeatures(MyFurnitureFeatures myFurnitureFeatures) {
        this.myFurnitureFeatures = myFurnitureFeatures;
    }

    public void setActivatorsFeature(ActivatorsFeature activatorsFeature) {
        this.activatorsFeature = activatorsFeature;
    }

    public void setHeadFeatures(HeadFeatures headFeatures) {
        this.headFeatures = headFeatures;
    }

    public void setPotionSettings(PotionSettingsFeature potionSettings) {
        this.potionSettings = potionSettings;
    }

    public void setWhitelistedWorlds(ListWorldFeature whitelistedWorlds) {
        this.whitelistedWorlds = whitelistedWorlds;
    }

    public void setArmorColor(ColorIntegerFeature armorColor) {
        this.armorColor = armorColor;
    }

    public void setArmorTrim(ArmorTrim armorTrim) {
        this.armorTrim = armorTrim;
    }

    public void setBannerSettings(BannerSettingsFeature bannerSettings) {
        this.bannerSettings = bannerSettings;
    }

    public void setRecognitions(ListRecognitionFeature recognitions) {
        this.recognitions = recognitions;
    }

    public void setVariables(VariablesGroupFeature variables) {
        this.variables = variables;
    }

    public void setBookFeatures(BookFeatures bookFeatures) {
        this.bookFeatures = bookFeatures;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setNbt(NBTTags nbt) {
        this.nbt = nbt;
    }

    public void setTexturesGroup(MenuGroup texturesGroup) {
        this.texturesGroup = texturesGroup;
    }

    public void setAdvancedComponentsGroup(MenuGroup advancedComponentsGroup) {
        this.advancedComponentsGroup = advancedComponentsGroup;
    }
}

