/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.projectiles;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.events.CheckIfDamageIsPosssibleListener;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ProjectileHitEntityEvent
implements Listener {
    private static final Boolean DEBUG = true;

    @EventHandler
    public void projectileHitEntityEvent(com.ssomar.sevents.events.projectile.hitentity.ProjectileHitEntityEvent e) {
        SsomarDev.testMsg((String)"ProjectileHitEntityEvent", (boolean)DEBUG);
        Entity entity = e.getEntity();
        Optional<ProjectileInfo> pInfoOpt = ProjectilesHandler.getInstance().getProjectileInfo(entity.getUniqueId());
        if (!pInfoOpt.isPresent()) {
            return;
        }
        SsomarDev.testMsg((String)"ProjectileHitEntityEvent: ProjectileInfo found", (boolean)DEBUG);
        ProjectileInfo pInfo = pInfoOpt.get();
        Entity target = e.getTarget();
        if (target instanceof EnderDragonPart) {
            target = ((EnderDragonPart)target).getParent();
        }
        Optional<ExecutableItemObject> ei = pInfo.getEiOpt();
        SsomarDev.testMsg((String)("ProjectileHitEntityEvent: ExecutableItem present ? " + ei.isPresent()), (boolean)DEBUG);
        EventInfo eInfo = new EventInfo((Event)e);
        eInfo.setPlayer(Optional.of(pInfo.getLauncher()));
        eInfo.setTargetEntity(Optional.of(target));
        eInfo.setProjectile(Optional.of((Projectile)entity));
        eInfo.setSlot(Optional.of(pInfo.getSlot()));
        if (ei.isPresent()) {
            eInfo.setProjectileProvenance(Optional.ofNullable(ei.get().getConfig().getId()));
        }
        boolean justCancelForActivator = false;
        if (target instanceof Damageable && !CheckIfDamageIsPosssibleListener.getInstance().canDamage((Entity)pInfo.getLauncher(), (Damageable)target)) {
            SsomarDev.testMsg((String)"ProjectileHitEntityEvent: CheckIfDamageIsPosssibleListener >> false", (boolean)DEBUG);
            if (!e.isCancelled()) {
                justCancelForActivator = true;
                e.setCancelled(true);
            }
        }
        boolean runActivatorsItemNotInTheInventory = false;
        if (ei.isPresent()) {
            if (ei.get().getItem() == null || ei.get().getItem().getType().equals((Object)Material.AIR)) {
                runActivatorsItemNotInTheInventory = true;
                ei.get().setItem(null);
            }
            boolean bl = runActivatorsItemNotInTheInventory = runActivatorsItemNotInTheInventory || !SCore.is1v12Less() && ei.get().getItem() != null && ei.get().getItem().getType().equals((Object)Material.TRIDENT);
            if (runActivatorsItemNotInTheInventory) {
                eInfo.setProjectileProvenance(Optional.ofNullable(">NULL<"));
                eInfo.setMainHand(true);
                eInfo.setForceMainHand(true);
                SsomarDev.testMsg((String)"ProjectileHitEntityEvent: ExecutableItem found + item is null", (boolean)DEBUG);
                ExecutableItem config = ei.get().getConfig();
                for (SActivator activator : config.getActivators().getActivators().values()) {
                    if (!activator.getOption().equals((Object)Option.PROJECTILE_HIT_ENTITY)) continue;
                    activator.runWithException((Object)ei.get(), eInfo);
                }
            }
        }
        SsomarDev.testMsg((String)"ProjectileHitEntityEvent: Active option", (boolean)DEBUG);
        eInfo.setOption((SOption)Option.PROJECTILE_HIT_ENTITY);
        EventsManager.getInstance().activeOption(eInfo);
        if (justCancelForActivator) {
            e.setCancelled(false);
        }
    }
}

