/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.configs;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.score.config.Config;
import com.ssomar.score.features.custom.restrictions.RestrictionEnum;
import com.ssomar.score.usedapi.AllWorldManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class GeneralConfig
extends Config {
    private static GeneralConfig instance;
    private Map<String, List<String>> whitelistItemsPerWorld;
    private List<String> disableWorlds;
    private List<String> whitelistWorlds;
    private Map<RestrictionEnum, Boolean> restrictionsDefaultValues;
    private Map<Option, List<EntityDamageEvent.DamageCause>> damageCausesBlacklisted;
    private boolean downloadTexturesPackAtTheNextLoading = false;
    private Map<LOGS, Boolean> logs;

    public GeneralConfig() {
        super("config.yml");
        super.setup((Plugin)ExecutableItems.plugin);
    }

    public static GeneralConfig getInstance() {
        if (instance == null) {
            instance = new GeneralConfig();
        }
        return instance;
    }

    public boolean converter(FileConfiguration fileConfiguration) {
        if (!fileConfiguration.contains("config_12_04_2024")) {
            fileConfiguration.set("config_12_04_2024", (Object)true);
            fileConfiguration.set("premiumEnableCooldownForOp", fileConfiguration.get("premium-enable-cooldown-for-op", (Object)true));
            fileConfiguration.set("premium-enable-cooldown-for-op", null);
            fileConfiguration.set("silentGive", fileConfiguration.get("silentEIGive", (Object)true));
            fileConfiguration.set("silentEIGive", null);
            fileConfiguration.set("disabledWorlds", fileConfiguration.get("disable-world", new ArrayList()));
            fileConfiguration.set("disable-world", null);
            fileConfiguration.set("whitelistedWorlds", fileConfiguration.get("whitelisted-worlds", new ArrayList()));
            fileConfiguration.set("whitelisted-worlds", null);
            fileConfiguration.set("pickupLimit", fileConfiguration.get("pickup-limit", (Object)-1));
            fileConfiguration.set("pickup-limit", null);
            return true;
        }
        return false;
    }

    public void load() {
        if (this.config.isBoolean("downloadTexturesPackAtTheNextLoading")) {
            this.downloadTexturesPackAtTheNextLoading = this.config.getBoolean("downloadTexturesPackAtTheNextLoading", false);
            this.config.set("downloadTexturesPackAtTheNextLoading", null);
            this.save();
        }
        this.disableWorlds = new ArrayList<String>();
        List configDisableWorlds = this.config.getStringList("disabledWorld");
        configDisableWorlds.addAll(this.config.getStringList("disabledWorlds"));
        for (String string : configDisableWorlds) {
            if (AllWorldManager.getWorld((String)string).isPresent()) {
                this.disableWorlds.add(string);
                continue;
            }
            ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Invalid world: " + string + " in the option disable-world");
        }
        this.whitelistWorlds = new ArrayList<String>();
        for (String string : this.config.getStringList("whitelistedWorlds")) {
            if (AllWorldManager.getWorld((String)string).isPresent()) {
                this.whitelistWorlds.add(string);
                continue;
            }
            ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Invalid world: " + string + " in the option whitelist-world");
        }
        this.whitelistItemsPerWorld = new HashMap<String, List<String>>();
        if (this.config.isConfigurationSection("whitelistItemsPerWorld")) {
            ConfigurationSection whitelistItemsPerWorldSection = this.config.getConfigurationSection("whitelistItemsPerWorld");
            for (String world : whitelistItemsPerWorldSection.getKeys(false)) {
                if (AllWorldManager.getWorld((String)world).isPresent()) {
                    List items = whitelistItemsPerWorldSection.getStringList(world);
                    this.whitelistItemsPerWorld.put(world, items);
                    continue;
                }
                ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Invalid world: " + world + " in the option disableItemsPerWorld");
            }
        }
        this.loadStringSetting(Setting.texturesPackUrl.name(), "");
        this.loadBooleanSetting(Setting.selfHostPack.name(), true);
        this.loadBooleanSetting(Setting.enableTexturesPack.name(), true);
        this.loadBooleanSetting(Setting.disableTestItems.name(), false);
        this.loadBooleanSetting(Setting.checkVersionMsg.name(), true);
        this.loadBooleanSetting(Setting.silentGive.name(), false);
        this.loadBooleanSetting(Setting.silentMessagePreventionErrorHeadDBError.name(), false);
        this.loadBooleanSetting(Setting.disableBackup.name(), false);
        this.loadBooleanSetting(Setting.premiumEnableCooldownForOp.name(), false);
        this.loadBooleanSetting(Setting.updateOldItems.name(), false);
        this.loadBooleanSetting(Setting.itemCheckWithNBTAPI.name(), false);
        this.loadBooleanSetting(Setting.enableGarbageCollectorAfterReload.name(), false);
        this.loadBooleanSetting(Setting.muteModification.name(), false);
        this.loadBooleanSetting(Setting.debugOnlyRun.name(), false);
        if (this.loadIntSetting(Setting.deleteBackupsAfterDays.name(), 7) < 0) {
            this.getLoadedSettings().put(Setting.deleteBackupsAfterDays.name(), 14);
        }
        this.loadIntSetting(Setting.giveLimit.name(), 100);
        int pickupLimit = this.loadIntSetting(Setting.pickupLimit.name(), -1);
        if (pickupLimit < -1) {
            this.getLoadedSettings().put(Setting.pickupLimit.name(), -1);
        } else if (pickupLimit == 0) {
            ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Min of pickup-limit is: 1, or -1 for no limit");
            this.getLoadedSettings().put(Setting.pickupLimit.name(), 1);
        }
        this.restrictionsDefaultValues = new HashMap<RestrictionEnum, Boolean>();
        for (RestrictionEnum restriction : RestrictionEnum.values()) {
            if (this.config.contains(restriction.getFeatureSetting().getName())) {
                this.restrictionsDefaultValues.put(restriction, this.config.getBoolean(restriction.getFeatureSetting().getName(), false));
                continue;
            }
            this.restrictionsDefaultValues.put(restriction, this.config.getBoolean("restrictions." + restriction.getFeatureSetting().getName(), false));
        }
        this.damageCausesBlacklisted = new HashMap<Option, List<EntityDamageEvent.DamageCause>>();
        if (this.config.isConfigurationSection("exceptions")) {
            ConfigurationSection configurationSection = this.config.getConfigurationSection("exceptions");
            for (String option : configurationSection.getKeys(false)) {
                if (Option.valueOf(option) != null) {
                    Option opt = Option.valueOf(option);
                    ArrayList<EntityDamageEvent.DamageCause> damageCauses = new ArrayList<EntityDamageEvent.DamageCause>();
                    for (String damageCause : configurationSection.getStringList(option)) {
                        if (EntityDamageEvent.DamageCause.valueOf((String)damageCause) != null) {
                            damageCauses.add(EntityDamageEvent.DamageCause.valueOf((String)damageCause));
                            continue;
                        }
                        ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Invalid damageCause: " + damageCause + " in the option exceptions");
                    }
                    this.damageCausesBlacklisted.put(opt, damageCauses);
                    continue;
                }
                ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Invalid option: " + option + " in the option exceptions");
            }
        }
        this.logs = new HashMap<LOGS, Boolean>();
        if (this.config.isConfigurationSection("logs")) {
            ConfigurationSection configurationSection = this.config.getConfigurationSection("logs");
            for (String log : configurationSection.getKeys(false)) {
                if (log.equalsIgnoreCase("spawned")) {
                    this.logs.put(LOGS.SPAWNED, configurationSection.getBoolean(log));
                    continue;
                }
                if (log.equalsIgnoreCase("dropped")) {
                    this.logs.put(LOGS.DROPPED, configurationSection.getBoolean(log));
                    continue;
                }
                ExecutableItems.plugin.getServer().getLogger().severe("[ExecutableItems] Invalid log: " + log + " in the option logs");
            }
        }
        if (!this.logs.containsKey((Object)LOGS.DROPPED)) {
            this.logs.put(LOGS.DROPPED, false);
        }
        if (!this.logs.containsKey((Object)LOGS.SPAWNED)) {
            this.logs.put(LOGS.SPAWNED, false);
        }
    }

    public void reload() {
        instance = new GeneralConfig();
    }

    public Map<String, List<String>> getWhitelistItemsPerWorld() {
        return this.whitelistItemsPerWorld;
    }

    public List<String> getDisableWorlds() {
        return this.disableWorlds;
    }

    public List<String> getWhitelistWorlds() {
        return this.whitelistWorlds;
    }

    public Map<RestrictionEnum, Boolean> getRestrictionsDefaultValues() {
        return this.restrictionsDefaultValues;
    }

    public Map<Option, List<EntityDamageEvent.DamageCause>> getDamageCausesBlacklisted() {
        return this.damageCausesBlacklisted;
    }

    public boolean isDownloadTexturesPackAtTheNextLoading() {
        return this.downloadTexturesPackAtTheNextLoading;
    }

    public void setWhitelistItemsPerWorld(Map<String, List<String>> whitelistItemsPerWorld) {
        this.whitelistItemsPerWorld = whitelistItemsPerWorld;
    }

    public void setDisableWorlds(List<String> disableWorlds) {
        this.disableWorlds = disableWorlds;
    }

    public void setWhitelistWorlds(List<String> whitelistWorlds) {
        this.whitelistWorlds = whitelistWorlds;
    }

    public void setRestrictionsDefaultValues(Map<RestrictionEnum, Boolean> restrictionsDefaultValues) {
        this.restrictionsDefaultValues = restrictionsDefaultValues;
    }

    public void setDamageCausesBlacklisted(Map<Option, List<EntityDamageEvent.DamageCause>> damageCausesBlacklisted) {
        this.damageCausesBlacklisted = damageCausesBlacklisted;
    }

    public void setDownloadTexturesPackAtTheNextLoading(boolean downloadTexturesPackAtTheNextLoading) {
        this.downloadTexturesPackAtTheNextLoading = downloadTexturesPackAtTheNextLoading;
    }

    public void setLogs(Map<LOGS, Boolean> logs) {
        this.logs = logs;
    }

    public Map<LOGS, Boolean> getLogs() {
        return this.logs;
    }

    public static enum Setting {
        texturesPackUrl,
        selfHostPack,
        enableTexturesPack,
        disableTestItems,
        checkVersionMsg,
        premiumEnableCooldownForOp,
        silentGive,
        silentMessagePreventionErrorHeadDBError,
        disableBackup,
        updateOldItems,
        enableGarbageCollectorAfterReload,
        itemCheckWithNBTAPI,
        muteModification,
        debugOnlyRun,
        pickupLimit,
        deleteBackupsAfterDays,
        giveLimit;

    }

    public static enum LOGS {
        SPAWNED,
        DROPPED;

    }
}

