/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners;

import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.utils.logging.Utils;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.ItemSpawnEvent;

public class DropEventAbove1v12
implements Listener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDropItemEvent(EntityDropItemEvent e) {
        ExecutableItemObject ei = new ExecutableItemObject(e.getItemDrop().getItemStack());
        if (!ei.isValid()) {
            return;
        }
        if (GeneralConfig.getInstance().getLogs().get((Object)GeneralConfig.LOGS.DROPPED).booleanValue()) {
            Utils.sendConsoleMsg((String)("&bExecutableItems &7EI DROPPED: x" + e.getItemDrop().getItemStack().getAmount() + " &e" + ei.getConfig().getId() + " &7by &a" + e.getEntity() + " &7at &6" + e.getEntity().getLocation().getBlockX() + " " + e.getEntity().getLocation().getBlockY() + " " + e.getEntity().getLocation().getBlockZ() + " &7in &6" + e.getEntity().getWorld().getName()));
        }
        ei.getConfig().actionWhenDropped(e.getItemDrop());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockDropItemEvent(BlockDropItemEvent e) {
        for (Item item : e.getItems()) {
            ExecutableItemObject ei = new ExecutableItemObject(item.getItemStack());
            if (!ei.isValid()) continue;
            if (GeneralConfig.getInstance().getLogs().get((Object)GeneralConfig.LOGS.DROPPED).booleanValue()) {
                Utils.sendConsoleMsg((String)("&bExecutableItems &7EI DROPPED: x" + item.getItemStack().getAmount() + " &e" + ei.getConfig().getId() + " &7by &a" + e.getPlayer().getName() + " &7at &6" + e.getPlayer().getLocation().getBlockX() + " " + e.getPlayer().getLocation().getBlockY() + " " + e.getPlayer().getLocation().getBlockZ() + " &7in &6" + e.getPlayer().getWorld().getName()));
            }
            ei.getConfig().actionWhenDropped(item);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemSpawnEvent(ItemSpawnEvent e) {
        ExecutableItemObject ei = new ExecutableItemObject(e.getEntity().getItemStack());
        if (!ei.isValid()) {
            return;
        }
        if (GeneralConfig.getInstance().getLogs().get((Object)GeneralConfig.LOGS.SPAWNED).booleanValue()) {
            Utils.sendConsoleMsg((String)("&bExecutableItems &7EI SPAWNED: x" + e.getEntity().getItemStack().getAmount() + " &e" + ei.getConfig().getId() + " &7at &6" + e.getEntity().getLocation().getBlockX() + " " + e.getEntity().getLocation().getBlockY() + " " + e.getEntity().getLocation().getBlockZ() + " &7in &6" + e.getEntity().getLocation().getWorld().getName()));
        }
    }
}

