/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.projectiles;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ProjectileHitBlockEvent
implements Listener {
    private static final Boolean DEBUG = false;

    @EventHandler
    public void projectileHitBlockEvent(com.ssomar.sevents.events.projectile.hitblock.ProjectileHitBlockEvent e) {
        SsomarDev.testMsg((String)("ProjectileHitBlockEvent > " + e.getBlock().getType() + " uuid: " + e.getEntity().getUniqueId()), (boolean)DEBUG);
        Entity entity = e.getEntity();
        Optional<ProjectileInfo> pInfoOpt = ProjectilesHandler.getInstance().getProjectileInfo(entity.getUniqueId());
        if (!pInfoOpt.isPresent()) {
            return;
        }
        SsomarDev.testMsg((String)"ProjectileHitBlockEvent: ProjectileInfo found", (boolean)DEBUG);
        ProjectileInfo pInfo = pInfoOpt.get();
        Block b = e.getBlock();
        Optional<ExecutableItemObject> ei = pInfo.getEiOpt();
        SsomarDev.testMsg((String)("ProjectileHitBlockEvent: ExecutableItem present ? " + ei.isPresent()), (boolean)DEBUG);
        EventInfo eInfo = new EventInfo((Event)e);
        eInfo.setPlayer(Optional.of(pInfo.getLauncher()));
        eInfo.setTargetBlock(Optional.of(b));
        eInfo.setOldMaterialBlock(Optional.of(b.getType()));
        eInfo.setProjectile(Optional.of((Projectile)entity));
        eInfo.setBlockface(Optional.of(e.getBlockFace().toString()));
        eInfo.setSlot(Optional.of(pInfo.getSlot()));
        if (ei.isPresent()) {
            eInfo.setProjectileProvenance(Optional.ofNullable(ei.get().getConfig().getId()));
        }
        boolean runActivatorsItemNotInTheInventory = false;
        if (ei.isPresent()) {
            if (ei.get().getItem() == null || ei.get().getItem().getType().equals((Object)Material.AIR)) {
                runActivatorsItemNotInTheInventory = true;
                ei.get().setItem(null);
            }
            boolean bl = runActivatorsItemNotInTheInventory = runActivatorsItemNotInTheInventory || !SCore.is1v12Less() && ei.get().getItem() != null && ei.get().getItem().getType().equals((Object)Material.TRIDENT);
            if (runActivatorsItemNotInTheInventory) {
                eInfo.setProjectileProvenance(Optional.ofNullable(">NULL<"));
                eInfo.setMainHand(true);
                SsomarDev.testMsg((String)"ProjectileHitBlockEvent: ExecutableItem found + item is null", (boolean)DEBUG);
                ExecutableItem config = pInfo.getEiOpt().get().getConfig();
                for (SActivator activator : config.getActivators().getActivators().values()) {
                    if (!activator.getOption().equals((Object)Option.PROJECTILE_HIT_BLOCK)) continue;
                    activator.runWithException((Object)ei.get(), eInfo);
                }
            }
        }
        eInfo.setOption((SOption)Option.PROJECTILE_HIT_BLOCK);
        EventsManager.getInstance().activeOption(eInfo);
    }
}

