/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.pack;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.score.SCore;
import com.ssomar.score.pack.custom.PackManager;
import com.ssomar.score.pack.custom.PackSettings;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bukkit.command.CommandSender;

public class ExecutableItemsPack {
    static final UUID packUUID = UUID.fromString("b358fedf-bcf4-46d5-a6ad-93798c4b14c0");
    public static String texturesFolder = ExecutableItems.plugin.getPlugin().getDataFolder().getPath() + File.separator + "__textures__";
    public static String TPACK_NAME = SCore.is1v21v4Plus() ? "ExecutableItems_Pack_1_21_4.zip" : "ExecutableItems_Pack_1_21_4.zip";
    public static String DEFAULT_TEXTURES_PACK_PATH = texturesFolder + File.separator + TPACK_NAME;

    public static void unregisterPack() {
        PackManager.getInstance().removePack(packUUID);
    }

    public static void registerPack() {
        String folderPath = ExecutableItems.plugin.getDataFolder() + File.separator + "__textures__";
        File folder = new File(folderPath);
        File[] files = folder.listFiles();
        File packFile = null;
        File createdZipFile = null;
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                ArrayList<String> filesInFolder = new ArrayList<String>();
                ArrayList<String> foldersInFolder = new ArrayList<String>();
                for (File fileInFolder : file.listFiles()) {
                    if (fileInFolder.isFile()) {
                        filesInFolder.add(fileInFolder.getAbsolutePath());
                        continue;
                    }
                    if (!fileInFolder.isDirectory()) continue;
                    foldersInFolder.add(fileInFolder.getAbsolutePath());
                }
                createdZipFile = new File(folderPath + File.separator + file.getName() + ".zip");
                if (createdZipFile.exists()) {
                    createdZipFile.delete();
                }
                try {
                    ExecutableItemsPack.createZip(folderPath + File.separator + file.getName() + ".zip", filesInFolder, foldersInFolder);
                }
                catch (IOException e) {
                    ExecutableItems.plugin.getLogger().warning("Error creating zip file: " + e.getMessage());
                }
                packFile = createdZipFile;
                break;
            }
            if (packFile == null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".zip")) continue;
                    packFile = file;
                    break;
                }
            }
        }
        if (packFile == null) {
            ExecutableItems.plugin.getLogger().warning("No pack found in the folder __textures__");
            return;
        }
        String filePath = packFile.getAbsolutePath();
        PackSettings packSettings = new PackSettings((SPlugin)ExecutableItems.plugin, packUUID, filePath, "", true, createdZipFile != null);
        PackManager.getInstance().addPack(packSettings);
    }

    public static void createZip(String zipFilePath, List<String> filePaths, List<String> folderPaths) throws IOException {
        File check = new File(zipFilePath);
        if (check.exists()) {
            check.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            if (filePaths != null) {
                for (String filePath : filePaths) {
                    File file = new File(filePath);
                    if (!file.exists() || !file.isFile()) continue;
                    ExecutableItemsPack.addFileToZip(file, file.getName(), zos);
                }
            }
            if (folderPaths != null) {
                for (String folderPath : folderPaths) {
                    File folder = new File(folderPath);
                    if (!folder.exists() || !folder.isDirectory()) continue;
                    ExecutableItemsPack.addFolderToZip(folder, folder.getName(), zos);
                }
            }
        }
    }

    private static void addFileToZip(File file, String entryName, ZipOutputStream zos) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zos.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
        }
        zos.closeEntry();
    }

    private static void addFolderToZip(File folder, String parentPath, ZipOutputStream zos) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String entryPath = parentPath + "/" + file.getName();
            if (file.isDirectory()) {
                ZipEntry zipEntry = new ZipEntry(entryPath + "/");
                zos.putNextEntry(zipEntry);
                zos.closeEntry();
                ExecutableItemsPack.addFolderToZip(file, entryPath, zos);
                continue;
            }
            ExecutableItemsPack.addFileToZip(file, entryPath, zos);
        }
    }

    public static void downloadPack(CommandSender commandSender, boolean deleteIfExists) {
        File file = new File(texturesFolder);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            File defaultack = new File(DEFAULT_TEXTURES_PACK_PATH);
            if (defaultack.exists()) {
                if (deleteIfExists) {
                    defaultack.delete();
                } else {
                    SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(ExecutableItems.plugin.getNameDesign() + " &7The default pack is already downloaded, Delete it first if you want to refresh it."));
                    return;
                }
            }
        }
        ExecutableItemsPack.downloadPackGithub(commandSender);
    }

    protected static void downloadPackGithub(CommandSender commandSender) {
        String DOWNLOAD_URL = "https://github.com/Ssomar-Developement/ExecutableItems-pack/raw/main/" + TPACK_NAME;
        InputStream in = null;
        try {
            in = new URL(DOWNLOAD_URL).openStream();
            Files.copy(in, Paths.get(DEFAULT_TEXTURES_PACK_PATH, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(ExecutableItems.plugin.getNameDesign() + " &7Download of the default pack succeeded (from Github) !"));
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(ExecutableItems.plugin.getNameDesign() + " &7The pack contains textures from the &eFantasy 3D Weapons pack &7made by &enongko"));
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(ExecutableItems.plugin.getNameDesign() + " &7Fantasy 3D Weapons pack discord: &ehttps://discord.gg/9YuWUr8guC"));
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(ExecutableItems.plugin.getNameDesign() + " &7Fantasy 3D Weapons link: &ehttps://modrinth.com/resourcepack/fantasy-3d-weapons-cit"));
        }
        catch (IOException e) {
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(ExecutableItems.plugin.getNameDesign() + " &7The plugin can't download the github pack. Verify your internet connection."));
        }
    }

    public static void unzipPack() {
        String ZIP_FILE = texturesFolder + File.separator + TPACK_NAME;
        File DESTINATION_FOLDER = new File(texturesFolder + File.separator + "ExecutableItems_Pack");
        byte[] buffer = new byte[1024];
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(ZIP_FILE));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        ZipEntry zipEntry = null;
        try {
            zipEntry = zis.getNextEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (zipEntry != null) {
            try {
                File newFile = ExecutableItemsPack.newFile(DESTINATION_FOLDER, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

