/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.projectiles;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.score.SCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;

public class ProjectilesHandler {
    private static ProjectilesHandler instance;
    private List<ProjectileInfo> launchedProjectiles = new ArrayList<ProjectileInfo>();
    private boolean inLoopRemove = false;
    private boolean inLoopCustomActivator = false;

    public ProjectilesHandler() {
        this.activeLoopRemove();
        this.activeLoopCustomActivator();
    }

    public static ProjectilesHandler getInstance() {
        if (instance == null) {
            instance = new ProjectilesHandler();
        }
        return instance;
    }

    public void addProjectileInfo(final ProjectileInfo pInfo) {
        if (this.inLoopRemove || this.inLoopCustomActivator) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProjectilesHandler.this.addProjectileInfo(pInfo);
                }
            };
            SCore.schedulerHook.runTask(runnable, 5L);
        } else {
            this.launchedProjectiles.add(pInfo);
        }
    }

    public Optional<ProjectileInfo> getProjectileInfo(UUID projectileUUID) {
        ProjectileInfo result = null;
        for (ProjectileInfo pInfo : this.launchedProjectiles) {
            if (!projectileUUID.equals(pInfo.getUuid())) continue;
            result = pInfo;
            break;
        }
        return Optional.ofNullable(result);
    }

    public void remove(ProjectileInfo pInfo) {
        this.launchedProjectiles.remove(pInfo);
    }

    public void activeLoopRemove() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectilesHandler.getInstance().setInLoopRemove(true);
                Long time = System.currentTimeMillis();
                ProjectilesHandler.this.launchedProjectiles.removeIf(pInfo -> pInfo.getCreationTime() + 30000L < time);
                ProjectilesHandler.getInstance().setInLoopRemove(false);
            }
        };
        SCore.schedulerHook.runRepeatingTask(runnable, 0L, 1200L);
    }

    public void activeLoopCustomActivator() {
        if (SCore.is1v11Less()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectilesHandler.getInstance().setInLoopCustomActivator(true);
                for (final ProjectileInfo pInfo : new ArrayList(ProjectilesHandler.this.launchedProjectiles)) {
                    Projectile projectile;
                    if (pInfo.isInLiquid() || (projectile = (Projectile)Bukkit.getServer().getEntity(pInfo.getUuid())) == null) continue;
                    Runnable runnable1 = new Runnable(){

                        @Override
                        public void run() {
                            boolean isValid;
                            boolean bl = isValid = SCore.is1v12Less() && projectile.getLocation().getBlock().getType().equals((Object)Material.WATER) || !SCore.is1v12Less() && projectile.isInWater();
                            if (isValid) {
                                pInfo.setInLiquid(true);
                                Block b = projectile.getLocation().getBlock();
                                Optional<ExecutableItemObject> ei = pInfo.getEiOpt();
                                EventInfo eInfo = new EventInfo(null);
                                eInfo.setPlayer(Optional.of(pInfo.getLauncher()));
                                eInfo.setTargetBlock(Optional.of(b));
                                eInfo.setOldMaterialBlock(Optional.of(b.getType()));
                                eInfo.setProjectile(Optional.of(projectile));
                                eInfo.setSlot(Optional.of(pInfo.getSlot()));
                                if (ei.isPresent()) {
                                    eInfo.setProjectileProvenance(Optional.ofNullable(ei.get().getConfig().getId()));
                                }
                                if (ei.isPresent() && (ei.get().getItem() == null || ei.get().getItem().getType().equals((Object)Material.AIR))) {
                                    ei.get().setItem(null);
                                    eInfo.setProjectileProvenance(Optional.ofNullable(">NULL<"));
                                    eInfo.setMainHand(true);
                                    ExecutableItem config = pInfo.getEiOpt().get().getConfig();
                                    for (SActivator activator : config.getActivators().getActivators().values()) {
                                        if (!activator.getOption().equals((Object)Option.PROJECTILE_ENTER_IN_LIQUID)) continue;
                                        activator.runWithException((Object)ei.get(), eInfo);
                                    }
                                }
                                eInfo.setOption((SOption)Option.PROJECTILE_ENTER_IN_LIQUID);
                                EventsManager.getInstance().activeOption(eInfo);
                            }
                        }
                    };
                    SCore.schedulerHook.runEntityTaskAsap(runnable1, null, (Entity)projectile);
                }
                ProjectilesHandler.getInstance().setInLoopCustomActivator(false);
            }
        };
        SCore.schedulerHook.runRepeatingTask(runnable, 0L, 20L);
    }

    public List<ProjectileInfo> getLaunchedProjectiles() {
        return this.launchedProjectiles;
    }

    public boolean isInLoopRemove() {
        return this.inLoopRemove;
    }

    public boolean isInLoopCustomActivator() {
        return this.inLoopCustomActivator;
    }

    public void setLaunchedProjectiles(List<ProjectileInfo> launchedProjectiles) {
        this.launchedProjectiles = launchedProjectiles;
    }

    public void setInLoopRemove(boolean inLoopRemove) {
        this.inLoopRemove = inLoopRemove;
    }

    public void setInLoopCustomActivator(boolean inLoopCustomActivator) {
        this.inLoopCustomActivator = inLoopCustomActivator;
    }
}

