/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.executableitems;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableitems.config.ExecutableItemObjectInterface;
import com.ssomar.score.api.executableitems.events.RemoveItemInPlayerInventoryEvent;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureForItemNewPaperComponents;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.custom.durabilityFeatures.DurabilityFeatures;
import com.ssomar.score.features.custom.enchantments.enchantment.EnchantmentWithLevelFeature;
import com.ssomar.score.features.custom.potionsettings.PotionSettingsFeature;
import com.ssomar.score.features.custom.restrictions.RestrictionEnum;
import com.ssomar.score.features.custom.usage.UsageFeatures;
import com.ssomar.score.features.custom.usecooldown.UseCooldownFeatures;
import com.ssomar.score.features.custom.variables.base.variable.VariableFeature;
import com.ssomar.score.features.custom.variables.real.VariableReal;
import com.ssomar.score.features.custom.variables.real.VariableRealBuilder;
import com.ssomar.score.features.custom.variables.real.VariableRealsList;
import com.ssomar.score.features.custom.variables.update.group.VariableUpdateGroupFeature;
import com.ssomar.score.features.custom.variables.update.variable.VariableUpdateFeature;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.sobject.SObjectWithVariables;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.FixedMaterial;
import com.ssomar.score.utils.ToolsListMaterial;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.emums.VariableUpdateType;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReaderManager;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.tag.DamageTypeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableItemObject
implements ExecutableItemObjectInterface {
    private static final boolean DEBUG = true;
    private ExecutableItem config;
    private InternalData internalData;
    private ItemStack item;
    private boolean valid;
    private ItemKeyWriterReader itemKeyWriterReader = ItemKeyWriterReaderManager.getInstance().getItemKeyWriterReader();
    private boolean executableItemInfosLoaded;
    private DynamicMeta dMetaAfterLoading;

    public ExecutableItemObject(@NotNull ItemStack item) {
        this(item, new ArrayList<String>(), false);
    }

    public ExecutableItemObject(@NotNull ItemStack item, List<String> whiteListedEI) {
        this(item, whiteListedEI, false);
    }

    public ExecutableItemObject(@NotNull ItemStack item, boolean loadExecutableItemInfosLater) {
        this(item, new ArrayList<String>(), loadExecutableItemInfosLater);
    }

    public ExecutableItemObject(@NotNull ItemStack item, boolean loadExecutableItemInfosLater, DynamicMeta dMeta) {
        this(item, new ArrayList<String>(), loadExecutableItemInfosLater, dMeta);
    }

    public ExecutableItemObject(@NotNull ItemStack item, List<String> whiteListedEI, boolean loadExecutableItemInfosLater) {
        this(item, whiteListedEI, loadExecutableItemInfosLater, new DynamicMeta(null));
    }

    public ExecutableItemObject(@NotNull ItemStack item, List<String> whiteListedEI, boolean loadExecutableItemInfosLater, DynamicMeta dMeta) {
        this.item = item;
        this.internalData = new InternalData();
        if (item != null && (item.getType().isEdible() || ToolsListMaterial.getInstance().getOneUsageMaterial().contains(item.getType()))) {
            this.internalData.setUsage(1);
        }
        boolean bl = this.valid = (this.config = ExecutableItemsManager.getInstance().getExecutableItem(item, whiteListedEI, dMeta)) != null;
        if (this.valid && !loadExecutableItemInfosLater) {
            this.loadExecutableItemInfos(dMeta);
        }
    }

    public ExecutableItemObject(@NotNull ItemStack item, @NotNull ExecutableItem config, @Nullable UUID owner, int usage) {
        this.item = item;
        this.config = config;
        this.internalData = new InternalData().setOwnerUUID(owner).setUsage(usage);
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item).getItemMeta());
        }
        this.valid = true;
        this.initOrReadVariables(new DynamicMeta(null));
        this.executableItemInfosLoaded = true;
    }

    public ExecutableItemObject(@NotNull ItemStack item, @NotNull ExecutableItem config, @Nullable InternalData internalData) {
        this.item = item;
        this.config = config;
        this.internalData = internalData;
        if (internalData == null) {
            this.internalData = new InternalData();
            this.internalData.setUsage(((Integer)config.getUsageFeatures().getUsage().getValue().get()).intValue());
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item).getItemMeta());
        }
        this.valid = true;
        this.initOrReadVariables(new DynamicMeta(null));
        this.executableItemInfosLoaded = true;
    }

    public void loadExecutableItemInfos() {
        this.loadExecutableItemInfos(new DynamicMeta(null));
    }

    public void loadExecutableItemInfos(DynamicMeta dynamicMeta) {
        if (this.item != null && !this.executableItemInfosLoaded) {
            if (dynamicMeta.getMeta() == null) {
                dynamicMeta.setMeta(this.item.getItemMeta());
            }
            if (dynamicMeta.getMeta() != null) {
                this.internalData.loadFromItem(this.item, dynamicMeta, (SObjectWithVariables)this.getConfig());
            } else {
                this.item.setItemMeta(new ItemStack(this.item.getType()).getItemMeta());
                this.internalData.setOwnerUUID(null);
                dynamicMeta.setMeta(this.item.getItemMeta());
            }
            this.initOrReadVariables(dynamicMeta);
            this.executableItemInfosLoaded = true;
            this.dMetaAfterLoading = dynamicMeta;
        }
    }

    public ItemStack build() {
        if (this.valid) {
            DynamicMeta dMeta = new DynamicMeta(this.item.getItemMeta());
            this.addExecutableItemTag(dMeta);
            this.item.setItemMeta(dMeta.getMeta());
            ArrayList<ResetSetting> resetSettings = new ArrayList<ResetSetting>();
            resetSettings.add(ResetSetting.MATERIAL);
            resetSettings.add(ResetSetting.DURABILITY);
            resetSettings.add(ResetSetting.ENCHANTS);
            resetSettings.add(ResetSetting.ATTRIBUTES);
            resetSettings.add(ResetSetting.NAME);
            resetSettings.add(ResetSetting.LORE);
            resetSettings.add(ResetSetting.ARMOR_SETTINGS);
            resetSettings.add(ResetSetting.ITEM_RARITY);
            resetSettings.add(ResetSetting.EQUIPPABLE);
            resetSettings.add(ResetSetting.REPAIRABLE);
            resetSettings.add(ResetSetting.HIDERS);
            resetSettings.add(ResetSetting.INSTRUMENT);
            resetSettings.add(ResetSetting.TOOL_RULES);
            resetSettings.add(ResetSetting.FIREWORK);
            resetSettings.add(ResetSetting.FIREWORK_EXPLOSION);
            resetSettings.add(ResetSetting.CONTAINER);
            resetSettings.add(ResetSetting.HEAD);
            resetSettings.add(ResetSetting.BANNER);
            resetSettings.add(ResetSetting.FOOD);
            resetSettings.add(ResetSetting.CONSUMABLE);
            resetSettings.add(ResetSetting.BUNDLE);
            resetSettings.add(ResetSetting.BLOCK_STATE);
            resetSettings.add(ResetSetting.CHARGED_PROJECTILES);
            resetSettings.add(ResetSetting.MYFURNITURE);
            resetSettings.add(ResetSetting.SPAWNER);
            resetSettings.add(ResetSetting.BOOK);
            resetSettings.add(ResetSetting.WEAPON);
            resetSettings.add(ResetSetting.BLOCK_ATTACKS);
            resetSettings.add(ResetSetting.TOOLTIP_MODEL);
            this.refresh(resetSettings);
        }
        return this.item;
    }

    public ItemStack refresh(List<ResetSetting> resetSettings) {
        if (resetSettings.contains(ResetSetting.USAGE)) {
            this.internalData.setUsage(((Integer)this.config.getUsageFeatures().getUsage().getValue().get()).intValue());
        }
        if (SCore.is1v20v5Plus() && resetSettings.contains(ResetSetting.MATERIAL)) {
            this.item.setType((Material)this.config.getMaterial().getValue().get());
        }
        DynamicMeta meta = new DynamicMeta(this.item.getItemMeta());
        this.refreshMeta(meta, resetSettings);
        if (resetSettings.contains(ResetSetting.DURABILITY) && SCore.is1v13Less()) {
            this.refreshDurability1v13less();
        }
        this.refreshPotionSettings();
        this.refreshNbtTags();
        return this.item;
    }

    public void refreshItem() {
        this.refresh(Arrays.asList(ResetSetting.values()));
    }

    public void refreshMeta(DynamicMeta dMeta, List<ResetSetting> resetSettings) {
        FeatureForItem featureForItem;
        if (resetSettings.contains(ResetSetting.LORE)) {
            this.refreshLore(dMeta, true);
        }
        this.refreshName(dMeta, resetSettings.contains(ResetSetting.NAME));
        this.refreshUsage(dMeta, false);
        if (resetSettings.contains(ResetSetting.ATTRIBUTES)) {
            this.refreshAttributes(dMeta);
        }
        if (resetSettings.contains(ResetSetting.ENCHANTS)) {
            this.refreshEnchantmentsAndGlow(dMeta);
        }
        if (resetSettings.contains(ResetSetting.DURABILITY) && !SCore.is1v13Less()) {
            this.refreshDurability1v14plus(dMeta);
        }
        Material material = this.item.getType();
        for (FeatureInterface featureInterface : this.config.getFeatures()) {
            if (!(featureInterface instanceof FeatureForItem) || !resetSettings.contains((featureForItem = (FeatureForItem)featureInterface).getResetSetting())) continue;
            StringPlaceholder sp = this.getStringPlaceholderWithVariables();
            featureForItem.applyOnItemMeta(FeatureForItemArgs.create((ItemMeta)dMeta.getMeta()));
        }
        this.refreshUseCooldown(dMeta);
        this.refreshUnbreakable(dMeta);
        this.refreshOwner(dMeta);
        this.refreshExtraInfos(dMeta);
        if (resetSettings.contains(ResetSetting.ARMOR_SETTINGS)) {
            this.refreshArmorSetings(dMeta);
        }
        if (resetSettings.contains(ResetSetting.CUSTOM_MODEL_DATA)) {
            this.refreshCustomModelData(dMeta);
        }
        if (resetSettings.contains(ResetSetting.ITEM_RARITY)) {
            this.refreshItemRarity(dMeta);
        }
        this.refreshFireResistent(dMeta);
        this.refreshGlider(dMeta);
        this.refreshModel(dMeta, resetSettings.contains(ResetSetting.TOOLTIP_MODEL));
        this.item.setItemMeta(dMeta.getMeta());
        for (FeatureInterface featureInterface : this.config.getFeatures()) {
            if (!(featureInterface instanceof FeatureForItemNewPaperComponents) || !(featureForItem = (FeatureForItemNewPaperComponents)featureInterface).isAvailableForNewComponents() || !resetSettings.contains(featureForItem.getResetSetting())) continue;
            featureForItem.applyOnItem(FeatureForItemArgs.create((ItemStack)this.item));
        }
    }

    public void refreshLore(DynamicMeta dMeta) {
        this.refreshLore(dMeta, false);
    }

    public void refreshLore(DynamicMeta dMeta, boolean forceResfresh) {
        List<Object> lore;
        List<String> oldLore = new ArrayList();
        ItemMeta meta = dMeta.getMeta();
        if (meta.hasLore()) {
            oldLore = meta.getLore();
            this.cleanUsageParticleInLore(oldLore);
        }
        if (forceResfresh || oldLore.size() == this.config.getLore().getColoredValue().size()) {
            lore = new ArrayList(this.config.getLore().getColoredValue());
            if (ExecutableItems.plugin.isLotOfWork()) {
                lore.add(StringConverter.coloredString((String)"&7"));
                lore.add(StringConverter.coloredString((String)"&7&oMade with &bExecutableItems"));
            }
        } else {
            lore = oldLore;
        }
        boolean containsDurabilityPlaceholder = false;
        for (int i = 0; i < lore.size(); ++i) {
            String s = (String)lore.get(i);
            if (s.contains("%durability%")) {
                containsDurabilityPlaceholder = true;
            }
            s = this.refreshVariables_Owner_Usage_PlaceholdersInString(s, s);
            lore.set(i, s);
        }
        this.addUsageParticleInLore(lore);
        meta.setLore(lore);
        SsomarDev.testMsg((String)("Refreshing dura ? " + containsDurabilityPlaceholder), (boolean)true);
        if (containsDurabilityPlaceholder) {
            SsomarDev.testMsg((String)"Refreshing durability in lore", (boolean)true);
            Runnable runnable = () -> {
                ItemStack item = this.getItem();
                int durability = 0;
                if (item.getItemMeta() instanceof Damageable) {
                    Damageable damageable = (Damageable)item.getItemMeta();
                    int maxDamage = item.getType().getMaxDurability();
                    if (SCore.is1v20v5Plus() && damageable.hasMaxDamage()) {
                        maxDamage = damageable.getMaxDamage();
                    }
                    durability = maxDamage - damageable.getDamage();
                }
                for (int i = 0; i < lore.size(); ++i) {
                    String s = (String)lore.get(i);
                    s = s.replaceAll("%durability%", durability + "");
                    lore.set(i, s);
                }
                ItemMeta metaAfter = item.getItemMeta();
                metaAfter.setLore(lore);
                item.setItemMeta(metaAfter);
            };
            SCore.schedulerHook.runTask(runnable, 1L);
        }
    }

    public void refreshLore(DynamicMeta dMeta, List<String> forcedLore) {
        ItemMeta meta = dMeta.getMeta();
        forcedLore = StringConverter.coloredString(forcedLore);
        meta.setLore(forcedLore);
    }

    public Optional<OfflinePlayer> getOwnerPlayer() {
        return this.internalData.getOfflineOwnerOptional();
    }

    public void refreshName(DynamicMeta dMeta) {
        this.refreshName(dMeta, false);
    }

    public void refreshName(DynamicMeta dMeta, boolean forceResfresh) {
        String name = "";
        name = forceResfresh ? (String)this.config.getDisplayName().getColoredValue().get() : dMeta.getMeta().getDisplayName();
        name = this.refreshVariables_Owner_Usage_PlaceholdersInString(name, (String)this.config.getDisplayName().getColoredValue().get());
        dMeta.getMeta().setDisplayName(name);
    }

    public String refreshVariables_Owner_Usage_PlaceholdersInString(String toRefresh, String defaultString) {
        Optional<OfflinePlayer> potentialOwner = this.getOwnerPlayer();
        if (defaultString != null && defaultString.contains("%")) {
            boolean isRefreshable;
            String toReplace = defaultString;
            String ownerName = "&cNo owner";
            Optional owner = this.internalData.getOfflineOwnerOptional();
            if (owner.isPresent()) {
                OfflinePlayer ownerPlayer = potentialOwner.get();
                ownerName = ownerPlayer.getName();
            }
            for (VariableReal var : this.internalData.getVariableRealsList()) {
                toReplace = var.replaceVariablePlaceholder(toReplace, true);
            }
            if (toReplace.contains("%player%")) {
                toReplace = toReplace.replaceAll("%player%", ownerName);
            }
            String optTag = (isRefreshable = this.getConfig().getUsageFeatures().getIsRefreshableClean().getValue().booleanValue()) ? VariableFeature.generateTag((String)"USAGE") : "";
            String placeholderToReplace = "%usage%";
            if (toReplace.contains(placeholderToReplace)) {
                toReplace = StringPlaceholder.replaceCalculPlaceholder((String)toReplace, (String)placeholderToReplace, (String)(this.internalData.getUsage() + ""), (String)optTag, (String)(isRefreshable ? this.getPlaceholderTag(placeholderToReplace) : ""), (boolean)true);
                SsomarDev.testMsg((String)("toReplace usage : " + StringConverter.deconvertColor((String)toReplace)), (boolean)true);
            }
            if (toReplace.contains(placeholderToReplace = "%usage_roman%")) {
                toReplace = StringPlaceholder.replaceCalculPlaceholder((String)toReplace, (String)placeholderToReplace, (String)(this.internalData.getUsage() + ""), (String)optTag, (String)(isRefreshable ? this.getPlaceholderTag(placeholderToReplace) : ""), (boolean)true, (boolean)true);
            }
            if (toReplace.contains(placeholderToReplace = "%usage_limit%")) {
                toReplace = StringPlaceholder.replaceCalculPlaceholder((String)toReplace, (String)placeholderToReplace, (String)(this.config.getUsageFeatures().getUsageLimit().getValue().get() + ""), (String)optTag, (String)(isRefreshable ? this.getPlaceholderTag(placeholderToReplace) : ""), (boolean)true);
            }
            if (toReplace.contains("%usage_bar")) {
                int j;
                String toReplaceBar = "%usage_bar%";
                int amount = 30;
                String color1 = "&e";
                String color2 = "&a";
                String symbol = "|";
                try {
                    String potentialArgs = toReplace.split("%usage_bar")[1].split("%")[0];
                    toReplaceBar = "%usage_bar" + potentialArgs + "%";
                    if (potentialArgs.contains("(") && potentialArgs.contains(")")) {
                        potentialArgs = potentialArgs.replaceAll("\\(", "");
                        String[] args = (potentialArgs = potentialArgs.replaceAll("\\)", "")).split(",");
                        if (args.length > 0) {
                            for (String arg : args) {
                                if (arg.contains("amount:")) {
                                    try {
                                        amount = Integer.parseInt(arg.split(":")[1]);
                                    }
                                    catch (NumberFormatException e) {}
                                    continue;
                                }
                                if (arg.contains("color1:")) {
                                    color1 = arg.split(":")[1];
                                    continue;
                                }
                                if (arg.contains("color2:")) {
                                    color2 = arg.split(":")[1];
                                    continue;
                                }
                                if (!arg.contains("symbol:")) continue;
                                symbol = arg.split(":")[1];
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                double usageLimit = ((Integer)this.config.getUsageFeatures().getUsageLimit().getValue().get()).intValue();
                if (usageLimit == -1.0) {
                    usageLimit = ((Integer)this.config.getUsageFeatures().getUsage().getValue().get()).intValue();
                }
                double div = (double)this.internalData.getUsage() / usageLimit;
                int barAmount = (int)Math.round(div * (double)amount);
                StringBuilder bar = new StringBuilder();
                bar.append(color1);
                for (j = 0; j < barAmount; ++j) {
                    bar.append(symbol);
                }
                bar.append(color2);
                for (j = barAmount; j < amount; ++j) {
                    bar.append(symbol);
                }
                toReplace = toReplace.replaceAll(Pattern.quote(toReplaceBar), optTag + StringConverter.coloredString((String)bar.toString()) + (isRefreshable ? this.getPlaceholderTag(placeholderToReplace) : "") + optTag);
            }
            if (SCore.hasPlaceholderAPI) {
                SsomarDev.testMsg((String)" has papi", (boolean)true);
                if (potentialOwner.isPresent()) {
                    toReplace = StringConverter.coloredString((String)PlaceholderAPI.setPlaceholders((OfflinePlayer)potentialOwner.get(), (String)toReplace));
                    SsomarDev.testMsg((String)(" toReplace papi : " + StringConverter.deconvertColor((String)toReplace)), (boolean)true);
                } else if (Bukkit.getOnlinePlayers().size() > 0) {
                    toReplace = StringConverter.coloredString((String)PlaceholderAPI.setPlaceholders((Player)((Player)Bukkit.getOnlinePlayers().iterator().next()), (String)toReplace));
                }
            }
            return toReplace;
        }
        return toRefresh;
    }

    private StringPlaceholder getStringPlaceholderWithVariables() {
        StringPlaceholder sp = new StringPlaceholder();
        sp.setVariables((List)this.internalData.getVariableRealsList());
        return sp;
    }

    public void initOrReadVariables(DynamicMeta dMeta) {
        boolean editedMeta = false;
        if (dMeta.getMeta() == null) {
            dMeta.setMeta(this.item.getItemMeta());
        }
        if (dMeta.getMeta() == null) {
            ExecutableItems.plugin.getLogger().severe("DEBUG ERROR EI META NULL 1 NOT NORMAL, If you see this message join the discord and advert Ssomar pls !");
            return;
        }
        this.internalData.setVariableRealsList(new VariableRealsList());
        if (this.config.getDisableStack().getValue().booleanValue()) {
            this.itemKeyWriterReader.writeStringIfNull((Plugin)ExecutableItems.plugin, this.item, dMeta, "EI-DISABLESTACK", UUID.randomUUID().toString());
            editedMeta = true;
        }
        if (SCore.is1v20v5Plus() && this.config.getCustomStackSize().getValue().isPresent() && (Integer)this.config.getCustomStackSize().getValue().get() > 0) {
            int maxStackSize = (Integer)this.config.getCustomStackSize().getValue().get();
            if (maxStackSize > 99) {
                maxStackSize = 99;
            }
            dMeta.getMeta().setMaxStackSize(Integer.valueOf(maxStackSize));
            editedMeta = true;
        }
        if (dMeta.getMeta() == null) {
            ExecutableItems.plugin.getLogger().severe("DEBUG ERROR EI META NULL 2, If you see this message join the discord and advert Ssomar pls !");
            return;
        }
        for (VariableFeature vC : this.config.getVariables().getVariables().values()) {
            this.internalData.getVariableRealsList().add((Object)((VariableReal)VariableRealBuilder.build((VariableFeature)vC, (ItemStack)this.item, (DynamicMeta)dMeta).get()));
        }
        if (SCore.is1v16Plus()) {
            ArrayList<NamespacedKey> toRemove = new ArrayList<NamespacedKey>();
            for (NamespacedKey aK : dMeta.getMeta().getPersistentDataContainer().getKeys()) {
                String key = aK.getKey().toUpperCase();
                if (!key.contains("EI-") && !key.contains("SCORE-") || key.equals("EI-USAGE") || key.equals("SCORE-USAGE") || key.equals("EI-ID") || key.equals("EI-OWNER") || key.equals("EI-DISABLESTACK") && this.config.getDisableStack().getValue().booleanValue()) continue;
                boolean find = false;
                if (key.contains("EI-")) {
                    toRemove.add(aK);
                    break;
                }
                for (VariableFeature vC : this.config.getVariables().getVariables().values()) {
                    if (!("SCORE-" + ((String)vC.getVariableName().getValue().get()).toUpperCase()).equals(key)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                toRemove.add(aK);
            }
            for (NamespacedKey nK : toRemove) {
                dMeta.getMeta().getPersistentDataContainer().remove(nK);
                editedMeta = true;
            }
        }
        if (editedMeta) {
            this.item.setItemMeta(dMeta.getMeta());
        }
    }

    public void updateVariables(DynamicMeta dMeta, VariableUpdateGroupFeature updates, @Nullable Player p, @Nullable StringPlaceholder sp) {
        SsomarDev.testMsg((String)"updateVariables 1", (boolean)true);
        for (VariableUpdateFeature update : updates.getVariablesUpdates().values()) {
            SsomarDev.testMsg((String)("updateVariables 1 launch " + update.getId()), (boolean)true);
            this.updateVariable(update, dMeta, p, sp);
        }
    }

    public String updateVariable(String variableName, String value, VariableUpdateType type) {
        String variableNameUpper = variableName.toUpperCase();
        Map variables = this.internalData.getVariables();
        if (type.equals((Object)VariableUpdateType.MODIFICATION)) {
            if (NTools.isNumber((String)value) && variables.containsKey(variableNameUpper) && NTools.isNumber((String)((String)variables.get(variableNameUpper)))) {
                double newValue = Double.parseDouble(value);
                double oldValue = Double.parseDouble((String)variables.get(variableNameUpper));
                double addition = newValue + oldValue;
                variables.put(variableNameUpper, addition + "");
            } else {
                variables.put(variableNameUpper, (String)variables.get(variableNameUpper) + "" + value);
            }
        } else {
            variables.put(variableNameUpper, value);
        }
        UUID uuid = this.internalData.getOwnerUUID();
        this.internalData.getVariableRealsList().buildWithCustomValues(variables, this.getItem(), uuid);
        SsomarDev.testMsg((String)("updateVariable 2 >> " + variableName), (boolean)true);
        VariableReal variableReal = this.internalData.getVariableRealsList().getVariableReal(variableName);
        SsomarDev.testMsg((String)("updateVariable 3 >> " + variableReal), (boolean)true);
        if (variableReal != null && variableReal.getConfig().getIsRefreshableClean().getValue().booleanValue()) {
            VariableFeature vC = variableReal.getConfig();
            String refreshTag = (String)vC.getRefreshTag().getValue().get();
            ItemMeta meta = this.getItem().getItemMeta();
            if (meta.hasLore()) {
                ArrayList<String> newLore = new ArrayList<String>();
                List lore = meta.getLore();
                for (String line : lore) {
                    int start;
                    int end;
                    while (line.contains(refreshTag) && (end = line.indexOf(refreshTag, (start = line.indexOf(refreshTag)) + refreshTag.length())) != -1) {
                        String toReplace = line.substring(start, end + refreshTag.length());
                        String extractPlaceholderTag = toReplace.replace(refreshTag, "").substring(toReplace.replace(refreshTag, "").length() - 2);
                        String placeholder = variableReal.getPlaceholderWithTag(extractPlaceholderTag);
                        line = line.replace(toReplace, placeholder);
                    }
                    line = variableReal.replaceVariablePlaceholder(line, true);
                    newLore.add(line);
                }
                meta.setLore(newLore);
                this.getItem().setItemMeta(meta);
            }
        }
        return (String)variables.get(variableNameUpper);
    }

    public int getUsage() {
        return this.internalData.getUsage();
    }

    public void updateUsage(int newUsage) {
        DynamicMeta dMeta;
        int limit = (Integer)this.config.getUsageFeatures().getUsageLimit().getValue().get();
        if (newUsage >= limit && limit != -1) {
            newUsage = limit;
        }
        if ((dMeta = new DynamicMeta(this.item.getItemMeta())).getMeta() == null) {
            ExecutableItems.plugin.getLogger().severe("DEBUG ERROR EI META NULL 4 NOT NORMAL, If you see this message join the discord and advert Ssomar pls !");
            return;
        }
        this.refreshUsage(dMeta, newUsage, true);
        this.item.setItemMeta(dMeta.getMeta());
    }

    public ApplyUsageModificationResult applyUsageModification(int usage, int usageModification, Player p, Event eSrc, int slot, SOption option) {
        boolean isAConsumptionOption;
        SsomarDev.testMsg((String)(ChatColor.GOLD + "[#i0001] applyUsageModification() is executed"), (boolean)true);
        ApplyUsageModificationResult result = new ApplyUsageModificationResult();
        ExecutableItem config = this.getConfig();
        ItemStack itemStack = this.getItem();
        ItemStack clone = itemStack.clone();
        int calculUsage = 0;
        boolean bl = isAConsumptionOption = option.equals((Object)Option.PLAYER_CONSUME) || option.equals((Object)Option.PLAYER_CONSUME_THE_EI);
        if (isAConsumptionOption) {
            PlayerItemConsumeEvent event;
            SsomarDev.testMsg((String)"[#i0002] is a consumption option", (boolean)true);
            if (eSrc instanceof PlayerItemConsumeEvent && !(event = (PlayerItemConsumeEvent)eSrc).getItem().equals((Object)itemStack)) {
                isAConsumptionOption = false;
            }
        }
        boolean isUsageOfOneTimeUseProjectile = option.equals((Object)Option.PLAYER_LAUNCH_PROJECTILE) && ToolsListMaterial.getInstance().getOneUsageMaterial().contains(this.getItem().getType());
        boolean isPlayerEquipOrUnEquip = option.equals((Object)Option.PLAYER_EQUIP_THE_EI) || option.equals((Object)Option.PLAYER_UNEQUIP_THE_EI);
        boolean isPotion = itemStack.getType().equals((Object)Material.POTION);
        boolean isBucket = itemStack.getType().toString().contains("BUCKET");
        boolean isCancelled = eSrc instanceof Cancellable && ((Cancellable)eSrc).isCancelled();
        SsomarDev.testMsg((String)"[#i0003] after the activator checks", (boolean)true);
        UsageFeatures usageFeatures = config.getUsageFeatures();
        int limit = (Integer)usageFeatures.getUsageLimit().getValue().get();
        calculUsage = usage + usageModification >= limit && limit != -1 ? limit : usage + usageModification;
        SsomarDev.testMsg((String)("[#i0004] > usage: " + usage + " > modif: " + usageModification + " > calculUsage: " + calculUsage + " > slot: " + slot), (boolean)true);
        if (usage == -1 || usageModification == 0) {
            SsomarDev.testMsg((String)"[#i0005] if usage is -1 or 0", (boolean)true);
            if (isAConsumptionOption || isUsageOfOneTimeUseProjectile) {
                if (!isCancelled) {
                    SsomarDev.testMsg((String)"CASE infinite / consumption / not cancelled", (boolean)true);
                    TriConsumer<Player, ItemStack, Integer> actionPostRefresh = (player, itemStack1, slot1) -> {
                        CommandsHandler.getInstance().addStopPickup(p, Integer.valueOf(2));
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SCore.plugin, () -> {
                            ItemStack clone1 = itemStack1.clone();
                            clone1.setAmount(clone1.getAmount());
                            p.getInventory().setItem(slot1.intValue(), clone1);
                        }, 1L);
                    };
                    result.setActionPostRefresh(actionPostRefresh);
                }
                p.updateInventory();
            }
            return result.setUsage(usage);
        }
        if (calculUsage <= 0) {
            SsomarDev.testMsg((String)"[#i0006] if (usage + usageModification) <= 0", (boolean)true);
            if (itemStack.getAmount() > 1) {
                if (isAConsumptionOption || isUsageOfOneTimeUseProjectile) {
                    if (isCancelled) {
                        SsomarDev.testMsg((String)("CASE  amount = 1+ / remove 1 / consumption / cancelled slot:" + slot), (boolean)true);
                        TriConsumer<Player, ItemStack, Integer> actionPostRefresh = (player, itemStack1, slot1) -> {
                            ItemStack clone1 = itemStack1.clone();
                            clone1.setAmount(clone1.getAmount() - 1);
                            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SCore.plugin, () -> p.getInventory().setItem(slot1.intValue(), clone1), 1L);
                        };
                        result.setActionPostRefresh(actionPostRefresh);
                    }
                } else {
                    itemStack.setAmount(itemStack.getAmount() - 1);
                }
                return result.setUsage(usage);
            }
            if (isAConsumptionOption || isUsageOfOneTimeUseProjectile) {
                if (isCancelled) {
                    SsomarDev.testMsg((String)"CASE  amount = 1 / remove / consumption / cancelled", (boolean)true);
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SCore.plugin, () -> {
                        if (isPotion) {
                            p.getInventory().setItem(slot, new ItemStack(Material.GLASS_BOTTLE));
                        } else if (isBucket) {
                            p.getInventory().setItem(slot, new ItemStack(Material.BUCKET));
                        } else {
                            p.getInventory().setItem(slot, new ItemStack(Material.AIR));
                        }
                    }, 1L);
                } else {
                    TriConsumer<Player, ItemStack, Integer> actionPostRefresh = (player, itemStack1, slot1) -> {
                        CommandsHandler.getInstance().addStopPickup(p, Integer.valueOf(2));
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SCore.plugin, () -> p.getInventory().setItem(slot1.intValue(), null), 1L);
                    };
                    result.setActionPostRefresh(actionPostRefresh);
                }
            } else {
                if (SCore.is1v11Less()) {
                    p.getInventory().removeItem(new ItemStack[]{itemStack});
                } else {
                    itemStack.setAmount(0);
                }
                SsomarDev.testMsg((String)("CASE  amount = 1 / remove / not consumption item qty" + itemStack.getAmount()), (boolean)true);
                RemoveItemInPlayerInventoryEvent event = new RemoveItemInPlayerInventoryEvent(p, clone, slot);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
            p.updateInventory();
            return result.setUsage(0);
        }
        SsomarDev.testMsg((String)"[#i0007] if (usage + usageModification) > 0", (boolean)true);
        if (itemStack.getAmount() > 1) {
            if (isAConsumptionOption || isUsageOfOneTimeUseProjectile) {
                SsomarDev.testMsg((String)"CASE  amount = 1+ / edit / consumption ", (boolean)true);
                int cont = 0;
                if (isPotion) {
                    for (ItemStack item : p.getInventory().getContents()) {
                        if (item == null || !item.getType().equals((Object)Material.GLASS_BOTTLE)) continue;
                        cont += item.getAmount();
                    }
                }
                if (isPotion) {
                    for (ItemStack item : p.getInventory().getContents()) {
                        if (item == null || !item.getType().equals((Object)Material.BUCKET)) continue;
                        cont += item.getAmount();
                    }
                }
                int objectCont = cont;
                ItemStack clone1 = itemStack.clone();
                clone1.setAmount(clone1.getAmount() - 1);
                ItemStack clone2 = itemStack.clone();
                clone2.setAmount(1);
                ExecutableItemObject newEi = new ExecutableItemObject(clone2);
                newEi.updateUsage(calculUsage);
                CommandsHandler.getInstance().addStopPickup(p, Integer.valueOf(2));
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SCore.plugin, () -> {
                    PlayerInventory inv = p.getInventory();
                    int glassBottleCont2 = 0;
                    if (isPotion) {
                        for (ItemStack item : p.getInventory().getContents()) {
                            if (item == null || !item.getType().equals((Object)Material.GLASS_BOTTLE)) continue;
                            glassBottleCont2 += item.getAmount();
                        }
                    }
                    if (glassBottleCont2 > objectCont) {
                        if (isPotion) {
                            inv.removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE)});
                        } else if (isBucket) {
                            inv.removeItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                        }
                    }
                    inv.setItem(slot, clone1);
                    HashMap items = inv.addItem(new ItemStack[]{newEi.getItem()});
                    for (ItemStack item : items.values()) {
                        p.getWorld().dropItem(p.getLocation(), item);
                    }
                }, 1L);
            } else {
                itemStack.setAmount(itemStack.getAmount() - 1);
                ItemStack newItemStack = itemStack.clone();
                newItemStack.setAmount(1);
                ExecutableItemObject newEI = new ExecutableItemObject(newItemStack);
                newEI.updateUsage(calculUsage);
                HashMap items = p.getInventory().addItem(new ItemStack[]{newEI.getItem()});
                for (ItemStack item : items.values()) {
                    p.getWorld().dropItem(p.getLocation(), item);
                }
            }
            p.updateInventory();
            return result.setUsage(usage);
        }
        if (isAConsumptionOption || isUsageOfOneTimeUseProjectile) {
            SsomarDev.testMsg((String)("CASE  amount = 1 / edit / consumption slot>> " + slot), (boolean)true);
            ExecutableItemObject newEi = new ExecutableItemObject(clone);
            newEi.updateUsage(calculUsage);
            CommandsHandler.getInstance().addStopPickup(p, Integer.valueOf(2));
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SCore.plugin, () -> p.getInventory().setItem(slot, newEi.getItem()), 1L);
        }
        if (!isPlayerEquipOrUnEquip) {
            p.updateInventory();
        }
        return result.setUsage(calculUsage);
    }

    public Map<String, String> getVariablesValues() {
        return this.internalData.getVariables();
    }

    public void updateVariable(VariableUpdateFeature update, DynamicMeta dMeta, @Nullable Player p, @Nullable StringPlaceholder sp) {
        for (VariableReal var : this.internalData.getVariableRealsList()) {
            SsomarDev.testMsg((String)("VariableReal found " + (String)var.getConfig().getVariableName().getValue().get() + " and we search for " + (String)update.getVariableName().getValue().get()), (boolean)true);
            if (!((String)var.getConfig().getVariableName().getValue().get()).equalsIgnoreCase((String)update.getVariableName().getValue().get())) continue;
            SsomarDev.testMsg((String)("VariableReal OKAY " + (String)var.getConfig().getVariableName().getValue().get()), (boolean)true);
            var.modifVariable(this.item, dMeta, update, p, sp);
            VariableReal variableReal = var;
            if (variableReal == null || !variableReal.getConfig().getIsRefreshableClean().getValue().booleanValue()) break;
            VariableFeature vC = variableReal.getConfig();
            String refreshTag = (String)vC.getRefreshTag().getValue().get();
            ItemMeta meta = dMeta.getMeta();
            if (!meta.hasLore()) break;
            ArrayList<String> newLore = new ArrayList<String>();
            List lore = meta.getLore();
            for (String line : lore) {
                int start;
                int end;
                while (line.contains(refreshTag) && (end = line.indexOf(refreshTag, (start = line.indexOf(refreshTag)) + refreshTag.length())) != -1) {
                    String toReplace = line.substring(start, end + refreshTag.length());
                    String extractPlaceholderTag = toReplace.replace(refreshTag, "").substring(toReplace.replace(refreshTag, "").length() - 2);
                    String placeholder = variableReal.getPlaceholderWithTag(extractPlaceholderTag);
                    SsomarDev.testMsg((String)("extractPlaceholderTag: " + extractPlaceholderTag.replace("\u00a7", "&") + " > placeholder: " + placeholder), (boolean)true);
                    SsomarDev.testMsg((String)("toReplace: " + toReplace + " > placeholder: " + placeholder), (boolean)true);
                    line = line.replace(toReplace, placeholder);
                }
                line = variableReal.replaceVariablePlaceholder(line, true);
                newLore.add(line);
            }
            meta.setLore(newLore);
            break;
        }
    }

    public void refreshUsage(DynamicMeta dMeta, boolean refreshThePlaceholders) {
        this.refreshUsage(dMeta, this.internalData.getUsage(), refreshThePlaceholders);
    }

    public void refreshUsage(DynamicMeta dMeta, int newUsage, boolean refreshThePlaceholders) {
        this.internalData.setUsage(newUsage);
        if (refreshThePlaceholders) {
            this.replaceUsagePlaceholders(dMeta);
            this.refreshName(dMeta);
            this.refreshLore(dMeta);
        }
        if (this.config.getDurability().getIsDurabilityBasedOnUsage().getValue().booleanValue()) {
            this.refreshDurability1v14plus(dMeta);
        }
        this.itemKeyWriterReader.removeKey((Plugin)ExecutableItems.plugin, this.item, dMeta, "EI-USAGE");
        this.itemKeyWriterReader.writeInteger((Plugin)SCore.plugin, this.item, dMeta, "usage", this.internalData.getUsage());
    }

    public void replaceUsagePlaceholders(DynamicMeta dMeta) {
        String variableNameUpper = "USAGE";
        if (this.getConfig().getUsageFeatures().getIsRefreshableClean().getValue().booleanValue()) {
            String refreshTag = VariableFeature.generateTag((String)variableNameUpper);
            ItemMeta meta = dMeta.getMeta();
            if (meta.hasLore()) {
                ArrayList<String> newLore = new ArrayList<String>();
                List lore = meta.getLore();
                for (String line : lore) {
                    int start;
                    int end;
                    while (line.contains(refreshTag) && (end = line.indexOf(refreshTag, (start = line.indexOf(refreshTag)) + refreshTag.length())) != -1) {
                        String toReplace = line.substring(start, end + refreshTag.length());
                        SsomarDev.testMsg((String)("toReplace: " + toReplace), (boolean)true);
                        String extractPlaceholderTag = toReplace.replace(refreshTag, "").substring(toReplace.replace(refreshTag, "").length() - 2);
                        String placeholder = this.getPlaceholderWithTag(extractPlaceholderTag);
                        line = line.replace(toReplace, placeholder);
                    }
                    newLore.add(line);
                }
                meta.setLore(newLore);
            }
        }
    }

    public String getPlaceholderWithTag(String s) {
        Map<String, String> tags = this.getTranscoPlaceholders();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            if (!s.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return "";
    }

    public String getPlaceholderTag(String placeholder) {
        Map<String, String> tags = this.getTranscoPlaceholders();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            if (!entry.getValue().equals(placeholder)) continue;
            return entry.getKey();
        }
        return "";
    }

    public Map<String, String> getTranscoPlaceholders() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("\u00a7\u5634", "%usage%");
        tags.put("\u00a7\u7389", "%usage_int%");
        tags.put("\u00a7\u9547", "%usage_roman%");
        tags.put("\u00a7\u7a33", "%usage_limit%");
        tags.put("\u00a7\u5e8a", "%usage_bar");
        return tags;
    }

    public void cleanUsageParticleInLore(List<String> lore) {
        String[] spliter;
        if (lore != null && lore.size() > 0 && (spliter = lore.get(lore.size() - 1).split(MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.USE))).length > 1) {
            lore.remove(lore.size() - 1);
        }
    }

    public void addUsageParticleInLore(List<String> lore) {
        if (!this.config.getHiders().getHideUsage().getValue().booleanValue() && this.internalData.getUsage() != -1 && this.internalData.getUsage() != 0) {
            lore.add(MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.USE) + this.internalData.getUsage());
        }
    }

    public void refreshAttributes(DynamicMeta dMeta) {
        ItemMeta meta = dMeta.getMeta();
        if (!SCore.is1v12Less()) {
            StringPlaceholder sp = new StringPlaceholder();
            sp.setVariables((List)this.internalData.getVariableRealsList());
            LinkedHashMultimap reset = LinkedHashMultimap.create();
            meta.setAttributeModifiers((Multimap)reset);
            LinkedHashMultimap result = LinkedHashMultimap.create();
            for (EquipmentSlot[] att : this.config.getAttributes().getAttributes().values()) {
                SsomarDev.testMsg((String)("add Attribute: " + att.getAttribute().getValue().get()), (boolean)true);
                UUID ownerUUID = this.internalData.getOwnerUUID();
                result.put((Object)((Attribute)att.getAttribute().getValue().get()), (Object)att.getAttributeModifier(ownerUUID, sp));
            }
            if (!this.config.getAttributes().getIgnoreKeepDefaultAttributesFeature().getValue().booleanValue()) {
                Material material;
                if (SCore.is1v19Plus() && this.config.getAttributes().getKeepDefaultAttributes().getValue().booleanValue() && this.item.getType().isItem() && (!result.isEmpty() || SCore.is1v21Plus())) {
                    material = this.item.getType();
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        SsomarDev.testMsg((String)("add attributes for EquipmentSlot: " + equipmentSlot), (boolean)true);
                        result.putAll(material.getDefaultAttributeModifiers(equipmentSlot));
                    }
                } else if (SCore.is1v19Plus() && !this.config.getAttributes().getKeepDefaultAttributes().getValue().booleanValue() && this.item.getType().isItem() && !SCore.is1v21Plus()) {
                    material = this.item.getType();
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        SsomarDev.testMsg((String)("add attributes for EquipmentSlot: " + equipmentSlot), (boolean)true);
                        Multimap invert = material.getDefaultAttributeModifiers(equipmentSlot);
                        for (Attribute col : invert.keySet()) {
                            for (AttributeModifier att : invert.get((Object)col)) {
                                result.put((Object)col, (Object)new AttributeModifier(att.getUniqueId(), att.getName(), 0.0, att.getOperation(), att.getSlot()));
                            }
                        }
                    }
                }
            }
            if (SCore.is1v13()) {
                for (Attribute col : result.asMap().keySet()) {
                    for (AttributeModifier att : result.get((Object)col)) {
                        meta.addAttributeModifier(col, att);
                    }
                }
            } else {
                meta.setAttributeModifiers((Multimap)result);
            }
        }
    }

    public void refreshUseCooldown(DynamicMeta dMeta) {
        ItemMeta meta = dMeta.getMeta();
        if (SCore.is1v21v2Plus()) {
            UseCooldownFeatures useCooldown = this.config.getUseCooldown();
            useCooldown.applyOnItemMeta(meta);
        }
    }

    public void refreshGlider(DynamicMeta dMeta) {
        ItemMeta meta = dMeta.getMeta();
        if (SCore.is1v21v2Plus()) {
            meta.setGlider(this.config.getGlider().getValue().booleanValue());
        }
    }

    public void refreshModel(DynamicMeta dMeta) {
        this.refreshModel(dMeta, true);
    }

    public void refreshModel(DynamicMeta dMeta, boolean updateTooltipModel) {
        ItemMeta meta = dMeta.getMeta();
        if (SCore.is1v21v2Plus()) {
            String itemModelStr = this.config.getItemModel().getValue().orElse("");
            if (!itemModelStr.isEmpty()) {
                String itemModel = this.refreshVariables_Owner_Usage_PlaceholdersInString(itemModelStr, itemModelStr);
                itemModel = StringConverter.decoloredString((String)itemModel);
                meta.setItemModel(NamespacedKey.fromString((String)itemModel));
            }
            String tooltipStyleStr = this.config.getTooltipStyle().getValue().orElse("");
            if (updateTooltipModel && !tooltipStyleStr.isEmpty()) {
                String tooltipStyle = this.refreshVariables_Owner_Usage_PlaceholdersInString(tooltipStyleStr, tooltipStyleStr);
                tooltipStyle = StringConverter.decoloredString((String)tooltipStyle);
                meta.setTooltipStyle(NamespacedKey.fromString((String)tooltipStyle));
            }
        }
    }

    public void refreshEnchantmentsAndGlow(DynamicMeta dMeta) {
        ItemMeta meta = dMeta.getMeta();
        Map toClear = meta.getEnchants();
        for (Enchantment e : toClear.keySet()) {
            meta.removeEnchant(e);
        }
        meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        boolean hasOne = false;
        for (EnchantmentWithLevelFeature enchant : this.config.getEnchantments().getEnchantments().values()) {
            hasOne = true;
            StringPlaceholder sp = new StringPlaceholder();
            sp.setVariables((List)this.internalData.getVariableRealsList());
            Optional optionalInteger = enchant.getLevel().getValue(this.internalData.getOwnerUUID(), sp);
            if (!optionalInteger.isPresent()) continue;
            meta.addEnchant((Enchantment)enchant.getEnchantment().getValue().get(), ((Integer)optionalInteger.get()).intValue(), true);
        }
        if (this.config.getGlow().getGlow().getValue().booleanValue() && !hasOne) {
            if (SCore.is1v20v5Plus()) {
                meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            } else {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                meta.addEnchant(Enchantment.getByName((String)"PROTECTION_FALL"), 6, true);
            }
        }
        if (SCore.is1v20v5Plus() && this.config.getGlow().getDisableEnchantGlide().getValue().booleanValue()) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(false));
        }
    }

    public void refreshDurability1v13less() {
        DurabilityFeatures durabilityF = this.config.getDurability();
        if (durabilityF.getDurability().getValue().isPresent() && (Integer)durabilityF.getDurability().getValue().get() > 0 && this.config.getHeadFeatures().getHeadOr(Material.STONE).getType().equals((Object)Material.STONE)) {
            if (SCore.is1v12Less() && this.item.getType().equals((Object)FixedMaterial.getMaterial(Arrays.asList("INK_SACK")))) {
                int durability = (Integer)durabilityF.getDurability().getValue().get();
                this.item.setDurability((short)durability);
            } else {
                int decrease = this.item.getType().getMaxDurability() - (Integer)durabilityF.getDurability().getValue().get();
                this.item.setDurability((short)decrease);
            }
        }
    }

    public void refreshDurability1v14plus(DynamicMeta dMeta) {
        DurabilityFeatures durabilityF = this.config.getDurability();
        ItemMeta meta = dMeta.getMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            if (durabilityF.getIsDurabilityBasedOnUsage().getValue().booleanValue()) {
                int usageLimit = (Integer)this.config.getUsageFeatures().getUsageLimit().getValue().get();
                int usage = this.internalData.getUsage();
                int maxDurability = usageLimit;
                if (maxDurability <= 0) {
                    maxDurability = usage;
                }
                if (maxDurability <= 0) {
                    return;
                }
                damageable.setMaxDamage(Integer.valueOf(maxDurability));
                if (usage > 0 && usageLimit > 0) {
                    int decrease = maxDurability - usage;
                    damageable.setDamage(decrease);
                }
            } else {
                Optional durabilityValue;
                StringPlaceholder sp = this.getStringPlaceholderWithVariables();
                Optional maxDurabilityValue = durabilityF.getMaxDurability().getValue(this.internalData.getOwnerUUID(), sp);
                if (SCore.is1v20v5Plus() && maxDurabilityValue.isPresent() && (Integer)maxDurabilityValue.get() > 0) {
                    damageable.setMaxDamage((Integer)maxDurabilityValue.get());
                }
                if ((durabilityValue = durabilityF.getDurability().getValue(this.internalData.getOwnerUUID(), sp)).isPresent() && (Integer)durabilityValue.get() > 0) {
                    int decrease;
                    int maxDamage = this.item.getType().getMaxDurability();
                    if (SCore.is1v20v5Plus() && damageable.hasMaxDamage()) {
                        maxDamage = damageable.getMaxDamage();
                    }
                    if ((decrease = maxDamage - (Integer)durabilityValue.get()) < 0) {
                        decrease = 0;
                    }
                    damageable.setDamage(decrease);
                }
            }
        }
    }

    public void refreshUnbreakable(DynamicMeta dMeta) {
        if (!SCore.is1v11Less()) {
            dMeta.getMeta().setUnbreakable(this.config.getUnbreakable().getValue().booleanValue());
        } else {
            try {
                Class<?> act = Class.forName("org.bukkit.inventory.meta.ItemMeta");
                Object obj = act.getMethod("spigot", new Class[0]).invoke((Object)dMeta.getMeta(), new Object[0]);
                Class<?> spigot = obj.getClass();
                Method m = spigot.getMethod("setUnbreakable", Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(obj, this.config.getUnbreakable().getValue());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public void addExecutableItemTag(DynamicMeta dMeta) {
        this.itemKeyWriterReader.writeString((Plugin)ExecutableItems.plugin, this.item, dMeta, "EI-ID", this.config.getId());
    }

    public void refreshOwner(DynamicMeta dMeta) {
        UUID internalDataOwnerUUID;
        Optional oldOwner = this.itemKeyWriterReader.readString((Plugin)ExecutableItems.plugin, this.item, dMeta, "EI-OWNER");
        if (oldOwner.isPresent()) {
            this.itemKeyWriterReader.removeKey((Plugin)ExecutableItems.plugin, this.item, dMeta, "EI-OWNER");
            try {
                UUID oldOwnerUUID = UUID.fromString((String)oldOwner.get());
                this.internalData.setOwnerUUID(oldOwnerUUID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((this.config.getStoreItemInfo().getValue().booleanValue() || this.config.getCanBeUsedOnlyByTheOwnerFeatures().getCanBeUsedOnlyByTheOwner().getValue().booleanValue()) && (internalDataOwnerUUID = this.internalData.getOwnerUUID()) != null) {
            this.itemKeyWriterReader.writeString((Plugin)SCore.plugin, this.item, dMeta, "ownerUUID", internalDataOwnerUUID.toString());
        }
    }

    public void refreshExtraInfos(DynamicMeta dMeta) {
        if (!SCore.is1v13Less()) {
            ItemMeta meta = dMeta.getMeta();
            for (String tag : this.config.getTags().keySet()) {
                NamespacedKey key = new NamespacedKey((Plugin)ExecutableItems.getPluginSt(), tag);
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)this.config.getTags().get(tag));
            }
        }
    }

    public void refreshCustomModelData(DynamicMeta dMeta) {
        if (!SCore.is1v13Less() && this.config.getCustomModelData().getValue().isPresent()) {
            ItemMeta meta = dMeta.getMeta();
            if (SCore.is1v21v4Plus()) {
                String[] split = ((String)this.config.getCustomModelData().getValue().get()).split(";");
                ArrayList<Float> floats = new ArrayList<Float>();
                ArrayList<Boolean> booleans = new ArrayList<Boolean>();
                ArrayList<String> strings = new ArrayList<String>();
                for (String s : split) {
                    Optional f = NTools.getFloat((String)s);
                    if (f.isPresent()) {
                        floats.add((Float)f.get());
                        continue;
                    }
                    if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
                        booleans.add(Boolean.parseBoolean(s));
                        continue;
                    }
                    strings.add(s);
                }
                CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
                customModelDataComponent.setStrings(strings);
                customModelDataComponent.setFloats(floats);
                customModelDataComponent.setFlags(booleans);
                meta.setCustomModelDataComponent(customModelDataComponent);
            } else {
                Optional integerOptional = NTools.getInteger((String)((String)this.config.getCustomModelData().getValue().get()));
                if (integerOptional.isPresent()) {
                    meta.setCustomModelData((Integer)integerOptional.get());
                }
            }
        }
    }

    public void refreshItemRarity(DynamicMeta dMeta) {
        if (SCore.is1v20v5Plus()) {
            ItemMeta meta = dMeta.getMeta();
            meta.setRarity(this.config.getItemRarity().getItemRarityValue());
        }
    }

    public void refreshFireResistent(DynamicMeta dMeta) {
        if (this.config.getRestrictions().is(RestrictionEnum.CANCEL_ITEM_BURN)) {
            ItemMeta meta = dMeta.getMeta();
            if (SCore.is1v21v2Plus()) {
                try {
                    if (this.config.getRestrictions().is(RestrictionEnum.CANCEL_ITEM_BURN)) {
                        meta.setDamageResistant(DamageTypeTags.IS_FIRE);
                    }
                }
                catch (Error | Exception throwable) {}
            } else if (SCore.is1v20v5Plus()) {
                meta.setFireResistant(this.config.getRestrictions().is(RestrictionEnum.CANCEL_ITEM_BURN));
            }
        }
    }

    public void refreshPotionSettings() {
        PotionSettingsFeature potionS = this.config.getPotionSettings();
        this.item = potionS.addTo(potionS.clear(this.item));
    }

    public void refreshArmorSetings(DynamicMeta dMeta) {
        ItemMeta meta = dMeta.getMeta();
        Material material = this.item.getType();
        if (this.config.getArmorColor().getValue(this.internalData.getOwnerUUID(), null).isPresent() && (material.equals((Object)Material.LEATHER_BOOTS) || material.equals((Object)Material.LEATHER_CHESTPLATE) || material.equals((Object)Material.LEATHER_LEGGINGS) || material.equals((Object)Material.LEATHER_HELMET) || !SCore.is1v13Less() && material.equals((Object)Material.LEATHER_HORSE_ARMOR))) {
            LeatherArmorMeta aMeta = (LeatherArmorMeta)meta;
            aMeta.setColor(Color.fromRGB((int)((Integer)this.config.getArmorColor().getValue(this.internalData.getOwnerUUID(), null).get())));
        }
    }

    public void refreshNbtTags() {
        try {
            this.item = this.config.getNbt().writeNBTTags(this.item);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    public Optional<String> reloadOwner(@Nullable OfflinePlayer p) {
        DynamicMeta dMeta = new DynamicMeta(this.item.getItemMeta());
        if (p == null) {
            this.internalData.setOwnerUUID(null);
            this.itemKeyWriterReader.removeKey((Plugin)ExecutableItems.plugin, this.item, dMeta, "EI-OWNER");
            this.itemKeyWriterReader.removeKey((Plugin)SCore.plugin, this.item, dMeta, "ownerUUID");
            this.refreshLore(dMeta, true);
            this.item.setItemMeta(dMeta.getMeta());
            return Optional.empty();
        }
        if (this.internalData.getOwnerUUID() != null) {
            return Optional.of("the item already has an owner, remove it first /ei unowned");
        }
        if (!this.config.getStoreItemInfo().getValue().booleanValue()) {
            return Optional.of("the item doesn't have the feature StoreItemInfo enabled");
        }
        this.internalData.setOwnerUUID(p.getUniqueId());
        this.refreshOwner(dMeta);
        this.refreshLore(dMeta, true);
        this.item.setItemMeta(dMeta.getMeta());
        return Optional.empty();
    }

    public boolean isValid() {
        return this.valid;
    }

    public ExecutableItem getConfig() {
        return this.config;
    }

    public InternalData getInternalData() {
        return this.internalData;
    }

    public ItemKeyWriterReader getItemKeyWriterReader() {
        return this.itemKeyWriterReader;
    }

    public boolean isExecutableItemInfosLoaded() {
        return this.executableItemInfosLoaded;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public DynamicMeta getDMetaAfterLoading() {
        return this.dMetaAfterLoading;
    }

    public class ApplyUsageModificationResult {
        private int usage;
        private TriConsumer<Player, ItemStack, Integer> actionPostRefresh;

        public ApplyUsageModificationResult setUsage(int usage) {
            this.usage = usage;
            return this;
        }

        public ApplyUsageModificationResult setActionPostRefresh(TriConsumer<Player, ItemStack, Integer> actionPostRefresh) {
            this.actionPostRefresh = actionPostRefresh;
            return this;
        }

        public int getUsage() {
            return this.usage;
        }

        public TriConsumer<Player, ItemStack, Integer> getActionPostRefresh() {
            return this.actionPostRefresh;
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);

        default public TriConsumer<T, U, V> andThen(TriConsumer<? super T, ? super U, ? super V> after) {
            return (t, u, v) -> {
                this.accept(t, u, v);
                after.accept(t, u, v);
            };
        }
    }
}

