/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.score.SCore;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerDeath
implements Listener {
    private static PlayerDeath instance;
    private Map<String, ItemStack[]> savedItems = new HashMap<String, ItemStack[]>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeathEvent(PlayerDeathEvent e) {
        boolean gameRuleKeepInv = false;
        if (!SCore.is1v11Less()) {
            gameRuleKeepInv = Boolean.TRUE.equals(e.getEntity().getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY));
        }
        if (!e.getKeepInventory() && !gameRuleKeepInv) {
            Player p = e.getEntity();
            ExecutableItemsManager iM = ExecutableItemsManager.getInstance();
            ItemStack[] inv = (ItemStack[])p.getInventory().getContents().clone();
            boolean oneIsSave = false;
            for (int size = 0; size < p.getInventory().getContents().length; ++size) {
                ItemStack item = p.getInventory().getItem(size);
                if (item == null) {
                    inv[size] = null;
                    continue;
                }
                ExecutableItemObject ei = new ExecutableItemObject(item);
                ExecutableItem infoItem = null;
                if (ei.isValid()) {
                    infoItem = ei.getConfig();
                }
                if (infoItem == null) {
                    inv[size] = null;
                    continue;
                }
                if (infoItem.getKeepItemOnDeath().getValue().booleanValue()) {
                    e.getDrops().remove(item);
                    oneIsSave = true;
                    continue;
                }
                inv[size] = null;
            }
            if (oneIsSave) {
                this.savedItems.put(p.getName(), inv);
            }
        }
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (this.savedItems.containsKey(p.getName())) {
            p.getInventory().setContents(this.savedItems.get(p.getName()));
            this.savedItems.remove(p.getName());
        }
    }

    public void serverStop() {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.savedItems.containsKey(p.getName())) continue;
            p.getInventory().setContents(this.savedItems.get(p.getName()));
            this.savedItems.remove(p.getName());
        }
    }

    @EventHandler
    public void onPlayerRespawnEvent(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        if (this.savedItems.containsKey(p.getName())) {
            p.getInventory().setContents(this.savedItems.get(p.getName()));
            this.savedItems.remove(p.getName());
        }
    }

    public static PlayerDeath getInstance() {
        if (instance == null) {
            instance = new PlayerDeath();
        }
        return instance;
    }
}

