/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.projectiles;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ProjectileLaunchEvent
implements Listener {
    private static final Boolean DEBUG = false;
    private List<Material> validProjectiles = new ArrayList<Material>();

    public ProjectileLaunchEvent() {
        this.validProjectiles.add(Material.EGG);
        this.validProjectiles.add(Material.BOW);
        this.validProjectiles.add(Material.ENDER_PEARL);
        this.validProjectiles.add(Material.FISHING_ROD);
        if (SCore.is1v12Less()) {
            this.validProjectiles.add(Material.valueOf((String)"EXP_BOTTLE"));
            this.validProjectiles.add(Material.valueOf((String)"SNOW_BALL"));
            this.validProjectiles.add(Material.valueOf((String)"FIREWORK"));
        } else {
            this.validProjectiles.add(Material.FIREWORK_ROCKET);
            this.validProjectiles.add(Material.EXPERIENCE_BOTTLE);
            this.validProjectiles.add(Material.TRIDENT);
            this.validProjectiles.add(Material.SNOWBALL);
            if (!SCore.is1v13Less()) {
                this.validProjectiles.add(Material.CROSSBOW);
            }
        }
        if (!SCore.is1v11Less()) {
            this.validProjectiles.add(Material.SPLASH_POTION);
        }
    }

    @EventHandler
    public void onProjectileLaunch(EntityShootBowEvent e) {
        SsomarDev.testMsg((String)"LAUNCH ARROW", (boolean)DEBUG);
        if (e.getEntity() instanceof Player) {
            if (!GeneralConfig.getInstance().isDisableCustomMetadataOnEntities()) {
                e.getProjectile().setMetadata("bowForce", (MetadataValue)new FixedMetadataValue((Plugin)ExecutableItems.plugin, (Object)Float.valueOf(e.getForce())));
            }
            SsomarDev.testMsg((String)"LAUNCH ARROW PLAYER", (boolean)DEBUG);
            Player p = (Player)e.getEntity();
            Entity projectile = e.getProjectile();
            ExecutableItemObject ei = null;
            if (SCore.is1v16Plus()) {
                ItemStack item = e.getConsumable();
                ei = new ExecutableItemObject(item);
                if (!ei.isValid()) {
                    return;
                }
                ei.loadExecutableItemInfos();
                ei.setItem(null);
            }
            SsomarDev.testMsg((String)"LAUNCH ARROW PLAYER VALID", (boolean)DEBUG);
            ProjectileInfo pInfo = new ProjectileInfo(p, projectile.getUniqueId(), Optional.ofNullable(ei), p.getInventory().getHeldItemSlot(), System.currentTimeMillis());
            ProjectilesHandler.getInstance().addProjectileInfo(pInfo);
            SsomarDev.testMsg((String)("ProjectileLaunchEvent + Projectile registered : " + pInfo.toString()), (boolean)DEBUG);
        }
    }

    @EventHandler
    public void onProjectileLaunchEvent(org.bukkit.event.entity.ProjectileLaunchEvent e) {
        if (e.getEntity().getShooter() instanceof Player) {
            ExecutableItemObject eiTest;
            ItemStack itemSOffHand;
            ItemStack itemSMainHand;
            SsomarDev.testMsg((String)"ProjectileLaunchEvent + Projectile launched by a player", (boolean)DEBUG);
            final Player p = (Player)e.getEntity().getShooter();
            List meta = p.getMetadata("cancelProjectileEvent");
            for (MetadataValue mV : meta) {
                if (mV.asInt() != 7772) continue;
                p.removeMetadata("cancelProjectileEvent", (Plugin)SCore.plugin);
                return;
            }
            ExecutableItemObject ei = null;
            Projectile projectile = e.getEntity();
            ItemStack item = null;
            if (SCore.is1v11Less()) {
                itemSMainHand = p.getInventory().getItemInHand();
                itemSOffHand = new ItemStack(Material.BEDROCK);
            } else {
                itemSMainHand = p.getInventory().getItemInMainHand();
                itemSOffHand = p.getInventory().getItemInOffHand();
            }
            int slot = 0;
            if (this.validProjectiles.contains(itemSMainHand.getType()) && this.validProjectiles.contains(itemSOffHand.getType())) {
                eiTest = new ExecutableItemObject(itemSMainHand);
                if (eiTest.isValid()) {
                    ei = eiTest;
                    item = itemSMainHand;
                } else {
                    ei = null;
                }
                slot = p.getInventory().getHeldItemSlot();
            } else if (this.validProjectiles.contains(itemSMainHand.getType())) {
                eiTest = new ExecutableItemObject(itemSMainHand);
                if (eiTest.isValid()) {
                    ei = eiTest;
                    item = itemSMainHand;
                } else {
                    ei = null;
                }
                slot = p.getInventory().getHeldItemSlot();
            } else if (this.validProjectiles.contains(itemSOffHand.getType())) {
                eiTest = new ExecutableItemObject(itemSOffHand);
                if (eiTest.isValid()) {
                    ei = eiTest;
                    item = itemSOffHand;
                } else {
                    ei = null;
                }
                slot = 40;
            }
            if (ei != null) {
                SsomarDev.testMsg((String)"ProjectileLaunchEvent + ExecutableItem found", (boolean)DEBUG);
                ei.loadExecutableItemInfos();
                SsomarDev.testMsg((String)("ProjectileLaunchEvent + ExecutableItem found + Usage : " + ei.getUsage()), (boolean)DEBUG);
                if (ei.getUsage() > 1 || ei.getUsage() == -1) {
                    if (!SCore.is1v12Less() && item.getType().equals((Object)Material.TRIDENT)) {
                        SsomarDev.testMsg((String)"ProjectileLaunchEvent + TRIDENT NO COPY", (boolean)DEBUG);
                    } else if (item.getType().equals((Object)Material.BOW)) {
                        SsomarDev.testMsg((String)"ProjectileLaunchEvent + BOW NO COPY", (boolean)DEBUG);
                    } else if (SCore.is1v16Plus() && item.getType().equals((Object)Material.CROSSBOW)) {
                        SsomarDev.testMsg((String)"ProjectileLaunchEvent + CROSSBOW NO COPY", (boolean)DEBUG);
                    } else {
                        final ItemStack itemClone = item.clone();
                        final int slotClone = slot;
                        ei.setItem(itemClone);
                        SsomarDev.testMsg((String)("PLaunch qty: " + itemClone.getAmount()), (boolean)DEBUG);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (!p.isDead()) {
                                    p.getInventory().setItem(slotClone, itemClone);
                                }
                            }
                        };
                        SCore.schedulerHook.runTask(runnable, 0L);
                    }
                }
            }
            ProjectileInfo pInfo = new ProjectileInfo(p, projectile.getUniqueId(), Optional.ofNullable(ei), slot, System.currentTimeMillis());
            ProjectilesHandler.getInstance().addProjectileInfo(pInfo);
            SsomarDev.testMsg((String)("ProjectileLaunchEvent + Projectile registered : " + pInfo.toString()), (boolean)DEBUG);
            EventInfo eInfo = new EventInfo((Event)e);
            eInfo.setPlayer(Optional.of(p));
            eInfo.setProjectile(Optional.of(projectile));
            if (projectile.hasMetadata("bowForce")) {
                eInfo.setBowForce(Optional.of(Float.valueOf(((MetadataValue)projectile.getMetadata("bowForce").get(0)).asFloat())));
            }
            eInfo.setVelocity(Optional.of(projectile.getVelocity()));
            eInfo.setTargetEntity(Optional.of(projectile));
            eInfo.setOption((SOption)Option.PLAYER_LAUNCH_PROJECTILE);
            EventsManager.getInstance().activeOption(eInfo);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntitySpawnEvent(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        entity.removeMetadata("bowForce", (Plugin)ExecutableItems.plugin);
    }
}

