/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.commands;

import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.custom.variables.base.variable.VariableFeature;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.emums.VariableUpdateType;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class VariableModificationCommand {
    private String command;
    private Player player;
    private VariableUpdateType type;
    private int slot;
    private String variableName;
    private String value;
    private ItemStack item;
    private ExecutableItemObject eiObject;
    private int usageModification;
    private boolean valid;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VariableModificationCommand(String command, String[] args, @Nullable Player player) {
        this.command = command;
        String commandTemplate = "ei console-modification {set/modification} {usage/variable} ....";
        if (command.equals("modification")) {
            commandTemplate = "ei modification {set/modification} {usage/variable} ....";
        }
        try {
            String slotStr;
            int variableIndex;
            int slotIndex;
            int valueIndex;
            String what;
            block27: {
                String typeStr;
                block26: {
                    typeStr = args[0];
                    if (typeStr.equalsIgnoreCase("set")) {
                        this.type = VariableUpdateType.SET;
                    } else {
                        if (!typeStr.equalsIgnoreCase("modification")) {
                            this.sendError(command, "&cThe update type is not valid (set or modification)! Try again. &8Command: &7" + commandTemplate);
                            this.valid = false;
                            return;
                        }
                        this.type = VariableUpdateType.MODIFICATION;
                    }
                    what = args[1];
                    valueIndex = 0;
                    slotIndex = 3;
                    variableIndex = 0;
                    if (what.equalsIgnoreCase("variable")) {
                        variableIndex = 4;
                        valueIndex = 5;
                    } else {
                        if (!what.equalsIgnoreCase("usage")) {
                            this.sendError(command, "&cWhat you want update is not specified correctly (variable or usage)! Try again. &8Command: &7" + commandTemplate);
                            this.valid = false;
                            return;
                        }
                        this.variableName = "usage";
                        valueIndex = 4;
                    }
                    if (!command.equals("console-modification")) break block26;
                    if (what.equalsIgnoreCase("usage")) {
                        commandTemplate = "/ei console-modification " + typeStr + " usage {player} {slot} {value}";
                        break block27;
                    } else if (what.equalsIgnoreCase("variable")) {
                        commandTemplate = "/ei console-modification " + typeStr + " variable {player} {slot} {variableName} {value}";
                    }
                    break block27;
                }
                if (what.equalsIgnoreCase("usage")) {
                    commandTemplate = "/ei modification " + typeStr + " usage {slot} {value}";
                } else if (what.equalsIgnoreCase("variable")) {
                    commandTemplate = "/ei modification " + typeStr + " variable {slot} {variableName} {value}";
                }
            }
            if (command.equals("console-modification")) {
                player = Bukkit.getServer().getPlayer(args[2]);
            }
            if (player == null) {
                this.sendError(command, "&cThe player is not online ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            this.player = player;
            if (command.equals("modification")) {
                --valueIndex;
                --slotIndex;
                --variableIndex;
            }
            if (what.equalsIgnoreCase("variable")) {
                this.variableName = args[variableIndex];
            }
            if (!NTools.isNumber((String)(slotStr = args[slotIndex]))) {
                this.sendError(command, "&cThe slot " + slotStr + " is not a number ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            this.slot = Integer.parseInt(slotStr);
            if (what.equalsIgnoreCase("usage")) {
                String usageStr = args[valueIndex];
                if (!NTools.isNumber((String)usageStr)) {
                    this.sendError(command, "&cThe usage " + usageStr + " is not a number ! Try again. &8Command: &7" + commandTemplate);
                    this.valid = false;
                    return;
                }
                this.usageModification = Integer.parseInt(usageStr);
            } else {
                if (args.length <= valueIndex) {
                    this.sendError(command, "&cThe value is not specified ! Try again. &8Command: &7" + commandTemplate);
                    this.valid = false;
                    return;
                }
                this.value = args[valueIndex];
                for (int i = valueIndex + 1; i < args.length; ++i) {
                    this.value = this.value + " " + args[i];
                }
            }
            PlayerInventory inv = player.getInventory();
            this.item = null;
            this.item = this.slot == -1 ? inv.getItem(inv.getHeldItemSlot()) : inv.getItem(this.slot);
            this.eiObject = new ExecutableItemObject(this.item);
            if (!this.eiObject.isValid()) {
                this.sendError(command, "&cThe item in the slot " + this.slot + " is not an executable item ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            this.eiObject.loadExecutableItemInfos();
        }
        catch (Exception e) {
            this.sendError(command, "&cAn error occurred while executing the command ! (Probably insufficient arguments) Try again. &8Command: &7" + commandTemplate);
            this.valid = false;
            return;
        }
        this.valid = true;
    }

    public void sendError(String command, String message) {
        if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.muteModification.name())) {
            return;
        }
        if (command.equalsIgnoreCase("modification") && this.player != null) {
            SendMessage.sendMessageNoPlch((Player)this.player, (String)message);
        } else if (command.equalsIgnoreCase("console-modification")) {
            Bukkit.getServer().getLogger().severe(StringConverter.decoloredString((String)message));
        }
    }

    public void sendInfo(String command, String message) {
        if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.muteModification.name())) {
            return;
        }
        if (command.equalsIgnoreCase("modification") && this.player != null) {
            SendMessage.sendMessageNoPlch((Player)this.player, (String)message);
        } else if (command.equalsIgnoreCase("console-modification")) {
            Utils.sendConsoleMsg((String)message);
        }
    }

    public void run() {
        if (!this.valid) {
            return;
        }
        if (this.variableName.equals("usage")) {
            int usageLimit = (Integer)this.eiObject.getConfig().getUsageFeatures().getUsageLimit().getValue().get();
            if (this.usageModification > usageLimit && usageLimit != -1) {
                this.usageModification = usageLimit;
            }
            if (this.type.equals((Object)VariableUpdateType.SET)) {
                this.eiObject.updateUsage(this.usageModification + 1);
                ExecutableItemObject.ApplyUsageModificationResult result = this.eiObject.applyUsageModification(this.eiObject.getUsage(), -1, this.player, null, this.slot, Option.PLAYER_ALL_CLICK);
                int newUsage = result.getUsage();
                this.eiObject.updateUsage(newUsage);
                ExecutableItemObject.TriConsumer<Player, ItemStack, Integer> actionpostRefresh = result.getActionPostRefresh();
                if (actionpostRefresh != null) {
                    actionpostRefresh.accept(this.player, this.eiObject.getItem(), this.slot);
                }
                this.sendInfo(this.command, "&bExecutableItems &aThe usage of the item in the slot &e" + this.slot + " &ahas been set to &e" + this.usageModification + " &a!");
            } else if (this.eiObject.getUsage() != -1) {
                ExecutableItemObject.ApplyUsageModificationResult result = this.eiObject.applyUsageModification(this.eiObject.getUsage(), this.usageModification, this.player, null, this.slot, Option.PLAYER_ALL_CLICK);
                int newUsage = result.getUsage();
                this.eiObject.updateUsage(newUsage);
                ExecutableItemObject.TriConsumer<Player, ItemStack, Integer> actionpostRefresh = result.getActionPostRefresh();
                if (actionpostRefresh != null) {
                    actionpostRefresh.accept(this.player, this.eiObject.getItem(), this.slot);
                }
                SsomarDev.testMsg((String)("newUsage: " + newUsage), (boolean)true);
                this.sendInfo(this.command, "&bExecutableItems &aThe usage of the item in the slot &e" + this.slot + " &ahas been updated to &e" + this.usageModification + " &a!");
            } else {
                this.sendInfo(this.command, "&bExecutableItems &aThe usage of the item in the slot &e" + this.slot + " &ahas not been updated because of infinite usage &a!");
            }
        } else {
            String newValue = this.eiObject.updateVariable(this.variableName, this.value, this.type);
            ExecutableItem Object2 = this.eiObject.getConfig();
            VariableFeature var = Object2.getVariables().getVariable(this.variableName);
            if (var != null && !var.getIsRefreshableClean().getValue().booleanValue()) {
                ArrayList<ResetSetting> resetSettings = new ArrayList<ResetSetting>();
                boolean containsVar = false;
                for (String lore : Object2.getLore().getValues()) {
                    if (!lore.contains("%var_" + this.variableName)) continue;
                    containsVar = true;
                    break;
                }
                if (containsVar) {
                    resetSettings.add(ResetSetting.LORE);
                }
                if (Object2.getDisplayName().getValue().isPresent() && ((String)Object2.getDisplayName().getValue().get()).contains("%var_" + this.variableName + "%")) {
                    resetSettings.add(ResetSetting.NAME);
                }
                if (!resetSettings.isEmpty()) {
                    this.eiObject.refresh(resetSettings);
                }
            }
            this.sendInfo(this.command, "&bExecutableItems &aThe variable &e" + this.variableName + "&a of the item in the slot &e" + this.slot + " &ahas been updated to &e" + newValue + " &a!");
        }
    }
}

