/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.restrictions;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.custom.restrictions.RestrictionEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ItemDamageEvent
implements Listener {
    private List<UUID> itemUUIDs = new ArrayList<UUID>();

    @EventHandler
    public void onEntityDamageEvent(EntityDamageEvent event) {
        Item item;
        ExecutableItemObject ei;
        if (event.getEntity() instanceof Item && (ei = new ExecutableItemObject((item = (Item)event.getEntity()).getItemStack())).isValid()) {
            SsomarDev.testMsg((String)("ItemDamageEvent >> onEntityDamageEvent >> " + event.getCause()), (boolean)true);
            switch (event.getCause()) {
                case CONTACT: {
                    if (!ei.getConfig().getRestrictions().is(RestrictionEnum.CANCEL_ITEM_DELETE_BY_CACTUS)) break;
                    this.saveItem(item, event);
                    break;
                }
                case ENTITY_ATTACK: {
                    break;
                }
                case ENTITY_SWEEP_ATTACK: {
                    break;
                }
                case PROJECTILE: {
                    break;
                }
                case SUFFOCATION: {
                    break;
                }
                case FALL: {
                    break;
                }
                case FIRE: {
                    this.fireDamage(ei, item, event);
                    break;
                }
                case FIRE_TICK: {
                    break;
                }
                case MELTING: {
                    break;
                }
                case LAVA: {
                    this.fireDamage(ei, item, event);
                    break;
                }
                case DROWNING: {
                    break;
                }
                case BLOCK_EXPLOSION: {
                    break;
                }
                case ENTITY_EXPLOSION: {
                    break;
                }
                case VOID: {
                    break;
                }
                case LIGHTNING: {
                    if (!ei.getConfig().getRestrictions().is(RestrictionEnum.CANCEL_ITEM_DELETE_BY_LIGHTNING)) break;
                    this.saveItem(item, event);
                    break;
                }
                case SUICIDE: {
                    break;
                }
                case STARVATION: {
                    break;
                }
                case POISON: {
                    break;
                }
                case MAGIC: {
                    break;
                }
                case WITHER: {
                    break;
                }
                case FALLING_BLOCK: {
                    break;
                }
                case THORNS: {
                    break;
                }
                case DRAGON_BREATH: {
                    break;
                }
                case CUSTOM: {
                    break;
                }
                case FLY_INTO_WALL: {
                    break;
                }
                case HOT_FLOOR: {
                    break;
                }
                case CRAMMING: {
                    break;
                }
                case DRYOUT: {
                    break;
                }
            }
        }
    }

    public void fireDamage(ExecutableItemObject ei, Item item, EntityDamageEvent event) {
        if (ei.getConfig().getRestrictions().is(RestrictionEnum.CANCEL_ITEM_BURN)) {
            if (SCore.is1v20v5Plus()) {
                return;
            }
            this.saveItem(item, event);
        }
    }

    public void saveItem(final Item item, EntityDamageEvent event) {
        event.setCancelled(true);
        item.setPickupDelay(60);
        if (this.itemUUIDs.contains(item.getUniqueId())) {
            return;
        }
        this.itemUUIDs.add(item.getUniqueId());
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)ExecutableItems.plugin, new Runnable(){

            @Override
            public void run() {
                if (!item.getItemStack().getType().equals((Object)Material.AIR)) {
                    if (!SCore.is1v8()) {
                        Item newItem = item.getLocation().getWorld().dropItem(item.getLocation().getBlock().getLocation().add(0.5, 1.0, 0.5), item.getItemStack());
                        newItem.setVelocity(new Vector(0, 0, 0));
                        newItem.setInvulnerable(true);
                        newItem.setGravity(false);
                        item.remove();
                    } else {
                        List around = item.getNearbyEntities(3.0, 3.0, 3.0);
                        if (around != null && !around.isEmpty()) {
                            for (Entity e : around) {
                                if (!(e instanceof Player)) continue;
                                Player player = (Player)e;
                                HashMap notAdded = player.getInventory().addItem(new ItemStack[]{item.getItemStack()});
                                if (notAdded.isEmpty()) {
                                    item.remove();
                                    ItemDamageEvent.this.itemUUIDs.remove(item.getUniqueId());
                                    return;
                                }
                                item.setItemStack((ItemStack)notAdded.get(0));
                            }
                        }
                        Item newItem = item.getLocation().getWorld().dropItem(item.getLocation().getBlock().getLocation().add(0.5, 1.0, 0.5), item.getItemStack());
                        newItem.setVelocity(new Vector(0, 0, 0));
                        item.remove();
                        ItemDamageEvent.this.itemUUIDs.remove(item.getUniqueId());
                    }
                }
                ItemDamageEvent.this.itemUUIDs.remove(item.getUniqueId());
            }
        }, 1L);
    }
}

