/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.optimize;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptimizedSlotsVerification {
    private static OptimizedSlotsVerification instance;
    private Map<SOption, List<Integer>> detailedSlotsOptimized;

    public OptimizedSlotsVerification() {
        this.init();
    }

    public static OptimizedSlotsVerification getInstance() {
        if (instance == null) {
            instance = new OptimizedSlotsVerification();
        }
        return instance;
    }

    public void init() {
        this.detailedSlotsOptimized = new HashMap<SOption, List<Integer>>();
    }

    public void reload() {
        this.init();
    }

    public void addAllDetailedSlotsOptimized(SOption o, List<Integer> slots) {
        if (!this.detailedSlotsOptimized.containsKey(o)) {
            this.detailedSlotsOptimized.put(o, new ArrayList());
        }
        for (int slot : slots) {
            this.addDetailedSlotsOptimized(this.detailedSlotsOptimized.get(o), slot);
        }
    }

    public void addDetailedSlotsOptimized(List<Integer> list, int slot) {
        if (!list.contains(slot)) {
            list.add(slot);
        }
    }

    public List<Integer> getDetailedSlotsOptimized(SOption o, int slotMainHand) {
        boolean alreadyIn = false;
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (!this.detailedSlotsOptimized.containsKey(o)) {
            return result;
        }
        for (int slot : this.detailedSlotsOptimized.get(o)) {
            if (slot != -1) {
                result.add(slot);
            }
            if (slot != slotMainHand) continue;
            alreadyIn = true;
        }
        if (!alreadyIn) {
            result.add(slotMainHand);
        }
        return result;
    }

    public void setDetailedSlotsOptimized(Map<SOption, List<Integer>> detailedSlotsOptimized) {
        this.detailedSlotsOptimized = detailedSlotsOptimized;
    }

    public void display() {
        ExecutableItems.plugin.getServer().getLogger().info("================ [ExecutableItems Check Slots] ================");
        ExecutableItems.plugin.getServer().getLogger().info("The slots that is/are checked for every option used: ");
        ExecutableItems.plugin.getServer().getLogger().info("");
        for (SOption o : this.detailedSlotsOptimized.keySet()) {
            String result = "";
            for (int slot : this.detailedSlotsOptimized.get(o)) {
                result = result + " " + slot;
            }
            ExecutableItems.plugin.getServer().getLogger().info(o + " >> " + result);
        }
        ExecutableItems.plugin.getServer().getLogger().info("================ [ExecutableItems Check Slots] ================");
    }
}

