/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.projectiles;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.events.CheckIfDamageIsPosssibleListener;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ProjectileHitPlayerEvent
implements Listener {
    private static final Boolean DEBUG = false;

    @EventHandler
    public void projectileHitPlayerEvent(com.ssomar.sevents.events.projectile.hitplayer.ProjectileHitPlayerEvent e) {
        SsomarDev.testMsg((String)"ProjectileHitPlayerEvent", (boolean)DEBUG);
        Entity entity = e.getEntity();
        Optional<ProjectileInfo> pInfoOpt = ProjectilesHandler.getInstance().getProjectileInfo(entity.getUniqueId());
        if (!pInfoOpt.isPresent()) {
            return;
        }
        SsomarDev.testMsg((String)"ProjectileHitPlayerEvent: ProjectileInfo found", (boolean)DEBUG);
        boolean isNPC = false;
        ProjectileInfo pInfo = pInfoOpt.get();
        Player target = e.getTarget();
        isNPC = target != null && target.hasMetadata("NPC");
        Optional<ExecutableItemObject> ei = pInfo.getEiOpt();
        SsomarDev.testMsg((String)("ProjectileHitPlayerEvent: ExecutableItem present ? " + ei.isPresent()), (boolean)DEBUG);
        EventInfo eInfo = new EventInfo((Event)e);
        eInfo.setPlayer(Optional.of(pInfo.getLauncher()));
        if (isNPC) {
            eInfo.setTargetEntity(Optional.of(target));
        }
        eInfo.setTargetPlayer(Optional.of(target));
        eInfo.setProjectile(Optional.of((Projectile)entity));
        eInfo.setSlot(Optional.of(pInfo.getSlot()));
        if (ei.isPresent()) {
            eInfo.setProjectileProvenance(Optional.ofNullable(ei.get().getConfig().getId()));
        }
        boolean justCancelForActivator = false;
        if (!CheckIfDamageIsPosssibleListener.getInstance().canDamage((Entity)pInfo.getLauncher(), (Damageable)target) && !e.isCancelled()) {
            justCancelForActivator = true;
            e.setCancelled(true);
        }
        boolean runActivatorsItemNotInTheInventory = false;
        if (ei.isPresent()) {
            if (ei.get().getItem() == null || ei.get().getItem().getType().equals((Object)Material.AIR)) {
                runActivatorsItemNotInTheInventory = true;
                ei.get().setItem(null);
            }
            boolean bl = runActivatorsItemNotInTheInventory = runActivatorsItemNotInTheInventory || !SCore.is1v12Less() && ei.get().getItem() != null && ei.get().getItem().getType().equals((Object)Material.TRIDENT);
            if (runActivatorsItemNotInTheInventory) {
                eInfo.setProjectileProvenance(Optional.ofNullable(">NULL<"));
                eInfo.setMainHand(true);
                SsomarDev.testMsg((String)"ProjectileHitPlayerEvent: ExecutableItem found + item is null", (boolean)DEBUG);
                ExecutableItem config = pInfo.getEiOpt().get().getConfig();
                for (SActivator activator : config.getActivators().getActivators().values()) {
                    if ((!isNPC || !activator.getOption().equals((Object)Option.PROJECTILE_HIT_ENTITY)) && (isNPC || !activator.getOption().equals((Object)Option.PROJECTILE_HIT_PLAYER))) continue;
                    activator.runWithException((Object)ei.get(), eInfo);
                }
            }
        }
        if (isNPC) {
            eInfo.setOption((SOption)Option.PROJECTILE_HIT_ENTITY);
        } else {
            eInfo.setOption((SOption)Option.PROJECTILE_HIT_PLAYER);
        }
        EventsManager.getInstance().activeOption(eInfo);
        if (justCancelForActivator) {
            e.setCancelled(false);
        }
    }
}

