/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.commands;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.utils.messages.SendMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;

public class SearchCommand {
    private Optional<ExecutableItemInterface> ei = Optional.empty();
    private String searchMode = "all";
    private CommandSender cs;

    public boolean verify(CommandSender sender, String[] args) {
        this.cs = sender;
        if (args.length >= 1) {
            String firstArg = args[0];
            if (firstArg.equalsIgnoreCase("players") || firstArg.equalsIgnoreCase("containers") || firstArg.equalsIgnoreCase("all")) {
                this.searchMode = firstArg;
            } else if (ExecutableItemsManager.getInstance().isValidID(firstArg)) {
                this.ei = ExecutableItemsManager.getInstance().getExecutableItem(firstArg);
            } else {
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&cThe first argument must be a valid ExecutableItem ID or 'players' or 'containers'");
                return false;
            }
        }
        if (args.length >= 2) {
            String secondArg = args[1];
            if (secondArg.equalsIgnoreCase("players") || secondArg.equalsIgnoreCase("containers") || secondArg.equalsIgnoreCase("all")) {
                this.searchMode = secondArg;
            } else if (ExecutableItemsManager.getInstance().isValidID(secondArg)) {
                this.ei = ExecutableItemsManager.getInstance().getExecutableItem(secondArg);
            } else {
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&cThe second argument must be a valid ExecutableItem ID or 'players' or 'containers' or 'all'");
                return false;
            }
        }
        return true;
    }

    public void run() {
        Object sb;
        if (this.searchMode.equalsIgnoreCase("players") || this.searchMode.equalsIgnoreCase("all")) {
            HashMap<Player, Object> players = new HashMap<Player, Object>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                PlayerInventory inv = p.getInventory();
                ArrayList items = new ArrayList();
                for (int i = 0; i < inv.getSize(); ++i) {
                    ExecutableItemObject eiO;
                    if (inv.getItem(i) == null || !(eiO = new ExecutableItemObject(inv.getItem(i), new ArrayList<String>())).isValid()) continue;
                    if (this.ei.isPresent()) {
                        if (!eiO.getConfig().getId().equalsIgnoreCase(this.ei.get().getId())) continue;
                        items.add(eiO.getConfig().getId());
                        break;
                    }
                    items.add(eiO.getConfig().getId());
                }
                if (items.isEmpty()) continue;
                players.put(p, items);
            }
            for (Player p : players.keySet()) {
                sb = new StringBuilder();
                for (String s : (List)players.get(p)) {
                    ((StringBuilder)sb).append(s).append(", ");
                }
                ((StringBuilder)sb).delete(((StringBuilder)sb).length() - 2, ((StringBuilder)sb).length());
                String desc = "&6PLAYER &e" + p.getName() + " &7>> &a" + p.getLocation().toString() + " &7>> &b" + ((StringBuilder)sb).toString();
                if (this.cs instanceof Player) {
                    SendMessage.sendMessageNoPlch((CommandSender)this.cs, (String)desc);
                }
                SendMessage.sendMessageNoPlch((CommandSender)Bukkit.getConsoleSender(), (String)desc);
            }
        }
        if (this.searchMode.equalsIgnoreCase("containers") || this.searchMode.equalsIgnoreCase("all")) {
            final HashMap blocks = new HashMap();
            for (World w : Bukkit.getWorlds()) {
                for (final Chunk c : w.getLoadedChunks()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            for (BlockState bs : c.getTileEntities()) {
                                if (!(bs instanceof Container)) continue;
                                Container container = (Container)bs;
                                Inventory inv = container.getInventory();
                                ArrayList<String> items = new ArrayList<String>();
                                for (int i = 0; i < inv.getSize(); ++i) {
                                    ExecutableItemObject eiO;
                                    if (inv.getItem(i) == null || !(eiO = new ExecutableItemObject(inv.getItem(i), new ArrayList<String>())).isValid()) continue;
                                    if (SearchCommand.this.ei.isPresent()) {
                                        if (!eiO.getConfig().getId().equalsIgnoreCase(((ExecutableItemInterface)SearchCommand.this.ei.get()).getId())) continue;
                                        items.add(eiO.getConfig().getId());
                                        break;
                                    }
                                    items.add(eiO.getConfig().getId());
                                }
                                if (items.isEmpty()) continue;
                                blocks.put(bs.getBlock(), items);
                            }
                        }
                    };
                    SCore.schedulerHook.runLocationTaskAsap(runnable, c.getBlock(0, 0, 0).getLocation());
                }
            }
            for (Block b : blocks.keySet()) {
                sb = new StringBuilder();
                for (String s : (List)blocks.get(b)) {
                    ((StringBuilder)sb).append(s).append(", ");
                }
                ((StringBuilder)sb).delete(((StringBuilder)sb).length() - 2, ((StringBuilder)sb).length());
                String desc = "&6BLOCK &e" + b.getType().toString() + " &7>> &a" + b.getLocation().toString() + " &7>> &b" + ((StringBuilder)sb).toString();
                if (this.cs instanceof Player) {
                    SendMessage.sendMessageNoPlch((CommandSender)this.cs, (String)desc);
                }
                SendMessage.sendMessageNoPlch((CommandSender)Bukkit.getConsoleSender(), (String)desc);
            }
        }
    }
}

