/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.commands;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.messages.SendMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RefreshCommand {
    public RefreshCommand(CommandSender sender, String[] args) {
        ArrayList<ResetSetting> resetSettings = new ArrayList<ResetSetting>();
        if (args.length < 2) {
            SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&4&l[ExecutableItems] &cERROR not enough arguments &6/ei refresh [player|all] [ExecutableItemID|all] {resetSetting1} {resetSetting2} ...&c!");
            return;
        }
        String playersArg = args[0];
        String executableItemArg = args[1];
        for (ResetSetting resetSetting : ResetSetting.values()) {
            for (String arg : args) {
                if (!arg.equalsIgnoreCase(resetSetting.name())) continue;
                resetSettings.add(resetSetting);
            }
        }
        List<Player> players = playersArg.equals("all") ? (List<Player>)Bukkit.getServer().getOnlinePlayers() : this.decompPlayersArg(playersArg);
        if (players.size() == 0) {
            SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&4&l[ExecutableItems] &cERROR no one of your selected player is online &7/ei refresh [player|all] [ExecutableItemID|all] {resetSetting1} {resetSetting2} ... &c!");
            return;
        }
        List<String> EI_IDS = executableItemArg.equals("all") ? ExecutableItemsManager.getInstance().getLoadedObjectsIDs() : this.decompExecutableItemArg(executableItemArg);
        this.refresh(players, EI_IDS, resetSettings);
        SendMessage.sendMessageNoPlch((CommandSender)sender, (String)MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.REFRESH_VALID).replaceAll("%id%", executableItemArg).replaceAll("%player%", playersArg));
    }

    public static ItemStack refreshEI(@NotNull ExecutableItemObject ei, List<ResetSetting> resetSettings) {
        return ei.refresh(resetSettings);
    }

    public List<Player> decompPlayersArg(String arg) {
        String[] tab;
        ArrayList<Player> players = new ArrayList<Player>();
        for (String s : tab = arg.split(",")) {
            Player p = Bukkit.getServer().getPlayer(s);
            if (p == null) continue;
            players.add(p);
        }
        return players;
    }

    public List<String> decompExecutableItemArg(String arg) {
        String[] tab;
        ArrayList<String> EI_IDS = new ArrayList<String>();
        for (String s : tab = arg.split(",")) {
            EI_IDS.add(s);
        }
        return EI_IDS;
    }

    public void refresh(List<Player> players, List<String> EI_IDS, List<ResetSetting> resetSettings) {
        for (Player p : players) {
            ItemStack[] inv = p.getInventory().getContents();
            ItemStack[] newInv = new ItemStack[inv.length];
            int i = 0;
            for (ItemStack item : inv) {
                newInv[i] = null;
                if (item != null) {
                    ExecutableItem itemConfig;
                    Optional<ExecutableItemInterface> eiOpt = ExecutableItemsManager.getInstance().getExecutableItem(item);
                    if (eiOpt.isPresent() && EI_IDS.contains((itemConfig = (ExecutableItem)eiOpt.get()).getId())) {
                        ExecutableItemObject ei = new ExecutableItemObject(item);
                        ei.loadExecutableItemInfos();
                        item = RefreshCommand.refreshEI(ei, resetSettings);
                    }
                    newInv[i] = item;
                }
                ++i;
            }
            p.getInventory().setContents(newInv);
        }
    }
}

