/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.client.screen.tabs;

import com.google.common.net.InternetDomainName;
import com.google.gson.JsonObject;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.client.screen.tabs.SkinTabType;
import org.samo_lego.fabrictailor.network.payload.HDSkinPayload;
import org.samo_lego.fabrictailor.network.payload.VanillaSkinPayload;
import org.samo_lego.fabrictailor.util.SkinFetcher;
import org.samo_lego.fabrictailor.util.TextTranslations;

public class UrlSkinTab
implements SkinTabType {
    private final class_5250 TITLE = TextTranslations.create("tab.fabrictailor.title_url", new Object[0]);
    private final class_5250 DESCRIPTION = TextTranslations.create("description.fabrictailor.title_url", new Object[0]);
    private final class_1799 ICON = new class_1799((class_1935)class_1802.field_18674);

    public class_5250 getTitle() {
        return this.TITLE;
    }

    public class_5250 getDescription() {
        return this.DESCRIPTION;
    }

    @Override
    public class_1799 getIcon() {
        return this.ICON;
    }

    @Override
    public Optional<class_8710> getSkinChangePacket(class_746 player, String url, boolean useSlim) {
        try {
            String tld;
            URL skinUrl = URI.create((String)url).toURL();
            BufferedImage image = ImageIO.read(skinUrl);
            int height = image.getHeight();
            int width = image.getWidth();
            if (width == 64 && (height == 32 || height == 64)) {
                return SkinFetcher.fetchSkinByUrl((String)url, useSlim).map(VanillaSkinPayload::new);
            }
            JsonObject metadata = null;
            if (useSlim) {
                metadata = new JsonObject();
                metadata.addProperty("model", "slim");
            }
            if (!FabricTailor.config.allowedTextureDomains.contains(tld = InternetDomainName.from((String)skinUrl.getHost()).topDomainUnderRegistrySuffix().toString())) {
                url = "https://external-content.duckduckgo.com/iu/?u=" + String.valueOf(skinUrl);
            }
            Property skinData = this.getExtendedProperty(player, MinecraftProfileTexture.Type.SKIN, (String)url, metadata);
            return Optional.of(new HDSkinPayload(skinData));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }
}

