/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.command;

import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.function.Supplier;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.casts.TailoredPlayer;
import org.samo_lego.fabrictailor.mixin.accessors.AEntitySelector;
import org.samo_lego.fabrictailor.util.SkinFetcher;
import org.samo_lego.fabrictailor.util.TextTranslations;

public class SkinCommand {
    private static final class_5250 SKIN_SET_ERROR = TextTranslations.create("command.fabrictailor.skin.set.error", new Object[0]).method_27692(class_124.field_1061);
    private static final class_5250 SET_SKIN_ATTEMPT = TextTranslations.create("command.fabrictailor.skin.set.attempt", new Object[0]);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin", (boolean)true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set", (boolean)true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"URL").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.url", (boolean)true))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"classic").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.url.classic", (boolean)true))).then(class_2170.method_9244((String)"skin URL", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinUrl((CommandContext<class_2168>)context, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slim").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.url.slim", (boolean)true))).then(class_2170.method_9244((String)"skin URL", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinUrl((CommandContext<class_2168>)context, true)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"upload").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.upload", (boolean)true))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"classic").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.upload.classic", (boolean)true))).then(class_2170.method_9244((String)"skin file path", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinFile((CommandContext<class_2168>)context, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slim").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.upload.slim", (boolean)true))).then(class_2170.method_9244((String)"skin file path", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinFile((CommandContext<class_2168>)context, true)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"custom").requires(src -> !FabricTailor.config.customSkinServer.isEmpty() && Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.custom", (boolean)true))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"classic").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.custom.classic", (boolean)true))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SkinCommand.setSkinCustom((CommandContext<class_2168>)context, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slim").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.custom.slim", (boolean)true))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SkinCommand.setSkinCustom((CommandContext<class_2168>)context, true)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.set.player", (boolean)true))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(SkinCommand::setSkinPlayer))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)TextTranslations.create("command.fabrictailor.skin.set.404.playername", new Object[0]).method_27692(class_124.field_1061));
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(src -> Permissions.check((class_2172)src, (String)"fabrictailor.command.skin.clear", (boolean)true))).executes(context -> SkinCommand.clearSkin(((class_2168)context.getSource()).method_9207()) ? 1 : 0)));
    }

    private static int setSkinCustom(CommandContext<class_2168> context, boolean useSlim) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String playername = StringArgumentType.getString(context, (String)"name");
        String skinUrl = FabricTailor.config.customSkinServer.replace("{player}", playername);
        SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByUrl(skinUrl, useSlim));
        return 1;
    }

    private static int setSkinUrl(CommandContext<class_2168> context, boolean useSlim) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String skinUrl = class_2196.method_9339(context, (String)"skin URL").getString();
        SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByUrl(skinUrl, useSlim));
        return 1;
    }

    private static int setSkinFile(CommandContext<class_2168> context, boolean useSlim) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String skinFilePath = class_2196.method_9339(context, (String)"skin file path").getString();
        MinecraftServer server = player.method_51469().method_8503();
        if (server != null && server.method_3816() && FabricTailor.config.logging.skinChangeFeedback) {
            player.method_7353((class_2561)TextTranslations.create("hint.fabrictailor.server_skin_path", new Object[0]).method_27692(class_124.field_1065), false);
        }
        SkinCommand.setSkin(player, () -> SkinFetcher.setSkinFromFile(skinFilePath, useSlim));
        if (FabricTailor.config.logging.skinChangeFeedback) {
            player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.please_wait", new Object[0]).method_27692(class_124.field_1065), false);
        }
        return 1;
    }

    private static int setSkinPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2300 selector = (class_2300)context.getArgument("target", class_2300.class);
        String input = ((AEntitySelector)selector).getPlayerName();
        try {
            String name = selector.method_9811((class_2168)context.getSource()).method_5820();
            SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByName(name));
        }
        catch (CommandSyntaxException e) {
            if (input == null) {
                throw e;
            }
            SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByName(input));
        }
        return 1;
    }

    public static void setSkin(class_3222 player, Supplier<Optional<Property>> skinProvider) {
        long lastChange = ((TailoredPlayer)player).fabrictailor_getLastSkinChange();
        long now = System.currentTimeMillis();
        if (now - lastChange > FabricTailor.config.skinChangeTimer * 1000L || lastChange == 0L) {
            player.method_7353((class_2561)SET_SKIN_ATTEMPT.method_27692(class_124.field_1075), false);
            FabricTailor.THREADPOOL.submit(() -> {
                Optional skinData = (Optional)skinProvider.get();
                if (skinData.isEmpty()) {
                    player.method_7353((class_2561)SKIN_SET_ERROR, false);
                } else {
                    ((TailoredPlayer)player).fabrictailor_setSkin((Property)skinData.get(), true);
                    if (FabricTailor.config.logging.skinChangeFeedback) {
                        player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.set.success", new Object[0]).method_27692(class_124.field_1060), false);
                    }
                }
            });
        } else {
            class_5250 timeLeft = class_2561.method_43470((String)String.valueOf((FabricTailor.config.skinChangeTimer * 1000L - now + lastChange) / 1000L)).method_27692(class_124.field_1076);
            player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.timer.please_wait", timeLeft).method_27692(class_124.field_1061), false);
        }
    }

    public static boolean clearSkin(class_3222 player) {
        long lastChange = ((TailoredPlayer)player).fabrictailor_getLastSkinChange();
        long now = System.currentTimeMillis();
        if (now - lastChange > FabricTailor.config.skinChangeTimer * 1000L || lastChange == 0L) {
            ((TailoredPlayer)player).fabrictailor_clearSkin();
            if (FabricTailor.config.logging.skinChangeFeedback) {
                player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.clear.success", new Object[0]).method_27692(class_124.field_1060), false);
            }
            return true;
        }
        class_5250 timeLeft = class_2561.method_43470((String)String.valueOf((FabricTailor.config.skinChangeTimer * 1000L - now + lastChange) / 1000L)).method_27692(class_124.field_1076);
        player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.timer.please_wait", timeLeft).method_27692(class_124.field_1061), false);
        return false;
    }
}

