/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.samo_lego.config2brigadier.common.IBrigadierConfigurator;
import org.samo_lego.config2brigadier.common.annotation.BrigadierDescription;
import org.samo_lego.config2brigadier.common.annotation.BrigadierExcluded;
import org.samo_lego.fabrictailor.FabricTailor;

public class TailorConfig
implements IBrigadierConfigurator {
    private static final Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="// Whether to allow players to have capes. WARNING! This will toggle ALL capes!")
    public final String _comment_allowCapes = "(default: true)";
    @BrigadierDescription(defaultOption="true")
    @SerializedName(value="allow_capes")
    public boolean allowCapes = true;
    public Logging logging = new Logging();
    @SerializedName(value="// Default skin for new players. Use command `/fabrictailor setDefaultSkin` to set those values.")
    public final String _comment_defaultSkin = "";
    @SerializedName(value="default_skin")
    public DefaultSkin defaultSkin = new DefaultSkin();
    @SerializedName(value="// How quickly can player change the skin, in seconds. -1 for no limit. If using this in server environment, -1 is not recommended.")
    public final String _comment_skinChangeTimer = "(default in singleplayer: -1, default for server: 60)";
    @BrigadierDescription(defaultOption="-1")
    @SerializedName(value="skin_change_timer")
    public long skinChangeTimer = -1L;
    @SerializedName(value="// Custom skin server URL.")
    public final String _comment_customSkinServer0 = "";
    @SerializedName(value="// If not empty, you'll get another command /skin set custom, which will use this server.")
    public final String _comment_customSkinServer1 = "";
    @SerializedName(value="// Available parameters: {player}. Example: https://skins.samolego.org/{player}.png. Skins returned need to be 64x64!")
    public final String _comment_customSkinServer2 = "";
    @BrigadierDescription(defaultOption="")
    @SerializedName(value="custom_skin_server")
    public String customSkinServer = "";
    @SerializedName(value="texture_allowed_domains")
    public Set<String> allowedTextureDomains = new HashSet<String>(Set.of("minecraft.net", "mojang.com", "crafatar.com", "imgur.com", "githubusercontent.com", "minecraftskins.com", "mc-heads.net", "ely.by", "namemc.com", "planetminecraft.com", "googleusercontent.com", "nocookie.net", "discord.com", "duckduckgo.com"));

    public void save() {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(FabricTailor.configFile), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            org.samo_lego.fabrictailor.util.Logging.error("Problem occurred when saving config: " + e.getMessage());
        }
    }

    public static TailorConfig loadConfigFile(File file, boolean serverEnvironment) {
        return (TailorConfig)IBrigadierConfigurator.loadConfigFile((File)file, TailorConfig.class, () -> {
            TailorConfig config = new TailorConfig();
            if (serverEnvironment) {
                config.skinChangeTimer = 60L;
            } else {
                config.defaultSkin.applyToAll = true;
            }
            return config;
        });
    }

    public static class Logging {
        @SerializedName(value="// Whether to send (successful) command feedback for skin changes. Errors are sent regardless.")
        public final String _comment_skinChangeFeedback = "(default: true)";
        @BrigadierDescription(defaultOption="true")
        @SerializedName(value="skin_change_feedback")
        public boolean skinChangeFeedback = true;
        @SerializedName(value="// Whether to send debug messages to console.")
        public final String _comment_debug = "(default: false)";
        @BrigadierDescription(defaultOption="false")
        public boolean debug = false;
    }

    public static class DefaultSkin {
        @SerializedName(value="// Whether to apply the default skin to ALL new players, not just those without skin.")
        public final String _comment_applyToAll = "(default: false)";
        @BrigadierDescription(defaultOption="false")
        @SerializedName(value="apply_to_all")
        public boolean applyToAll = false;
        @BrigadierExcluded
        public String value = "";
        @BrigadierExcluded
        public String signature = "";
    }
}

