/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.mixin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10182;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2703;
import net.minecraft.class_2708;
import net.minecraft.class_2724;
import net.minecraft.class_2744;
import net.minecraft.class_2748;
import net.minecraft.class_2752;
import net.minecraft.class_2783;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_3898;
import net.minecraft.class_4543;
import net.minecraft.class_7828;
import net.minecraft.class_8589;
import net.minecraft.class_8791;
import net.minecraft.class_9834;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.casts.TailoredPlayer;
import org.samo_lego.fabrictailor.mixin.accessors.AAvatar;
import org.samo_lego.fabrictailor.mixin.accessors.AChunkMap;
import org.samo_lego.fabrictailor.mixin.accessors.APlayer;
import org.samo_lego.fabrictailor.mixin.accessors.ATrackedEntity;
import org.samo_lego.fabrictailor.util.Logging;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MServerPlayerEntity_TailoredPlayer
extends class_1657
implements TailoredPlayer {
    @Unique
    private static final String STEVE = "MHF_STEVE";
    @Unique
    private final class_3222 self = (class_3222)this;
    @Shadow
    public class_3244 field_13987;
    @Unique
    private String skinValue;
    @Unique
    private String skinSignature;
    @Unique
    private long lastSkinChangeTime = 0L;

    @Shadow
    protected abstract void method_6040();

    public MServerPlayerEntity_TailoredPlayer(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Override
    public void fabrictailor_reloadSkin() {
        Logging.debug("Reloading skin for player " + this.self.method_5477().getString());
        class_3324 playerManager = this.self.method_51469().method_8503().method_3760();
        playerManager.method_14581((class_2596)new class_7828(new ArrayList<UUID>(Collections.singleton(this.self.method_5667()))));
        playerManager.method_14581((class_2596)class_2703.method_43886(Collections.singleton(this.self)));
        class_3215 manager = this.self.method_51469().method_14178();
        class_3898 storage = manager.field_17254;
        ATrackedEntity trackerEntry = (ATrackedEntity)((AChunkMap)storage).getEntityTrackers().get(this.self.method_5628());
        if (FabricTailor.config.logging.debug) {
            Logging.debug("Trackers for the player: " + trackerEntry.getSeenBy().size());
            trackerEntry.getSeenBy().forEach(tracking -> Logging.debug("Tracker for player: " + tracking.method_32311().method_5477().getString()));
        }
        trackerEntry.getSeenBy().forEach(tracking -> trackerEntry.getServerEntity().method_18760(tracking.method_32311()));
        Logging.debug("Reloading player skin on player's client.");
        class_3218 level = this.self.method_51469();
        this.field_13987.method_14364((class_2596)new class_2724(new class_8589(level.method_40134(), level.method_27983(), class_4543.method_27984((long)level.method_8412()), this.self.field_13974.method_14257(), this.self.field_13974.method_30119(), level.method_27982(), level.method_28125(), this.self.method_43122(), this.method_51848(), level.method_8615()), 3));
        this.field_13987.method_14364((class_2596)new class_2708(0, class_10182.method_63638((class_1297)this.self), Collections.emptySet()));
        this.field_13987.method_14364((class_2596)new class_9834(this.method_31548().method_7391()));
        this.field_13987.method_14364((class_2596)new class_2632(level.method_8407(), level.method_8401().method_197()));
        this.field_13987.method_14364((class_2596)new class_2748(this.field_7510, this.field_7495, this.field_7520));
        playerManager.method_14606(this.self, level);
        playerManager.method_14576(this.self);
        for (class_1293 statusEffect : this.method_6026()) {
            this.field_13987.method_14364((class_2596)new class_2783(this.self.method_5628(), statusEffect, false));
        }
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (class_1304 equipmentSlot : class_1304.values()) {
            class_1799 itemStack = this.self.method_6118(equipmentSlot);
            if (itemStack.method_7960()) continue;
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)itemStack.method_7972()));
        }
        if (!equipmentList.isEmpty()) {
            this.field_13987.method_14364((class_2596)new class_2744(this.self.method_5628(), equipmentList));
        }
        if (!this.self.method_5685().isEmpty()) {
            this.field_13987.method_14364((class_2596)new class_2752((class_1297)this.self));
        }
        if (this.self.method_5765()) {
            this.field_13987.method_14364((class_2596)new class_2752(this.self.method_5854()));
        }
        this.method_7355();
        playerManager.method_14594(this.self);
    }

    @Override
    public void fabrictailor_setSkin(Property skinData, boolean reload) {
        ArrayListMultimap properties2;
        Logging.debug("Setting skin for player " + this.self.method_5477().getString());
        try {
            Logging.debug("Clearing existing skin for player");
            properties2 = ArrayListMultimap.create((Multimap)this.method_7334().properties());
            properties2.removeAll((Object)"textures");
            ((APlayer)((Object)this)).setGameProfile(new GameProfile(this.method_7334().id(), this.method_7334().name(), new PropertyMap((Multimap)properties2)));
        }
        catch (Exception properties2) {
            // empty catch block
        }
        try {
            properties2 = ArrayListMultimap.create((Multimap)this.method_7334().properties());
            properties2.put((Object)"textures", (Object)skinData);
            ((APlayer)((Object)this)).setGameProfile(new GameProfile(this.method_7334().id(), this.method_7334().name(), new PropertyMap((Multimap)properties2)));
            this.skinValue = skinData.value();
            this.skinSignature = skinData.signature();
            if (reload) {
                this.fabrictailor_reloadSkin();
            }
            this.lastSkinChangeTime = System.currentTimeMillis();
        }
        catch (Error e) {
            Logging.error(e.getMessage());
        }
    }

    @Override
    public void fabrictailor_setSkin(String value, String signature, boolean reload) {
        this.fabrictailor_setSkin(new Property("textures", value, signature), reload);
    }

    @Override
    public Optional<String> fabrictailor_getSkinValue() {
        if (this.skinValue == null) {
            try {
                Property property = (Property)this.method_7334().properties().get((Object)"textures").iterator().next();
                this.skinValue = property.value();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(this.skinValue);
    }

    @Override
    public Optional<String> fabrictailor_getSkinSignature() {
        if (this.skinSignature == null) {
            try {
                Property property = (Property)this.method_7334().properties().get((Object)"textures").iterator().next();
                this.skinSignature = property.signature();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(this.skinSignature);
    }

    @Override
    public long fabrictailor_getLastSkinChange() {
        return this.lastSkinChangeTime;
    }

    @Override
    public void fabrictailor_clearSkin() {
        try {
            ArrayListMultimap properties = ArrayListMultimap.create((Multimap)this.method_7334().properties());
            properties.removeAll((Object)"textures");
            ((APlayer)((Object)this)).setGameProfile(new GameProfile(this.method_7334().id(), this.method_7334().name(), new PropertyMap((Multimap)properties)));
            this.skinValue = null;
            this.skinSignature = null;
            this.fabrictailor_reloadSkin();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String fabrictailor_getSkinId() {
        String skin = this.skinValue;
        if (skin == null) {
            Optional textures = this.self.method_7334().properties().get((Object)"textures").stream().findAny();
            if (textures.isPresent()) {
                skin = ((Property)textures.get()).value();
            } else {
                return STEVE;
            }
        }
        String decoded = new String(Base64.getDecoder().decode(skin));
        String url = JsonParser.parseString((String)decoded).getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").getAsJsonPrimitive("url").getAsString();
        return url.substring(url.lastIndexOf(47) + 1);
    }

    @Override
    public void fabrictailor_resetLastSkinChange() {
        this.lastSkinChangeTime = 0L;
    }

    @Inject(method={"updateOptions"}, at={@At(value="TAIL")})
    private void disableCapeIfNeeded(class_8791 clientSkinPrefs, CallbackInfo ci) {
        if (!FabricTailor.config.allowCapes) {
            byte playerModel = (byte)clientSkinPrefs.comp_1955();
            playerModel = (byte)(playerModel & 0xFFFFFFFE);
            this.self.method_5841().method_12778(AAvatar.getPLAYER_MODEL_PARTS(), (Object)playerModel);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_11372 valueOutput, CallbackInfo ci) {
        Optional<String> skinValue = this.fabrictailor_getSkinValue();
        if (skinValue.isPresent()) {
            class_11372 skinData = valueOutput.method_71461("fabrictailor:skin_data");
            skinData.method_71469("value", skinValue.get());
            if (this.fabrictailor_getSkinSignature().isPresent()) {
                skinData.method_71469("signature", this.fabrictailor_getSkinSignature().get());
            }
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_11368 valueInput, CallbackInfo ci) {
        Optional skinDataOP = valueInput.method_71420("fabrictailor:skin_data");
        if (skinDataOP.isEmpty()) {
            return;
        }
        class_11368 skinData = (class_11368)skinDataOP.get();
        Optional skinValueOP = skinData.method_71441("value");
        Optional skinSignatureOP = skinData.method_71441("signature");
        if (skinValueOP.isEmpty()) {
            return;
        }
        this.skinValue = (String)skinValueOP.get();
        this.skinSignature = skinSignatureOP.orElse("");
        this.fabrictailor_setSkin(this.skinValue, this.skinSignature, false);
    }
}

