/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import org.samo_lego.fabrictailor.util.Logging;

public class SkinFetcher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Property> setSkinFromFile(String skinFilePath, boolean useSlim) {
        Logging.debug("Fetching skin from file: " + skinFilePath);
        File skinFile = new File(skinFilePath);
        try (FileInputStream input = new FileInputStream(skinFile);){
            int fileType = input.read();
            Logging.debug("Checking file type: " + fileType);
            if (fileType != 137) return Optional.empty();
            BufferedImage image = ImageIO.read(skinFile);
            if (image.getWidth() != 64 || image.getHeight() != 64 && image.getHeight() != 32) {
                Logging.error("Image dimensions are not 64x64 or 32x64! The actual format is: " + image.getWidth() + "x" + image.getHeight());
                Optional<Property> optional2 = Optional.empty();
                return optional2;
            }
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mineskin.org/v2/generate").toURL(), false, skinFile, null, useSlim ? "slim" : "classic");
            Optional<Property> optional = SkinFetcher.getSkinFromReply(reply);
            return optional;
        }
        catch (IOException e2) {
            Logging.error(e2.getMessage());
        }
        return Optional.empty();
    }

    public static Optional<Property> fetchSkinByUrl(String skinUrl, boolean useSlim) {
        Logging.debug("Fetching skin from URL: " + skinUrl);
        try {
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mineskin.org/v2/generate").toURL(), false, null, skinUrl, useSlim ? "slim" : "classic");
            return SkinFetcher.getSkinFromReply(reply);
        }
        catch (IOException e) {
            Logging.error(e.getMessage());
            return Optional.empty();
        }
    }

    public static Optional<Property> fetchSkinByName(String playername) {
        Logging.debug("Fetching Mojang skin of player: " + playername);
        try {
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mojang.com/users/profiles/minecraft/" + playername).toURL(), true, null);
            if (reply == null || !reply.contains("id")) {
                Logging.debug("Mojang skin not found, trying via proxy.");
                reply = SkinFetcher.urlRequest(URI.create(String.format("http://skinsystem.ely.by/textures/signed/%s.png?proxy=true", playername)).toURL(), false, null);
            } else {
                String uuid = JsonParser.parseString((String)reply).getAsJsonObject().get("id").getAsString();
                Logging.debug("Mojang skin found. UUID: " + uuid);
                reply = SkinFetcher.urlRequest(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").toURL(), true, null);
            }
            return SkinFetcher.getSkinFromReply(reply);
        }
        catch (IOException e) {
            Logging.error(e.getMessage());
            return Optional.empty();
        }
    }

    protected static Optional<Property> getSkinFromReply(String reply) {
        Logging.debug("Parsing skin reply: " + reply);
        if (reply == null || reply.contains("error") || reply.isEmpty()) {
            return Optional.empty();
        }
        String value = reply.split("\"value\":\"")[1].split("\"")[0];
        String signature = reply.split("\"signature\":\"")[1].split("\"")[0];
        return Optional.of(new Property("textures", value, signature));
    }

    private static String urlRequest(URL url, boolean useGetMethod, File image) throws IOException {
        return SkinFetcher.urlRequest(url, useGetMethod, image, null, "classic");
    }

    private static String urlRequest(URL url, boolean useGetMethod, File image, String skinUrl, String variant) throws IOException {
        URLConnection connection = url.openConnection();
        String reply = null;
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setUseCaches(false);
            httpsConnection.setDoOutput(true);
            httpsConnection.setDoInput(true);
            httpsConnection.setRequestMethod(useGetMethod ? "GET" : "POST");
            if (image != null) {
                String boundary = UUID.randomUUID().toString();
                httpsConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                httpsConnection.setRequestProperty("User-Agent", "User-Agent");
                OutputStream outputStream = httpsConnection.getOutputStream();
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
                String LINE = "\r\n";
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"").append("\r\n");
                writer.append("Content-Type: text/plain; charset=UTF-8").append("\r\n");
                writer.append("\r\n");
                writer.append(image.getName()).append("\r\n");
                writer.flush();
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(image.getName()).append("\"");
                if (variant != null) {
                    writer.append("; variant=\"").append(variant).append("\"");
                }
                writer.append("\r\n");
                writer.append("Content-Type: image/png").append("\r\n");
                writer.append("Content-Transfer-Encoding: binary").append("\r\n");
                writer.append("\r\n");
                writer.flush();
                byte[] fileBytes = Files.readAllBytes(image.toPath());
                outputStream.write(fileBytes, 0, fileBytes.length);
                outputStream.flush();
                writer.append("\r\n");
                writer.flush();
                writer.append("--").append(boundary).append("--").append("\r\n");
                writer.close();
            }
            if (skinUrl != null) {
                httpsConnection.setRequestProperty("Content-Type", "application/json");
                httpsConnection.setRequestProperty("User-Agent", "User-Agent");
                OutputStream outputStream = httpsConnection.getOutputStream();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                JsonObject json = new JsonObject();
                json.addProperty("url", skinUrl);
                json.addProperty("variant", variant);
                writer.write(json.toString());
                writer.flush();
                writer.close();
            }
            if (httpsConnection.getResponseCode() == 200) {
                reply = SkinFetcher.getContent(connection);
            }
            httpsConnection.disconnect();
        } else {
            reply = SkinFetcher.getContent(connection);
        }
        return reply;
    }

    /*
     * Exception decompiling
     */
    private static String getContent(URLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

