/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.config.Config;
import forge.me.thosea.badoptimizations.hook.CacheHooks;
import forge.me.thosea.badoptimizations.mixin.accessors.GameRendererAccessor;
import forge.me.thosea.badoptimizations.mixin.accessors.PlayerAccessor;
import forge.me.thosea.badoptimizations.utils.CommonColorFactors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class MixinLightmapManager {
    @Shadow
    @Final
    private Minecraft minecraft;
    private final CommonColorFactors bo$commonFactors = CommonColorFactors.LIGHTMAP;
    private double bo$lastGamma;
    private DimensionSpecialEffects bo$lastDimension;
    private boolean bo$lastNightVision;
    private boolean bo$lastConduitPower;
    private float bo$previousSkyDarkness;
    @Final
    private GameRendererAccessor bo$gameRendererAccessor;

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/Minecraft;)V"}, at={@At(value="TAIL")})
    private void onInit(GameRenderer renderer, Minecraft client, CallbackInfo ci) {
        this.bo$gameRendererAccessor = (GameRendererAccessor)renderer;
    }

    private boolean bo$isDirty() {
        boolean hasNightVision;
        if (this.bo$commonFactors.getTimeDelta() >= (long)Config.lightmapTimeForUpdate) {
            return true;
        }
        if (this.minecraft.player.isUnderWater() && ((PlayerAccessor)this.minecraft.player).bo$underwaterVisibilityTicks() < 600) {
            return true;
        }
        MobEffectInstance nightVision = this.minecraft.player.getEffect(MobEffects.NIGHT_VISION);
        boolean bl = hasNightVision = nightVision != null;
        if (this.bo$lastNightVision != hasNightVision) {
            this.bo$lastNightVision = hasNightVision;
            return true;
        }
        if (nightVision != null && nightVision.endsWithin(200)) {
            return true;
        }
        if (this.minecraft.player.hasEffect(MobEffects.DARKNESS)) {
            return true;
        }
        boolean conduitPower = this.minecraft.player.hasEffect(MobEffects.CONDUIT_POWER);
        if (this.bo$lastConduitPower != conduitPower) {
            this.bo$lastConduitPower = conduitPower;
            return true;
        }
        DimensionSpecialEffects dimension = this.minecraft.level.effects();
        if (this.bo$lastDimension != dimension) {
            this.bo$lastDimension = dimension;
            return true;
        }
        float skyDarkness = this.bo$gameRendererAccessor.bo$getSkyDarkness();
        if (this.bo$previousSkyDarkness != skyDarkness) {
            this.bo$previousSkyDarkness = skyDarkness;
            return true;
        }
        double gamma = (Double)this.minecraft.options.gamma().get();
        if (this.bo$lastGamma != gamma) {
            this.bo$lastGamma = gamma;
            return true;
        }
        return CacheHooks.invokeLightmap();
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTick(CallbackInfo ci) {
        if (this.minecraft.player == null) {
            return;
        }
        CommonColorFactors.tick(this.minecraft.getFrameTime());
        if (this.bo$commonFactors.didTickChange() && this.bo$commonFactors.isDirty() | this.bo$isDirty()) {
            this.bo$commonFactors.updateLastTime();
        } else {
            ci.cancel();
        }
    }
}

