/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import com.mojang.serialization.MapCodec;
import hexagonnico.undergroundworlds.UndergroundWorlds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuicksandBlock
extends FallingBlock
implements BucketPickup {
    public static final MapCodec<QuicksandBlock> CODEC = QuicksandBlock.simpleCodec(QuicksandBlock::new);
    private static final VoxelShape EMPTY_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);

    public QuicksandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public int getDustColor(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return 14406560;
    }

    protected boolean skipRendering(@NotNull BlockState state, BlockState adjacentState, @NotNull Direction direction) {
        return adjacentState.is((Block)this) || super.skipRendering(state, adjacentState, direction);
    }

    @NotNull
    protected VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Entity entity, @NotNull InsideBlockEffectApplier effectApplier, boolean intersects) {
        if (!(entity instanceof LivingEntity) || entity.getInBlockState().is((Block)this)) {
            entity.makeStuckInBlock(state, new Vec3(0.5, 0.5, 0.5));
        }
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() != null && context.isAbove(EMPTY_SHAPE, pos, false) && !entityCollisionContext.getEntity().getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"can_walk_on_quicksand"))) && !(entityCollisionContext.getEntity() instanceof FallingBlockEntity)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return true;
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable LivingEntity livingEntity, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state) {
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!world.isClientSide()) {
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        return new ItemStack((ItemLike)UndergroundWorlds.QUICKSAND_BUCKET.get());
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.SAND_BREAK);
    }
}

