/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.items;

import com.google.common.collect.Maps;
import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.config.ModConfig;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import org.jetbrains.annotations.NotNull;

public class SpiderArmorItem
extends Item {
    public static final ArmorMaterial SPIDER_ARMOR_MATERIAL = new ArmorMaterial(5, (Map)Maps.newEnumMap(Map.of(ArmorType.BOOTS, 1, ArmorType.LEGGINGS, 4, ArmorType.CHESTPLATE, 5, ArmorType.HELMET, 2, ArmorType.BODY, 4)), 17, SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"repairs_spider_armor")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"spider")));

    public SpiderArmorItem(Item.Properties properties, ArmorType slot) {
        super(properties.humanoidArmor(SPIDER_ARMOR_MATERIAL, slot));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay tooltipDisplay, @NotNull Consumer<Component> tooltipAdder, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.empty());
        tooltipAdder.accept((Component)Component.translatable((String)"item.modifiers.undergroundworlds.full_set").withStyle(ChatFormatting.GRAY));
        tooltipAdder.accept((Component)Component.literal((String)((int)(ModConfig.SPIDER_ARMOR_POISON_CHANCE.get() * 100.0) + "% ")).append((Component)Component.translatable((String)"item.modifiers.undergroundworlds.spider_armor_full_set")).withStyle(ChatFormatting.BLUE));
    }

    public static boolean isWearingFullSet(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).is((Item)UndergroundWorlds.SPIDER_HELMET.get()) && entity.getItemBySlot(EquipmentSlot.CHEST).is((Item)UndergroundWorlds.SPIDER_CHESTPLATE.get()) && entity.getItemBySlot(EquipmentSlot.LEGS).is((Item)UndergroundWorlds.SPIDER_LEGGINGS.get()) && entity.getItemBySlot(EquipmentSlot.FEET).is((Item)UndergroundWorlds.SPIDER_BOOTS.get());
    }
}

