/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.neoforge;

import com.mojang.serialization.MapCodec;
import hexagonnico.undergroundworlds.ModLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeModLoader
extends ModLoader {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"undergroundworlds");
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"undergroundworlds");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"undergroundworlds");
    private static final DeferredRegister.Entities ENTITIES = DeferredRegister.createEntities((String)"undergroundworlds");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"undergroundworlds");
    private static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"undergroundworlds");
    private static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"undergroundworlds");
    private static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"undergroundworlds");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"undergroundworlds");
    private static final DeferredRegister<MapDecorationType> MAP_DECORATION_TYPES = DeferredRegister.create((ResourceKey)Registries.MAP_DECORATION_TYPE, (String)"undergroundworlds");
    private static boolean registerDone = false;

    @Override
    public <T extends Item> Supplier<T> registerItem(String name, Function<Item.Properties, T> function) {
        return ITEMS.registerItem(name, function);
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> function) {
        return BLOCKS.registerBlock(name, function);
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String name, BiFunction<BlockPos, BlockState, T> blockEntity, Supplier<Set<Block>> blocks) {
        return BLOCK_ENTITIES.register(name, () -> new BlockEntityType(blockEntity::apply, (Set)blocks.get()));
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        return ENTITIES.register(name, () -> builder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)name))));
    }

    @Override
    public <T extends Feature<?>> Supplier<T> registerFeature(String name, Supplier<T> supplier) {
        return FEATURES.register(name, supplier);
    }

    @Override
    public <T extends StructureProcessor> Supplier<StructureProcessorType<T>> registerStructureProcessor(String name, Supplier<MapCodec<T>> supplier) {
        return STRUCTURE_PROCESSORS.register(name, () -> ((Supplier)supplier)::get);
    }

    @Override
    public Supplier<LootItemConditionType> registerLootCondition(String name, Supplier<MapCodec<? extends LootItemCondition>> supplier) {
        return LOOT_CONDITIONS.register(name, () -> new LootItemConditionType((MapCodec)supplier.get()));
    }

    @Override
    public <T> Supplier<DataComponentType<T>> registerDataComponent(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA_COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    @Override
    public Supplier<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)name)));
    }

    @Override
    public Supplier<MapDecorationType> registerMapDecorationType(String name) {
        return MAP_DECORATION_TYPES.register(name, () -> new MapDecorationType(ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)name), true, -1, true, false));
    }

    @Override
    public String getName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isRegisterDone() {
        return registerDone;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.getCurrent().isProduction();
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
        BLOCKS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        ENTITIES.register(eventBus);
        FEATURES.register(eventBus);
        STRUCTURE_PROCESSORS.register(eventBus);
        LOOT_CONDITIONS.register(eventBus);
        DATA_COMPONENTS.register(eventBus);
        SOUND_EVENTS.register(eventBus);
        MAP_DECORATION_TYPES.register(eventBus);
        registerDone = true;
    }
}

