/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import hexagonnico.undergroundworlds.UndergroundWorlds;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class ModChestRenderer<T extends BlockEntity>
extends ChestRenderer<T> {
    private static final Material JUNGLE_CHEST_MATERIAL = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/temple"));
    private static final Material WEB_COVERED_CHEST_MATERIAL = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/web_covered"));
    private static final Material WEB_COVERED_CHEST_MATERIAL_LEFT = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/web_covered_left"));
    private static final Material WEB_COVERED_CHEST_MATERIAL_RIGHT = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/web_covered_right"));
    private static final Material ICE_CHEST_MATERIAL = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/ice"));
    private final MaterialSet materials;
    private final ChestModel singleModel;
    private final ChestModel doubleLeftModel;
    private final ChestModel doubleRightModel;

    public ModChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.materials = context.materials();
        this.singleModel = new ChestModel(context.bakeLayer(ModelLayers.CHEST));
        this.doubleLeftModel = new ChestModel(context.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT));
        this.doubleRightModel = new ChestModel(context.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT));
    }

    public void submit(@NotNull ChestRenderState chestRenderState, @NotNull PoseStack poseStack, @NotNull SubmitNodeCollector submitNodeCollector, @NotNull CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-chestRenderState.angle));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        float f = chestRenderState.open;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        Material material = this.chooseMaterial(chestRenderState);
        RenderType renderType = material.renderType(RenderType::entityCutout);
        TextureAtlasSprite textureAtlasSprite = this.materials.get(material);
        if (chestRenderState.type != ChestType.SINGLE) {
            if (chestRenderState.type == ChestType.LEFT) {
                submitNodeCollector.submitModel((Model)this.doubleLeftModel, (Object)Float.valueOf(f), poseStack, renderType, chestRenderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureAtlasSprite, 0, chestRenderState.breakProgress);
            } else {
                submitNodeCollector.submitModel((Model)this.doubleRightModel, (Object)Float.valueOf(f), poseStack, renderType, chestRenderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureAtlasSprite, 0, chestRenderState.breakProgress);
            }
        } else {
            submitNodeCollector.submitModel((Model)this.singleModel, (Object)Float.valueOf(f), poseStack, renderType, chestRenderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureAtlasSprite, 0, chestRenderState.breakProgress);
        }
        poseStack.popPose();
    }

    private Material chooseMaterial(ChestRenderState chestRenderState) {
        if (chestRenderState.blockState.is((Block)UndergroundWorlds.TEMPLE_CHEST.get())) {
            return JUNGLE_CHEST_MATERIAL;
        }
        if (chestRenderState.blockState.is((Block)UndergroundWorlds.WEB_COVERED_CHEST.get())) {
            return switch (chestRenderState.type) {
                default -> throw new MatchException(null, null);
                case ChestType.SINGLE -> WEB_COVERED_CHEST_MATERIAL;
                case ChestType.LEFT -> WEB_COVERED_CHEST_MATERIAL_LEFT;
                case ChestType.RIGHT -> WEB_COVERED_CHEST_MATERIAL_RIGHT;
            };
        }
        if (chestRenderState.blockState.is((Block)UndergroundWorlds.ICE_CHEST.get())) {
            return ICE_CHEST_MATERIAL;
        }
        throw new RuntimeException("Mod chest renderer without chest!");
    }
}

