/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends PointedDripstoneBlock {
    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onProjectileHit(@NotNull Level world, @NotNull BlockState blockState, @NotNull BlockHitResult blockHitResult, @NotNull Projectile projectile) {
        if (!world.isClientSide && world instanceof ServerLevel) {
            BlockPos blockPos;
            ServerLevel server = (ServerLevel)world;
            Direction direction = (Direction)blockState.getValue((Property)TIP_DIRECTION);
            DripstoneThickness thickness = (DripstoneThickness)blockState.getValue((Property)THICKNESS);
            if (direction.equals((Object)Direction.DOWN) && !thickness.equals((Object)DripstoneThickness.TIP) && !thickness.equals((Object)DripstoneThickness.TIP_MERGE) && projectile.mayInteract(server, blockPos = blockHitResult.getBlockPos()) && projectile.mayBreak(server) && projectile.getDeltaMovement().length() > 0.6) {
                world.destroyBlock(blockPos, true);
            }
        }
    }

    private static boolean isIcicleWithDirection(BlockState state, Direction direction) {
        return state.is((Block)UndergroundWorlds.ICICLE_BLOCK.get()) && ((Direction)state.getValue((Property)TIP_DIRECTION)).equals((Object)direction);
    }

    private static boolean isValidPlacement(LevelReader world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos = pos.relative(direction.getOpposite()));
        return IcicleBlock.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)world, pos), (Direction)direction) || IcicleBlock.isIcicleWithDirection(state, direction);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        return IcicleBlock.isValidPlacement(world, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    private static DripstoneThickness calculateThickness(LevelReader level, BlockPos pos, Direction direction, boolean isTipMerge) {
        Direction oppositeDirection = direction.getOpposite();
        BlockState blockState = level.getBlockState(pos.relative(direction));
        if (!IcicleBlock.isIcicleWithDirection(blockState, oppositeDirection)) {
            if (!IcicleBlock.isIcicleWithDirection(blockState, direction)) {
                return DripstoneThickness.TIP;
            }
            DripstoneThickness thickness = (DripstoneThickness)blockState.getValue((Property)THICKNESS);
            if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
                return !IcicleBlock.isIcicleWithDirection(level.getBlockState(pos.relative(oppositeDirection)), direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
            }
            return DripstoneThickness.FRUSTUM;
        }
        return !isTipMerge && blockState.getValue((Property)THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader world, @NotNull ScheduledTickAccess tickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction tipDirection = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (tipDirection == Direction.DOWN && tickAccess.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (direction == tipDirection.getOpposite() && !this.canSurvive(state, world, pos)) {
            if (tipDirection == Direction.DOWN) {
                tickAccess.scheduleTick(pos, (Block)this, 2);
            } else {
                tickAccess.scheduleTick(pos, (Block)this, 1);
            }
            return state;
        }
        return (BlockState)state.setValue((Property)THICKNESS, (Comparable)IcicleBlock.calculateThickness(world, pos, tipDirection, ((DripstoneThickness)state.getValue((Property)THICKNESS)).equals((Object)DripstoneThickness.TIP_MERGE)));
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (random.nextFloat() <= 0.12f && state.is((Block)UndergroundWorlds.ICICLE_BLOCK.get()) && ((Direction)state.getValue((Property)TIP_DIRECTION)).equals((Object)Direction.DOWN) && ((DripstoneThickness)state.getValue((Property)THICKNESS)).equals((Object)DripstoneThickness.TIP) && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            Vec3 vec3 = state.getOffset(pos);
            world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_DRIPSTONE_WATER, (double)pos.getX() + 0.5 + vec3.x, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5 + vec3.z, 0.0, 0.0, 0.0);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel server, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (IcicleBlock.isIcicleWithDirection(state, Direction.UP) && !this.canSurvive(state, (LevelReader)server, pos)) {
            server.destroyBlock(pos, true);
        } else {
            BlockPos.MutableBlockPos mutablePos = pos.mutable();
            BlockState blockState = state;
            while (IcicleBlock.isIcicleWithDirection(blockState, Direction.DOWN)) {
                FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)server, (BlockPos)mutablePos, (BlockState)blockState);
                DripstoneThickness thickness = (DripstoneThickness)blockState.getValue((Property)THICKNESS);
                if (thickness.equals((Object)DripstoneThickness.TIP) || thickness.equals((Object)DripstoneThickness.TIP_MERGE)) {
                    fallingBlockEntity.setHurtsEntities((float)Math.max(1 + pos.getY() - mutablePos.getY(), 6), 40);
                    break;
                }
                mutablePos.move(Direction.DOWN);
                blockState = server.getBlockState((BlockPos)mutablePos);
            }
        }
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel server, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (server.getBrightness(LightLayer.BLOCK, pos) > 11 - state.getLightBlock()) {
            server.removeBlock(pos, false);
        } else if (random.nextFloat() < 0.17578125f && ((DripstoneThickness)state.getValue((Property)THICKNESS)).equals((Object)DripstoneThickness.TIP) && ((Direction)state.getValue((Property)TIP_DIRECTION)).equals((Object)Direction.DOWN) && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            BlockPos posBelow;
            for (int i = 1; i <= 11 && !(state = server.getBlockState(posBelow = pos.below(i))).isSolidRender() && state.getFluidState().isEmpty(); ++i) {
                if (!state.is(Blocks.CAULDRON) && !state.is(Blocks.WATER_CAULDRON)) continue;
                server.levelEvent(1504, pos, 0);
                server.scheduleTick(posBelow, state.getBlock(), 50 + pos.getY() - posBelow.getY());
                break;
            }
        }
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader world, BlockPos pos, Direction direction) {
        if (IcicleBlock.isValidPlacement(world, pos, direction)) {
            return direction;
        }
        if (!IcicleBlock.isValidPlacement(world, pos, direction.getOpposite())) {
            return null;
        }
        return direction.getOpposite();
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction oppositeDirection;
        BlockPos blockPos;
        Level world = context.getLevel();
        Direction tipDirection = IcicleBlock.calculateTipDirection((LevelReader)world, blockPos = context.getClickedPos(), oppositeDirection = context.getNearestLookingVerticalDirection().getOpposite());
        if (tipDirection == null) {
            return null;
        }
        DripstoneThickness thickness = IcicleBlock.calculateThickness((LevelReader)world, blockPos, tipDirection, !context.isSecondaryUseActive());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)tipDirection)).setValue((Property)THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockPos).getType() == Fluids.WATER));
    }

    public void onBrokenAfterFall(@NotNull Level world, @NotNull BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.isSilent()) {
            world.levelEvent(2001, pos, Block.getId((BlockState)this.defaultBlockState()));
        }
    }
}

