/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import com.mojang.serialization.MapCodec;
import hexagonnico.undergroundworlds.UndergroundWorlds;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class JungleVinesPlantBlock
extends GrowingPlantBodyBlock {
    public static final MapCodec<JungleVinesPlantBlock> CODEC = JungleVinesPlantBlock.simpleCodec(JungleVinesPlantBlock::new);
    private static final BooleanProperty SPORES = BooleanProperty.create((String)"spores");

    public JungleVinesPlantBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, CaveVines.SHAPE, false);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SPORES, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SPORES});
    }

    @NotNull
    protected GrowingPlantHeadBlock getHeadBlock() {
        return UndergroundWorlds.JUNGLE_VINES.get();
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)SPORES)).booleanValue()) {
            world.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (IntProvider)UniformInt.of((int)-2, (int)2));
            state = (BlockState)state.setValue((Property)SPORES, (Comparable)Boolean.valueOf(false));
            world.setBlock(pos, state, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            if (world.getRandom().nextBoolean()) {
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UndergroundWorlds.JUNGLE_SPORES.get(), 1));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static ToIntFunction<BlockState> lightLevel(int max) {
        return state -> (Boolean)state.getValue((Property)SPORES) != false ? max : 0;
    }

    @NotNull
    protected MapCodec<? extends GrowingPlantBodyBlock> codec() {
        return CODEC;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)SPORES) == false;
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (random.nextBoolean()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)SPORES, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.performBonemeal(world, random, pos, state);
    }
}

