/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.blocks.ModChestBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ModChestBlock
extends ChestBlock {
    private final boolean canCombine;

    public ModChestBlock(BlockBehaviour.Properties properties, boolean canCombine) {
        super(() -> UndergroundWorlds.MOD_CHEST_ENTITY.get(), properties);
        this.canCombine = canCombine;
    }

    public ModChestBlock(BlockBehaviour.Properties properties) {
        this(properties, true);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ModChestBlockEntity(blockPos, blockState);
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (!this.canCombine) {
            return (BlockState)state.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.SINGLE);
        }
        return state;
    }
}

