/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.integration;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.items.CharmItem;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class IntegrationUtils {
    public static void registerTerrablenderRegion() {
        if (UndergroundWorlds.isModLoaded("terrablender")) {
            try {
                Class.forName("hexagonnico.undergroundworlds.integration.terrablender.TerrablenderRegion").getMethod("register", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                UndergroundWorlds.LOG.error("Error enabling Terrablender integration", (Throwable)e);
            }
        }
    }

    public static boolean useCharm(LivingEntity entity, CharmItem item) {
        if (UndergroundWorlds.isModLoaded("accessories")) {
            try {
                return (Boolean)Class.forName("hexagonnico.undergroundworlds.integration.accessories.AccessoriesIntegration").getMethod("useAccessory", LivingEntity.class, CharmItem.class).invoke(null, new Object[]{entity, item});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                UndergroundWorlds.LOG.error("Error enabling Accessories integration", (Throwable)e);
            }
        } else if (UndergroundWorlds.isModLoaded("curios")) {
            try {
                return (Boolean)Class.forName("hexagonnico.undergroundworlds.neoforge.integration.CuriosIntegrationHelper").getMethod("useItem", LivingEntity.class, CharmItem.class).invoke(null, new Object[]{entity, item});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                UndergroundWorlds.LOG.error("Error enabling Curios integration", (Throwable)e);
            }
        } else {
            ItemStack itemStack = entity.getItemInHand(InteractionHand.OFF_HAND);
            if (itemStack.is((Item)item)) {
                itemStack.hurtAndBreak(item.getDurabilityDamage(), entity, EquipmentSlot.OFFHAND);
                return true;
            }
        }
        return false;
    }

    private IntegrationUtils() {
    }
}

