/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.mixin;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sheets.class})
public class SheetsMixin {
    private static final Material JUNGLE_CHEST_MATERIAL = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/temple"));
    private static final Material WEB_COVERED_CHEST_MATERIAL = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/web_covered"));
    private static final Material WEB_COVERED_CHEST_MATERIAL_LEFT = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/web_covered_left"));
    private static final Material WEB_COVERED_CHEST_MATERIAL_RIGHT = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/web_covered_right"));
    private static final Material ICE_CHEST_MATERIAL = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"entity/chest/ice"));

    @Inject(at={@At(value="HEAD")}, method={"chooseMaterial"}, cancellable=true)
    private static void chooseMaterial(BlockEntity blockEntity, ChestType type, boolean christmas, CallbackInfoReturnable<Material> callbackInfo) {
        if (blockEntity.getBlockState().is((Block)UndergroundWorlds.TEMPLE_CHEST.get())) {
            callbackInfo.setReturnValue((Object)JUNGLE_CHEST_MATERIAL);
        } else if (blockEntity.getBlockState().is((Block)UndergroundWorlds.WEB_COVERED_CHEST.get())) {
            callbackInfo.setReturnValue((Object)(switch (type) {
                default -> throw new MatchException(null, null);
                case ChestType.SINGLE -> WEB_COVERED_CHEST_MATERIAL;
                case ChestType.LEFT -> WEB_COVERED_CHEST_MATERIAL_LEFT;
                case ChestType.RIGHT -> WEB_COVERED_CHEST_MATERIAL_RIGHT;
            }));
        } else if (blockEntity.getBlockState().is((Block)UndergroundWorlds.ICE_CHEST.get())) {
            callbackInfo.setReturnValue((Object)ICE_CHEST_MATERIAL);
        }
    }
}

