/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.utils;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.entities.Ashan;
import hexagonnico.undergroundworlds.entities.BlackRecluse;
import hexagonnico.undergroundworlds.entities.FrozenZombie;
import hexagonnico.undergroundworlds.entities.IcyCreeper;
import hexagonnico.undergroundworlds.entities.JungleBee;
import hexagonnico.undergroundworlds.entities.JungleZombie;
import hexagonnico.undergroundworlds.entities.SpiderHatchling;
import hexagonnico.undergroundworlds.entities.Wrapped;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;

public class RegisterAttributesUtils {
    public static void registerAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> register) {
        register.accept(UndergroundWorlds.JUNGLE_ZOMBIE.get(), JungleZombie.createAttributes());
        register.accept(UndergroundWorlds.JUNGLE_BEE.get(), JungleBee.createAttributes());
        register.accept(UndergroundWorlds.BLACK_RECLUSE.get(), BlackRecluse.createAttributes());
        register.accept(UndergroundWorlds.SPIDER_HATCHLING.get(), SpiderHatchling.createAttributes());
        register.accept(UndergroundWorlds.FROZEN_ZOMBIE.get(), FrozenZombie.createAttributes());
        register.accept(UndergroundWorlds.ICY_CREEPER.get(), IcyCreeper.createAttributes());
        register.accept(UndergroundWorlds.ASHAN.get(), Ashan.createAttributes());
        register.accept(UndergroundWorlds.WRAPPED.get(), Wrapped.createAttributes());
    }

    public static void registerSpawnPlacement(SpawnPlacementRegister register) {
        register.accept(UndergroundWorlds.JUNGLE_ZOMBIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.JUNGLE_BEE.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.BLACK_RECLUSE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.SPIDER_HATCHLING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.FROZEN_ZOMBIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.ICY_CREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.ASHAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        register.accept(UndergroundWorlds.WRAPPED.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
    }

    @FunctionalInterface
    public static interface SpawnPlacementRegister {
        public <T extends Mob> void accept(EntityType<T> var1, SpawnPlacementType var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }
}

