/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.worldgen;

import hexagonnico.undergroundworlds.config.ModConfig;
import hexagonnico.undergroundworlds.worldgen.SimpleChestConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;

public class SimpleChestFeature
extends Feature<SimpleChestConfiguration> {
    public SimpleChestFeature() {
        super(SimpleChestConfiguration.CODEC);
    }

    public boolean place(@NotNull FeaturePlaceContext<SimpleChestConfiguration> featurePlaceContext) {
        BlockPos pos;
        WorldGenLevel world;
        SimpleChestConfiguration configuration = (SimpleChestConfiguration)featurePlaceContext.config();
        if ((configuration.config().isEmpty() || ModConfig.CONFIG.getBoolean(configuration.config())) && SimpleChestFeature.canStayHere(world = featurePlaceContext.level(), pos = featurePlaceContext.origin())) {
            RandomSource random = featurePlaceContext.random();
            BlockState chest = configuration.getChestState().rotate(Rotation.getRandom((RandomSource)random));
            world.setBlock(pos, chest, 2);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity blockEntity2 = (RandomizableContainerBlockEntity)blockEntity;
                blockEntity2.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)configuration.lootTable()), random.nextLong());
            }
            return true;
        }
        return false;
    }

    private static boolean canStayHere(WorldGenLevel world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP) && world.getBlockState(pos.above()).isAir() && SimpleChestFeature.hasAirAround(world, pos);
    }

    private static boolean hasAirAround(WorldGenLevel world, BlockPos pos) {
        return world.getBlockState(pos.north()).isAir() || world.getBlockState(pos.south()).isAir() || world.getBlockState(pos.west()).isAir() || world.getBlockState(pos.east()).isAir();
    }
}

