/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempleChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity,
WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void onClose(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int i1, int i2) {
            world.blockEvent(pos, state.getBlock(), 1, i2);
        }

        protected boolean isOwnContainer(@NotNull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
                return chestMenu.getContainer() == TempleChestBlockEntity.this;
            }
            return false;
        }
    };
    private final ChestLidController lidController = new ChestLidController();
    private boolean unlocked = false;

    public TempleChestBlockEntity(BlockPos pos, BlockState state) {
        super(UndergroundWorlds.TEMPLE_CHEST_ENTITY.get(), pos, state);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.temple_chest");
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        super.loadAdditional(input);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(input)) {
            ContainerHelper.loadAllItems((ValueInput)input, this.items);
        }
        this.unlocked = input.getBooleanOr("unlocked", false);
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        super.saveAdditional(output);
        if (!this.trySaveLootTable(output)) {
            ContainerHelper.saveAllItems((ValueOutput)output, this.items);
        }
        output.putBoolean("unlocked", this.unlocked);
    }

    public static void lidAnimateTick(Level world, BlockPos pos, BlockState state, TempleChestBlockEntity blockEntity) {
        blockEntity.lidController.tickLid();
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.lidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public boolean canOpen(@NotNull Player player) {
        return this.unlocked && super.canOpen(player);
    }

    public void startOpen(@NotNull Player player) {
        Level world = this.getLevel();
        if (!this.remove && !player.isSpectator() && world != null) {
            this.openersCounter.incrementOpeners(player, world, this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(@NotNull Player player) {
        Level world = this.getLevel();
        if (!this.remove && !player.isSpectator() && world != null) {
            this.openersCounter.decrementOpeners(player, world, this.getBlockPos(), this.getBlockState());
        }
    }

    public void tryUnlock(Player player, InteractionHand hand) {
        ItemStack itemInHand;
        if (!this.unlocked && (itemInHand = player.getItemInHand(hand)).is(UndergroundWorlds.TEMPLE_KEY.get())) {
            if (!player.isCreative()) {
                itemInHand.shrink(1);
            }
            this.unlocked = true;
            this.setChanged();
        }
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(@NotNull NonNullList<ItemStack> items) {
        this.items = items;
    }

    public float getOpenNess(float v) {
        return this.lidController.getOpenness(v);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory) {
        return ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)this);
    }

    public void recheckOpen() {
        Level world = this.getLevel();
        if (!this.remove && world != null) {
            this.openersCounter.recheckOpeners(world, this.getBlockPos(), this.getBlockState());
        }
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int i, @NotNull ItemStack item, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, @NotNull ItemStack item, @NotNull Direction direction) {
        return false;
    }
}

