/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.items;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.NotNull;

public class CharmItem
extends Item {
    private final Supplier<Integer> durabilityDamage;

    public CharmItem(Item.Properties properties, Supplier<Integer> durabilityDamage) {
        super(properties);
        this.durabilityDamage = durabilityDamage;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay tooltipDisplay, @NotNull Consumer<Component> tooltipAdder, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        if (UndergroundWorlds.isModLoaded("curios")) {
            tooltipAdder.accept((Component)Component.translatable((String)(stack.getItem().getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
        } else {
            tooltipAdder.accept((Component)Component.empty());
            tooltipAdder.accept((Component)Component.translatable((String)"item.modifiers.offhand").withStyle(ChatFormatting.GRAY));
            tooltipAdder.accept((Component)Component.translatable((String)(stack.getItem().getDescriptionId() + ".desc")).withStyle(ChatFormatting.BLUE));
        }
    }

    public int getDurabilityDamage() {
        return this.durabilityDamage.get();
    }

    public static boolean useCharm(LivingEntity entity, CharmItem item) {
        if (UndergroundWorlds.isModLoaded("curios")) {
            try {
                return (Boolean)Class.forName("hexagonnico.undergroundworlds.neoforge.integration.CuriosIntegrationHelper").getMethod("useItem", LivingEntity.class, CharmItem.class).invoke(null, new Object[]{entity, item});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                UndergroundWorlds.LOG.error("Error enabling Curios integration", (Throwable)e);
            }
        } else {
            ItemStack itemStack = entity.getItemInHand(InteractionHand.OFF_HAND);
            if (itemStack.is((Item)item)) {
                itemStack.hurtAndBreak(item.getDurabilityDamage(), entity, EquipmentSlot.OFFHAND);
                return true;
            }
        }
        return false;
    }
}

