/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import hexagonnico.undergroundworlds.UndergroundWorlds;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestTypeProcessor
extends StructureProcessor {
    public static final MapCodec<ChestTypeProcessor> CODEC = ResourceLocation.CODEC.listOf().fieldOf("chests").xmap(ChestTypeProcessor::new, processor -> processor.chests);
    private final ImmutableList<ResourceLocation> chests;

    public ChestTypeProcessor(List<ResourceLocation> chests) {
        this.chests = ImmutableList.copyOf(chests);
    }

    private BlockState getChestDefaultState() {
        for (ResourceLocation key : this.chests) {
            Optional optional;
            if (!UndergroundWorlds.isModLoaded(key.getNamespace()) || !(optional = BuiltInRegistries.BLOCK.get(key)).isPresent()) continue;
            return ((Block)((Holder.Reference)optional.get()).value()).defaultBlockState();
        }
        return Blocks.CHEST.defaultBlockState();
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(@NotNull LevelReader world, @NotNull BlockPos offset, @NotNull BlockPos pos, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StructureTemplate.StructureBlockInfo blockInfo, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StructureTemplate.StructureBlockInfo relativeBlockInfo, @NotNull StructurePlaceSettings settings) {
        if (relativeBlockInfo.state().is(Blocks.CHEST)) {
            BlockState chest = (BlockState)((BlockState)this.getChestDefaultState().setValue((Property)ChestBlock.FACING, (Comparable)((Direction)relativeBlockInfo.state().getValue((Property)ChestBlock.FACING)))).setValue((Property)ChestBlock.TYPE, (Comparable)((ChestType)relativeBlockInfo.state().getValue((Property)ChestBlock.TYPE)));
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), chest, relativeBlockInfo.nbt());
        }
        return super.processBlock(world, offset, pos, blockInfo, relativeBlockInfo, settings);
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return UndergroundWorlds.CHEST_TYPE_STRUCTURE_PROCESSOR.get();
    }
}

