/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import hexagonnico.undergroundworlds.ModLoader;
import hexagonnico.undergroundworlds.blocks.IcicleBlock;
import hexagonnico.undergroundworlds.blocks.JungleVinesBlock;
import hexagonnico.undergroundworlds.blocks.JungleVinesPlantBlock;
import hexagonnico.undergroundworlds.blocks.ModChestBlock;
import hexagonnico.undergroundworlds.blocks.ModChestBlockEntity;
import hexagonnico.undergroundworlds.blocks.ModPressurePlateBlock;
import hexagonnico.undergroundworlds.blocks.ModStairBlock;
import hexagonnico.undergroundworlds.blocks.MudGrassBlock;
import hexagonnico.undergroundworlds.blocks.QuicksandBlock;
import hexagonnico.undergroundworlds.blocks.SpiderEggBlock;
import hexagonnico.undergroundworlds.blocks.TempleChestBlock;
import hexagonnico.undergroundworlds.blocks.TempleChestBlockEntity;
import hexagonnico.undergroundworlds.config.ModConfig;
import hexagonnico.undergroundworlds.entities.Ashan;
import hexagonnico.undergroundworlds.entities.BlackRecluse;
import hexagonnico.undergroundworlds.entities.FrozenZombie;
import hexagonnico.undergroundworlds.entities.IcyCreeper;
import hexagonnico.undergroundworlds.entities.JungleBee;
import hexagonnico.undergroundworlds.entities.JungleZombie;
import hexagonnico.undergroundworlds.entities.SpiderHatchling;
import hexagonnico.undergroundworlds.entities.Wrapped;
import hexagonnico.undergroundworlds.items.AxeOfRegrowthItem;
import hexagonnico.undergroundworlds.items.CharmItem;
import hexagonnico.undergroundworlds.items.SpiderArmorItem;
import hexagonnico.undergroundworlds.predicates.ConfigCondition;
import hexagonnico.undergroundworlds.worldgen.ChestTypeProcessor;
import hexagonnico.undergroundworlds.worldgen.IcicleClusterFeature;
import hexagonnico.undergroundworlds.worldgen.SimpleChestFeature;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndergroundWorlds {
    public static final String MOD_ID = "undergroundworlds";
    public static final Logger LOG = LoggerFactory.getLogger(UndergroundWorlds.class);
    private static final ModLoader LOADER = ServiceLoader.load(ModLoader.class).findFirst().orElseThrow();
    public static final ResourceKey<Biome> UNDERGROUND_JUNGLE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"underground_jungle"));
    public static final ResourceKey<Biome> SPIDER_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"spider_cave"));
    public static final ResourceKey<Biome> UNDERGROUND_TUNDRA = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"underground_tundra"));
    public static final ResourceKey<Biome> UNDERGROUND_DESERT = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"underground_desert"));
    public static final Supplier<MudGrassBlock> JUNGLE_GRASS = LOADER.registerBlockVariantAndItem("jungle_grass", properties -> new MudGrassBlock(properties.mapColor(MapColor.GRASS).sound(SoundType.GRASS).randomTicks()), () -> Blocks.MUD);
    public static final Supplier<Block> TEMPLE_BRICKS = LOADER.registerBlockAndItem("temple_bricks", properties -> new Block(properties.requiresCorrectToolForDrops().mapColor(MapColor.TERRACOTTA_BROWN).sound(SoundType.STONE).strength(30.0f, 1200.0f)));
    public static final Supplier<Block> CRACKED_TEMPLE_BRICKS = LOADER.registerBlockVariantAndItem("cracked_temple_bricks", TEMPLE_BRICKS);
    public static final Supplier<Block> MOSSY_TEMPLE_BRICKS = LOADER.registerBlockVariantAndItem("mossy_temple_bricks", TEMPLE_BRICKS);
    public static final Supplier<Block> CHISELED_TEMPLE_BRICKS = LOADER.registerBlockVariantAndItem("chiseled_temple_bricks", TEMPLE_BRICKS);
    public static final Supplier<Block> TEMPLE_BRICK_TILES = LOADER.registerBlockVariantAndItem("temple_brick_tiles", TEMPLE_BRICKS);
    public static final Supplier<StairBlock> TEMPLE_BRICK_STAIRS = LOADER.registerBlockAndItem("temple_brick_stairs", properties -> new ModStairBlock(TEMPLE_BRICKS.get()));
    public static final Supplier<SlabBlock> TEMPLE_BRICK_SLAB = LOADER.registerBlockVariantAndItem("temple_brick_slab", SlabBlock::new, TEMPLE_BRICKS);
    public static final Supplier<WallBlock> TEMPLE_BRICK_WALL = LOADER.registerBlockVariantAndItem("temple_brick_wall", WallBlock::new, TEMPLE_BRICKS);
    public static final Supplier<StairBlock> TEMPLE_BRICK_TILE_STAIRS = LOADER.registerBlockAndItem("temple_brick_tile_stairs", properties -> new ModStairBlock(TEMPLE_BRICK_TILES.get()));
    public static final Supplier<SlabBlock> TEMPLE_BRICK_TILE_SLAB = LOADER.registerBlockVariantAndItem("temple_brick_tile_slab", SlabBlock::new, TEMPLE_BRICK_TILES);
    public static final Supplier<WallBlock> TEMPLE_BRICK_TILE_WALL = LOADER.registerBlockVariantAndItem("temple_brick_tile_wall", WallBlock::new, TEMPLE_BRICK_TILES);
    public static final Supplier<TempleChestBlock> TEMPLE_CHEST = LOADER.registerBlockAndItem("temple_chest", properties -> new TempleChestBlock(properties.mapColor(MapColor.TERRACOTTA_BROWN).sound(SoundType.STONE).strength(-1.0f, 3600000.0f).noLootTable()));
    public static final Supplier<JungleVinesBlock> JUNGLE_VINES = LOADER.registerBlockAndItem("jungle_vines", properties -> new JungleVinesBlock(properties.noCollission().instabreak().sound(SoundType.CAVE_VINES)));
    public static final Supplier<JungleVinesPlantBlock> JUNGLE_VINES_PLANT = LOADER.registerBlock("jungle_vines_plant", properties -> new JungleVinesPlantBlock(properties.noCollission().instabreak().sound(SoundType.CAVE_VINES).lightLevel(JungleVinesPlantBlock.lightLevel(8))));
    public static final Supplier<ModChestBlock> WEB_COVERED_CHEST = LOADER.registerBlockVariantAndItem("web_covered_chest", ModChestBlock::new, () -> Blocks.CHEST);
    public static final Supplier<SpiderEggBlock> SPIDER_EGG = LOADER.registerBlockAndItem("spider_egg", properties -> new SpiderEggBlock(properties.mapColor(MapColor.WOOL).strength(0.5f).sound(SoundType.METAL).noOcclusion().noLootTable().forceSolidOn().pushReaction(PushReaction.DESTROY)));
    public static final Supplier<IcicleBlock> ICICLE_BLOCK = LOADER.registerBlockAndItem("icicle", properties -> new IcicleBlock(properties.mapColor(MapColor.ICE).forceSolidOn().sound(SoundType.GLASS).noOcclusion().randomTicks().strength(1.5f, 3.0f).friction(0.98f).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).isRedstoneConductor((blockState, blockGetter, blockPos) -> false)));
    public static final Supplier<Block> ICE_BRICKS = LOADER.registerBlockVariantAndItem("ice_bricks", Block::new, () -> Blocks.PACKED_ICE);
    public static final Supplier<StairBlock> ICE_BRICK_STAIRS = LOADER.registerBlockAndItem("ice_brick_stairs", properties -> new ModStairBlock(ICE_BRICKS.get()));
    public static final Supplier<SlabBlock> ICE_BRICK_SLAB = LOADER.registerBlockVariantAndItem("ice_brick_slab", SlabBlock::new, ICE_BRICKS);
    public static final Supplier<WallBlock> ICE_BRICK_WALL = LOADER.registerBlockVariantAndItem("ice_brick_wall", WallBlock::new, ICE_BRICKS);
    public static final Supplier<ModChestBlock> ICE_CHEST = LOADER.registerBlockVariantAndItem("ice_chest", properties -> new ModChestBlock((BlockBehaviour.Properties)properties, false), () -> Blocks.PACKED_ICE);
    public static final Supplier<Block> PYRAMID_BRICKS = LOADER.registerBlockAndItem("pyramid_bricks", properties -> new Block(properties.requiresCorrectToolForDrops().mapColor(MapColor.SAND).sound(SoundType.STONE).strength(25.0f, 1000.0f)));
    public static final Supplier<Block> CRACKED_PYRAMID_BRICKS = LOADER.registerBlockVariantAndItem("cracked_pyramid_bricks", PYRAMID_BRICKS);
    public static final Supplier<StairBlock> PYRAMID_BRICK_STAIRS = LOADER.registerBlockAndItem("pyramid_brick_stairs", properties -> new ModStairBlock(PYRAMID_BRICKS.get()));
    public static final Supplier<SlabBlock> PYRAMID_BRICK_SLAB = LOADER.registerBlockVariantAndItem("pyramid_brick_slab", SlabBlock::new, PYRAMID_BRICKS);
    public static final Supplier<WallBlock> PYRAMID_BRICK_WALL = LOADER.registerBlockVariantAndItem("pyramid_brick_wall", WallBlock::new, PYRAMID_BRICKS);
    public static final Supplier<PressurePlateBlock> SANDSTONE_PRESSURE_PLATE = LOADER.registerBlockAndItem("sandstone_pressure_plate", properties -> new ModPressurePlateBlock(BlockSetType.STONE, properties.mapColor(MapColor.SAND).forceSolidOn().requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY)));
    public static final Supplier<QuicksandBlock> QUICKSAND = LOADER.registerBlock("quicksand", properties -> new QuicksandBlock(properties.mapColor(MapColor.SAND).strength(0.25f).sound(SoundType.SAND).isSuffocating((blockState, blockGetter, blockPos) -> true).isRedstoneConductor((blockState, blockGetter, blockPos) -> false)));
    public static final Supplier<DataComponentType<Unit>> FREEZING_DATA_COMPONENT = LOADER.registerDataComponent("freezing", builder -> builder.persistent(Codec.unit((Object)Unit.INSTANCE)).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)));
    public static final Supplier<Item> TEMPLE_KEY = LOADER.registerItem("temple_key", properties -> new Item(properties.stacksTo(1)));
    public static final Supplier<Item> JUNGLE_SPORES = LOADER.registerItem("jungle_spores");
    public static final Supplier<CharmItem> ANTIDOTE_FLASK = LOADER.registerItem("antidote_flask", properties -> new CharmItem(properties.stacksTo(1).durability(512).rarity(Rarity.UNCOMMON), ModConfig.ANTIDOTE_FLASK_DURABILITY_DAMAGE));
    public static final Supplier<Item> SPIDER_FANG = LOADER.registerItem("spider_fang");
    public static final Supplier<Item> FROST_BANNER_PATTERN = LOADER.registerItem("frost_banner_pattern", properties -> new Item(properties.stacksTo(1).rarity(Rarity.RARE).component(DataComponents.PROVIDES_BANNER_PATTERNS, (Object)TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"pattern_item/frost")))));
    public static final Supplier<Item> FROZEN_CORE = LOADER.registerItem("frozen_core", properties -> new Item(properties.rarity(Rarity.RARE)));
    public static final Supplier<Item> DESERT_BANNER_PATTERN = LOADER.registerItem("desert_banner_pattern", properties -> new Item(properties.stacksTo(1).rarity(Rarity.RARE).component(DataComponents.PROVIDES_BANNER_PATTERNS, (Object)TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"pattern_item/desert")))));
    public static final Supplier<CharmItem> DESERT_CHARM = LOADER.registerItem("desert_charm", properties -> new CharmItem(properties.stacksTo(1).durability(512).rarity(Rarity.UNCOMMON), ModConfig.DESERT_CHARM_DURABILITY_DAMAGE));
    public static final Supplier<SolidBucketItem> QUICKSAND_BUCKET = LOADER.registerItem("quicksand_bucket", properties -> new SolidBucketItem((Block)QUICKSAND.get(), SoundEvents.BUCKET_EMPTY, properties.stacksTo(1)));
    public static final ToolMaterial TEMPLE_TOOL_MATERIAL = new ToolMaterial(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"incorrect_for_temple_tool")), 2031, 14.0f, 3.0f, 15, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"repairs_temple_tool")));
    public static final Supplier<Item> TEMPLE_PICKAXE = LOADER.registerItem("temple_pickaxe", properties -> new Item(properties.pickaxe(TEMPLE_TOOL_MATERIAL, 1.0f, -2.8f).component(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_EXPLOSION))));
    public static final Supplier<Item> TEMPLE_SWORD = LOADER.registerItem("temple_sword", properties -> new Item(properties.sword(TEMPLE_TOOL_MATERIAL, 3.0f, -2.4f).component(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_EXPLOSION))));
    public static final Supplier<AxeItem> TEMPLE_AXE = LOADER.registerItem("temple_axe", properties -> new AxeItem(TEMPLE_TOOL_MATERIAL, 5.0f, -3.0f, properties.component(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_EXPLOSION))));
    public static final Supplier<ShovelItem> TEMPLE_SHOVEL = LOADER.registerItem("temple_shovel", properties -> new ShovelItem(TEMPLE_TOOL_MATERIAL, 1.5f, -3.0f, properties.component(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_EXPLOSION))));
    public static final Supplier<HoeItem> TEMPLE_HOE = LOADER.registerItem("temple_hoe", properties -> new HoeItem(TEMPLE_TOOL_MATERIAL, -3.0f, 0.0f, properties.component(DataComponents.DAMAGE_RESISTANT, (Object)new DamageResistant(DamageTypeTags.IS_EXPLOSION))));
    public static final ToolMaterial JUNGLE_TOOL_MATERIAL = new ToolMaterial(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"incorrect_for_jungle_tool")), 512, 14.0f, 3.0f, 10, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"repairs_jungle_tool")));
    public static final Supplier<Item> BLADE_OF_THE_JUNGLE = LOADER.registerItem("blade_of_the_jungle", properties -> new Item(properties.sword(JUNGLE_TOOL_MATERIAL, 3.0f, -2.4f)));
    public static final Supplier<AxeOfRegrowthItem> AXE_OF_REGROWTH = LOADER.registerItem("axe_of_regrowth", properties -> new AxeOfRegrowthItem(JUNGLE_TOOL_MATERIAL, 5.0f, -3.0f, (Item.Properties)properties));
    public static final ToolMaterial FREEZING_TOOL_MATERIAL = new ToolMaterial(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"incorrect_for_freezing_tool")), 250, 12.0f, 2.5f, 15, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"repairs_freezing_tool")));
    public static final Supplier<Item> FREEZING_PICKAXE = LOADER.registerItem("freezing_pickaxe", properties -> new Item(properties.pickaxe(FREEZING_TOOL_MATERIAL, 1.0f, -2.8f).component(FREEZING_DATA_COMPONENT.get(), (Object)Unit.INSTANCE)));
    public static final Supplier<Item> FREEZING_SWORD = LOADER.registerItem("freezing_sword", properties -> new Item(properties.sword(FREEZING_TOOL_MATERIAL, 3.0f, -2.4f).component(FREEZING_DATA_COMPONENT.get(), (Object)Unit.INSTANCE)));
    public static final Supplier<AxeItem> FREEZING_AXE = LOADER.registerItem("freezing_axe", properties -> new AxeItem(FREEZING_TOOL_MATERIAL, 5.5f, -3.05f, properties.component(FREEZING_DATA_COMPONENT.get(), (Object)Unit.INSTANCE)));
    public static final Supplier<ShovelItem> FREEZING_SHOVEL = LOADER.registerItem("freezing_shovel", properties -> new ShovelItem(FREEZING_TOOL_MATERIAL, 1.5f, -3.0f, properties.component(FREEZING_DATA_COMPONENT.get(), (Object)Unit.INSTANCE)));
    public static final Supplier<HoeItem> FREEZING_HOE = LOADER.registerItem("freezing_hoe", properties -> new HoeItem(FREEZING_TOOL_MATERIAL, -2.5f, -0.5f, properties.component(FREEZING_DATA_COMPONENT.get(), (Object)Unit.INSTANCE)));
    public static final Supplier<SpiderArmorItem> SPIDER_HELMET = LOADER.registerItem("spider_helmet", properties -> new SpiderArmorItem((Item.Properties)properties, ArmorType.HELMET));
    public static final Supplier<SpiderArmorItem> SPIDER_CHESTPLATE = LOADER.registerItem("spider_chestplate", properties -> new SpiderArmorItem((Item.Properties)properties, ArmorType.CHESTPLATE));
    public static final Supplier<SpiderArmorItem> SPIDER_LEGGINGS = LOADER.registerItem("spider_leggings", properties -> new SpiderArmorItem((Item.Properties)properties, ArmorType.LEGGINGS));
    public static final Supplier<SpiderArmorItem> SPIDER_BOOTS = LOADER.registerItem("spider_boots", properties -> new SpiderArmorItem((Item.Properties)properties, ArmorType.BOOTS));
    public static final ArmorMaterial WINTER_ARMOR_MATERIAL = new ArmorMaterial(5, (Map)Maps.newEnumMap(Map.of(ArmorType.BOOTS, 1, ArmorType.LEGGINGS, 4, ArmorType.CHESTPLATE, 5, ArmorType.HELMET, 2, ArmorType.BODY, 4)), 17, SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"repairs_winter_armor")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"winter")));
    public static final Supplier<Item> WINTER_HELMET = LOADER.registerItem("winter_helmet", properties -> new Item(properties.humanoidArmor(WINTER_ARMOR_MATERIAL, ArmorType.HELMET)));
    public static final Supplier<Item> WINTER_CHESTPLATE = LOADER.registerItem("winter_chestplate", properties -> new Item(properties.humanoidArmor(WINTER_ARMOR_MATERIAL, ArmorType.CHESTPLATE)));
    public static final Supplier<Item> WINTER_LEGGINGS = LOADER.registerItem("winter_leggings", properties -> new Item(properties.humanoidArmor(WINTER_ARMOR_MATERIAL, ArmorType.LEGGINGS)));
    public static final Supplier<Item> WINTER_BOOTS = LOADER.registerItem("winter_boots", properties -> new Item(properties.humanoidArmor(WINTER_ARMOR_MATERIAL, ArmorType.BOOTS)));
    public static final ResourceKey<JukeboxSong> JUKEBOX_SONG_ABBEYENCE = ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)"abbeyence"));
    public static final Supplier<SoundEvent> SOUND_EVENT_ABBEYENCE = LOADER.registerSoundEvent("music_disc.abbeyence");
    public static final Supplier<Item> MUSIC_DISC_ABBEYENCE = LOADER.registerItem("music_disc_abbeyence", properties -> new Item(properties.stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(JUKEBOX_SONG_ABBEYENCE)));
    public static final Supplier<BlockEntityType<ModChestBlockEntity>> MOD_CHEST_ENTITY = LOADER.registerBlockEntity("mod_chest", ModChestBlockEntity::new, () -> Set.of((Block)WEB_COVERED_CHEST.get(), (Block)ICE_CHEST.get()));
    public static final Supplier<BlockEntityType<TempleChestBlockEntity>> TEMPLE_CHEST_ENTITY = LOADER.registerBlockEntity("temple_chest", TempleChestBlockEntity::new, () -> Set.of((Block)TEMPLE_CHEST.get()));
    public static final Supplier<EntityType<JungleZombie>> JUNGLE_ZOMBIE = LOADER.registerEntity("jungle_zombie", EntityType.Builder.of(JungleZombie::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8));
    public static final Supplier<EntityType<JungleBee>> JUNGLE_BEE = LOADER.registerEntity("jungle_bee", EntityType.Builder.of(JungleBee::new, (MobCategory)MobCategory.MONSTER).sized(0.7f, 0.6f).eyeHeight(0.3f).clientTrackingRange(8));
    public static final Supplier<EntityType<BlackRecluse>> BLACK_RECLUSE = LOADER.registerEntity("black_recluse", EntityType.Builder.of(BlackRecluse::new, (MobCategory)MobCategory.MONSTER).sized(1.4f, 0.9f).clientTrackingRange(8));
    public static final Supplier<EntityType<SpiderHatchling>> SPIDER_HATCHLING = LOADER.registerEntity("spider_hatchling", EntityType.Builder.of(SpiderHatchling::new, (MobCategory)MobCategory.MONSTER).sized(0.4f, 0.3f).eyeHeight(0.25f).clientTrackingRange(8));
    public static final Supplier<EntityType<FrozenZombie>> FROZEN_ZOMBIE = LOADER.registerEntity("frozen_zombie", EntityType.Builder.of(FrozenZombie::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8));
    public static final Supplier<EntityType<IcyCreeper>> ICY_CREEPER = LOADER.registerEntity("icy_creeper", EntityType.Builder.of(IcyCreeper::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.7f).clientTrackingRange(8));
    public static final Supplier<EntityType<Ashan>> ASHAN = LOADER.registerEntity("ashan", EntityType.Builder.of(Ashan::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.99f).eyeHeight(1.74f).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final Supplier<EntityType<Wrapped>> WRAPPED = LOADER.registerEntity("wrapped", EntityType.Builder.of(Wrapped::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.74f).passengerAttachments(new float[]{2.075f}).ridingOffset(-0.7f).clientTrackingRange(8));
    public static final Supplier<SpawnEggItem> JUNGLE_ZOMBIE_SPAWN_EGG = LOADER.registerItem("jungle_zombie_spawn_egg", properties -> new SpawnEggItem(JUNGLE_ZOMBIE.get(), properties));
    public static final Supplier<SpawnEggItem> JUNGLE_BEE_SPAWN_EGG = LOADER.registerItem("jungle_bee_spawn_egg", properties -> new SpawnEggItem(JUNGLE_BEE.get(), properties));
    public static final Supplier<SpawnEggItem> BLACK_RECLUSE_SPAWN_EGG = LOADER.registerItem("black_recluse_spawn_egg", properties -> new SpawnEggItem(BLACK_RECLUSE.get(), properties));
    public static final Supplier<SpawnEggItem> SPIDER_HATCHLING_SPAWN_EGG = LOADER.registerItem("spider_hatchling_spawn_egg", properties -> new SpawnEggItem(SPIDER_HATCHLING.get(), properties));
    public static final Supplier<SpawnEggItem> FROZEN_ZOMBIE_SPAWN_EGG = LOADER.registerItem("frozen_zombie_spawn_egg", properties -> new SpawnEggItem(FROZEN_ZOMBIE.get(), properties));
    public static final Supplier<SpawnEggItem> ICY_CREEPER_SPAWN_EGG = LOADER.registerItem("icy_creeper_spawn_egg", properties -> new SpawnEggItem(ICY_CREEPER.get(), properties));
    public static final Supplier<SpawnEggItem> ASHAN_SPAWN_EGG = LOADER.registerItem("ashan_spawn_egg", properties -> new SpawnEggItem(ASHAN.get(), properties));
    public static final Supplier<SpawnEggItem> WRAPPED_SPAWN_EGG = LOADER.registerItem("wrapped_spawn_egg", properties -> new SpawnEggItem(WRAPPED.get(), properties));
    public static final Supplier<SimpleChestFeature> SIMPLE_CHEST_FEATURE = LOADER.registerFeature("simple_chest", SimpleChestFeature::new);
    public static final Supplier<IcicleClusterFeature> ICICLE_CLUSTER_FEATURE = LOADER.registerFeature("icicle_cluster", IcicleClusterFeature::new);
    public static final Supplier<StructureProcessorType<ChestTypeProcessor>> CHEST_TYPE_STRUCTURE_PROCESSOR = LOADER.registerStructureProcessor("chest_type", () -> ChestTypeProcessor.CODEC);
    public static final Supplier<LootItemConditionType> CONFIG_CONDITION = LOADER.registerLootCondition("config", () -> ConfigCondition.CODEC);
    public static final Supplier<MapDecorationType> MAP_DECORATION_JUNGLE_TEMPLE = LOADER.registerMapDecorationType("jungle_temple");
    public static final Supplier<MapDecorationType> MAP_DECORATION_ICE_DUNGEON = LOADER.registerMapDecorationType("ice_dungeon");
    public static final Supplier<MapDecorationType> MAP_DECORATION_DESERT_PYRAMID = LOADER.registerMapDecorationType("desert_pyramid");

    public static boolean isModLoaded(String modId) {
        return LOADER.isModLoaded(modId);
    }

    public static boolean isRegisterDone() {
        return LOADER.isRegisterDone();
    }

    public static void init() {
    }
}

