/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.blocks;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.entities.SpiderHatchling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiderEggBlock
extends Block {
    private static final VoxelShape ONE_EGG_AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public SpiderEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.EGGS, (Comparable)Integer.valueOf(1)));
    }

    private static void decreaseEggs(Level world, BlockPos pos, BlockState state) {
        world.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
        int count = (Integer)state.getValue((Property)BlockStateProperties.EGGS);
        if (count <= 1) {
            world.destroyBlock(pos, false);
        } else {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.EGGS, (Comparable)Integer.valueOf(count - 1)), 2);
            world.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
        }
        SpiderHatchling spider = (SpiderHatchling)UndergroundWorlds.SPIDER_HATCHLING.get().create(world, EntitySpawnReason.BREEDING);
        if (spider != null) {
            spider.setPos(pos.getCenter().add(0.0, 0.2, 0.0));
            world.addFreshEntity((Entity)spider);
        }
    }

    private static boolean canDestroyEgg(ServerLevel world, Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof Spider || entity instanceof Bat) {
                return false;
            }
            return entity instanceof Player || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
        return false;
    }

    private static void destroyEgg(Level world, BlockState state, BlockPos pos, Entity entity, int chance) {
        ServerLevel serverWorld;
        if (state.is((Block)UndergroundWorlds.SPIDER_EGG.get()) && world instanceof ServerLevel && SpiderEggBlock.canDestroyEgg(serverWorld = (ServerLevel)world, entity) && world.getRandom().nextInt(chance) == 0) {
            SpiderEggBlock.decreaseEggs((Level)serverWorld, pos, state);
        }
    }

    public void stepOn(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        if (!entity.isSteppingCarefully()) {
            SpiderEggBlock.destroyEgg(world, state, pos, entity, 30);
        }
        super.stepOn(world, pos, state, entity);
    }

    public void fallOn(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, double fallDistance) {
        SpiderEggBlock.destroyEgg(world, state, pos, entity, 2);
        super.fallOn(world, state, pos, entity, fallDistance);
    }

    public void playerDestroy(@NotNull Level world, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack itemStack) {
        super.playerDestroy(world, player, pos, state, blockEntity, itemStack);
        SpiderEggBlock.decreaseEggs(world, pos, state);
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        if (!context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)BlockStateProperties.EGGS) < 4) {
            return true;
        }
        return super.canBeReplaced(state, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.getValue((Property)BlockStateProperties.EGGS) + 1)));
        }
        return super.getStateForPlacement(context);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.getValue((Property)BlockStateProperties.EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.EGGS});
    }
}

