/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.forge;

import com.mojang.serialization.MapCodec;
import hexagonnico.undergroundworlds.ModLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ForgeModLoader
extends ModLoader {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"undergroundworlds");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"undergroundworlds");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"undergroundworlds");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"undergroundworlds");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"undergroundworlds");
    private static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"undergroundworlds");
    private static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"undergroundworlds");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"undergroundworlds");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"undergroundworlds");
    private static final DeferredRegister<MapDecorationType> MAP_DECORATION_TYPES = DeferredRegister.create((ResourceKey)Registries.MAP_DECORATION_TYPE, (String)"undergroundworlds");
    private static boolean registerDone = false;

    private <T> ResourceKey<T> resourceKey(ResourceKey<? extends Registry<T>> registry, String name) {
        return ResourceKey.create(registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)name));
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String name, Function<Item.Properties, T> function) {
        return ITEMS.register(name, () -> (Item)function.apply(new Item.Properties().setId(this.resourceKey(Registries.ITEM, name))));
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> function) {
        return BLOCKS.register(name, () -> (Block)function.apply(BlockBehaviour.Properties.of().setId(this.resourceKey(Registries.BLOCK, name))));
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String name, BiFunction<BlockPos, BlockState, T> blockEntity, Supplier<Set<Block>> blocks) {
        return BLOCK_ENTITIES.register(name, () -> new BlockEntityType(blockEntity::apply, (Set)blocks.get()));
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        return ENTITIES.register(name, () -> builder.build(this.resourceKey(Registries.ENTITY_TYPE, name)));
    }

    @Override
    public <T extends Feature<?>> Supplier<T> registerFeature(String name, Supplier<T> supplier) {
        return FEATURES.register(name, supplier);
    }

    @Override
    public <T extends StructureProcessor> Supplier<StructureProcessorType<T>> registerStructureProcessor(String name, Supplier<MapCodec<T>> supplier) {
        return STRUCTURE_PROCESSORS.register(name, () -> ((Supplier)supplier)::get);
    }

    @Override
    public Supplier<LootItemConditionType> registerLootCondition(String name, Supplier<MapCodec<? extends LootItemCondition>> supplier) {
        return LOOT_CONDITIONS.register(name, () -> new LootItemConditionType((MapCodec)supplier.get()));
    }

    @Override
    public <T> Supplier<DataComponentType<T>> registerDataComponent(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA_COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    @Override
    public Supplier<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)name)));
    }

    @Override
    public Supplier<MapDecorationType> registerMapDecorationType(String name) {
        return MAP_DECORATION_TYPES.register(name, () -> new MapDecorationType(ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)name), true, -1, true, false));
    }

    @Override
    public String getName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isRegisterDone() {
        return registerDone;
    }

    public static void register(FMLJavaModLoadingContext context) {
        BusGroup eventBus = context.getModBusGroup();
        ITEMS.register(eventBus);
        BLOCKS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        ENTITIES.register(eventBus);
        FEATURES.register(eventBus);
        STRUCTURE_PROCESSORS.register(eventBus);
        LOOT_CONDITIONS.register(eventBus);
        DATA_COMPONENTS.register(eventBus);
        SOUND_EVENTS.register(eventBus);
        MAP_DECORATION_TYPES.register(eventBus);
        registerDone = true;
    }
}

