/*
 * Decompiled with CFR 0.152.
 */
package github.jcsmecabricks.customweapons.entity.client;

import github.jcsmecabricks.customweapons.custom.ElephantArmorItem;
import github.jcsmecabricks.customweapons.entity.client.ElephantModel;
import github.jcsmecabricks.customweapons.entity.client.ElephantRenderState;
import github.jcsmecabricks.customweapons.init.ItemInit;
import java.util.Map;
import net.minecraft.class_10197;
import net.minecraft.class_11659;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5599;

public class ElephantArmorFeatureRenderer
extends class_3887<ElephantRenderState, ElephantModel> {
    private final ElephantModel model;
    private final class_10197 equipmentRenderer;
    private static final Map<class_1792, class_2960> ARMOR_MAP = Map.of(ItemInit.IRON_ELEPHANT_ARMOR, class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/iron_elephant.png"), ItemInit.GOLD_ELEPHANT_ARMOR, class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/gold_elephant.png"), ItemInit.DIAMOND_ELEPHANT_ARMOR, class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/diamond_elephant.png"), ItemInit.NETHERITE_ELEPHANT_ARMOR, class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/netherite_elephant.png"), ItemInit.SILVER_ELEPHANT_ARMOR, class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/silver_elephant.png"));
    private static final class_2960[] DYE_LOCATION = new class_2960[]{class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/white.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/orange.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/magenta.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/light_blue.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/yellow.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/lime.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/pink.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/gray.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/light_gray.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/cyan.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/purple.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/blue.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/brown.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/green.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/red.png"), class_2960.method_60655((String)"custom-weapons", (String)"textures/entity/elephant/armor/blanket/black.png")};

    public ElephantArmorFeatureRenderer(class_3883<ElephantRenderState, ElephantModel> context, class_5599 loader, class_10197 equipmentRenderer) {
        super(context);
        this.model = new ElephantModel(loader.method_32072(ElephantModel.ELEPHANT_ARMOR));
        this.equipmentRenderer = equipmentRenderer;
    }

    public void render(class_4587 matrices, class_11659 queue, int light, ElephantRenderState state, float limbAngle, float limbDistance) {
        if (!state.hasArmorOn) {
            return;
        }
        class_1799 stack = state.getBodyArmor;
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ElephantArmorItem)) {
            return;
        }
        ElephantArmorItem armorItem = (ElephantArmorItem)class_17922;
        class_2960 armorTexture = ARMOR_MAP.get(armorItem);
        if (armorTexture == null) {
            return;
        }
        ((ElephantModel)this.method_17165()).copyStateTo(this.model);
        this.model.setAngles(state);
        queue.method_73489((class_3879)this.model, (Object)state, matrices, class_1921.method_23578((class_2960)armorTexture), light, class_4608.field_21444, state.field_61821, null);
        class_2960 dyeTexture = this.getBlanketTexture(state.swag);
        if (dyeTexture != null) {
            queue.method_73489((class_3879)this.model, (Object)state, matrices, class_1921.method_23578((class_2960)dyeTexture), light, class_4608.field_21444, state.field_61821, null);
        }
    }

    private class_2960 getBlanketTexture(class_1767 dyeColor) {
        if (dyeColor != null) {
            return DYE_LOCATION[dyeColor.ordinal()];
        }
        return null;
    }
}

