/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy;

import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.crate.GooseboyCrate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigManager {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("gooseboy.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(GooseboyCrate.Permission.class, (json, typeOfT, ctx) -> {
        try {
            return GooseboyCrate.Permission.valueOf(json.getAsString());
        }
        catch (Exception e) {
            Gooseboy.LOGGER.warn("Unknown permission: " + json.getAsString());
            return null;
        }
    }).create();
    private static RootConfig config;

    public static synchronized RootConfig getConfig() {
        if (config == null) {
            ConfigManager.load();
        }
        return config;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized void load() {
        try {
            Files.createDirectories(ConfigManager.CONFIG_PATH.getParent(), new FileAttribute[0]);
            if (Files.exists(ConfigManager.CONFIG_PATH, new LinkOption[0])) {
                r = Files.newBufferedReader(ConfigManager.CONFIG_PATH);
                try {
                    ConfigManager.config = (RootConfig)ConfigManager.GSON.fromJson((Reader)r, RootConfig.class);
                    if (ConfigManager.config != null) ** GOTO lbl18
                    ConfigManager.config = new RootConfig();
                }
                finally {
                    if (r != null) {
                        r.close();
                    }
                }
            } else {
                ConfigManager.config = new RootConfig();
                ConfigManager.config.default_crate_settings.permissions = Arrays.asList(new GooseboyCrate.Permission[]{GooseboyCrate.Permission.CONSOLE, GooseboyCrate.Permission.INPUT_MOUSE, GooseboyCrate.Permission.INPUT_MOUSE_POS});
                ConfigManager.save();
            }
lbl18:
            // 3 sources

            ConfigManager.sanitizePermissions(ConfigManager.config);
        }
        catch (IOException e) {
            Gooseboy.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
            ConfigManager.config = new RootConfig();
        }
    }

    private static void sanitizePermissions(RootConfig cfg) {
        if (cfg.default_crate_settings != null) {
            cfg.default_crate_settings.permissions.removeIf(Objects::isNull);
        } else {
            cfg.default_crate_settings = new CrateSettings();
        }
        if (cfg.crate_settings != null) {
            for (CrateSettings s : cfg.crate_settings.values()) {
                if (s == null || s.permissions == null) continue;
                s.permissions.removeIf(Objects::isNull);
            }
        } else {
            cfg.crate_settings = new HashMap<String, CrateSettings>();
        }
    }

    public static synchronized void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Path tmp = CONFIG_PATH.resolveSibling(CONFIG_PATH.getFileName().toString() + ".tmp");
            try (BufferedWriter w = Files.newBufferedWriter(tmp, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                GSON.toJson((Object)ConfigManager.getConfig(), (Appendable)w);
            }
            try {
                Files.move(tmp, CONFIG_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tmp, CONFIG_PATH, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            Gooseboy.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static synchronized List<GooseboyCrate.Permission> getEffectivePermissions(String crateName) {
        RootConfig cfg = ConfigManager.getConfig();
        CrateSettings specific = cfg.crate_settings.get(crateName);
        if (specific != null && specific.permissions != null && !specific.permissions.isEmpty()) {
            return List.copyOf(specific.permissions);
        }
        return List.copyOf(cfg.default_crate_settings.permissions);
    }

    public static synchronized void setCratePermissions(String crateName, Collection<GooseboyCrate.Permission> permissions) {
        RootConfig cfg = ConfigManager.getConfig();
        CrateSettings s = new CrateSettings();
        s.permissions = new ArrayList<GooseboyCrate.Permission>(permissions);
        cfg.crate_settings.put(crateName, s);
        ConfigManager.save();
    }

    public static class RootConfig {
        public String version = "1.0.0";
        public boolean useInterpreter = false;
        public Map<String, CrateSettings> crate_settings = new HashMap<String, CrateSettings>();
        public CrateSettings default_crate_settings = new CrateSettings();
    }

    public static class CrateSettings {
        public List<GooseboyCrate.Permission> permissions = new ArrayList<GooseboyCrate.Permission>();
    }
}

