/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy;

import awildgoose.gooseboy.ClientCommonBridge;
import awildgoose.gooseboy.crate.GooseboyCrate;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gooseboy
implements ModInitializer {
    public static final String MOD_ID = "gooseboy";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"gooseboy");
    public static ClientCommonBridge ccb;
    public static final int FRAMEBUFFER_WIDTH = 320;
    public static final int FRAMEBUFFER_HEIGHT = 200;
    private static final HashMap<Instance, GooseboyCrate> runningCrates;

    public static Path getGooseboyDirectory() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path gooseboyDir = gameDir.resolve(MOD_ID);
        try {
            Files.createDirectories(gooseboyDir, new FileAttribute[0]);
            Files.createDirectories(gooseboyDir.resolve("crates"), new FileAttribute[0]);
            Files.createDirectories(gooseboyDir.resolve("storage"), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gooseboyDir;
    }

    public static GooseboyCrate getCrate(Instance instance) {
        return runningCrates.get(instance);
    }

    public static void addCrate(GooseboyCrate crate) {
        runningCrates.put(crate.instance, crate);
    }

    public static void removeCrate(GooseboyCrate crate) {
        runningCrates.remove(crate.instance);
    }

    public void onInitialize() {
        Gooseboy.getGooseboyDirectory();
    }

    static {
        runningCrates = new HashMap();
    }
}

