/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.openal.AL10;

@Environment(value=EnvType.CLIENT)
public class RawAudioManager {
    private static final List<PlayingSound> active = new CopyOnWriteArrayList<PlayingSound>();
    private static long AUDIO_ID;
    private static final int MAX_AUDIO_SIZE = 0xA00000;
    private static final int MAX_CONCURRENT_SOUNDS = 32;
    private static final int SAMPLE_RATE = 44100;

    public static long play(byte[] pcm) {
        if (pcm == null || pcm.length > 0xA00000) {
            return -1L;
        }
        if (pcm.length % 2 != 0) {
            return -1L;
        }
        if (active.size() >= 32) {
            return -1L;
        }
        ByteBuffer bufferDirect = ByteBuffer.allocateDirect(pcm.length).order(ByteOrder.nativeOrder());
        bufferDirect.put(pcm);
        bufferDirect.flip();
        int buffer = AL10.alGenBuffers();
        AL10.alBufferData((int)buffer, (int)4353, (ByteBuffer)bufferDirect, (int)44100);
        int source = AL10.alGenSources();
        AL10.alSourcei((int)source, (int)4105, (int)buffer);
        AL10.alSourcePlay((int)source);
        PlayingSound ps = new PlayingSound();
        ps.source = source;
        ps.buffer = buffer;
        ps.id = AUDIO_ID++;
        active.add(ps);
        return ps.id;
    }

    public static void stop(long id) {
        active.removeIf(ps -> {
            if (ps.id == id) {
                AL10.alSourceStop((int)ps.source);
                AL10.alDeleteSources((int)ps.source);
                AL10.alDeleteBuffers((int)ps.buffer);
                return true;
            }
            return false;
        });
    }

    public static void stopAllSounds() {
        for (PlayingSound ps : List.copyOf(active)) {
            AL10.alSourceStop((int)ps.source);
            AL10.alDeleteSources((int)ps.source);
            AL10.alDeleteBuffers((int)ps.buffer);
        }
        active.clear();
    }

    public static void setVolume(long id, float volume) {
        for (PlayingSound ps : active) {
            if (ps.id != id) continue;
            float v = Math.max(0.0f, Math.min(10.0f, volume));
            AL10.alSourcef((int)ps.source, (int)4106, (float)v);
            break;
        }
    }

    public static void setPitch(long id, float pitch) {
        for (PlayingSound ps : active) {
            if (ps.id != id) continue;
            float p = Math.max(0.1f, Math.min(10.0f, pitch));
            AL10.alSourcef((int)ps.source, (int)4099, (float)p);
            break;
        }
    }

    public static boolean isPlaying(long id) {
        return active.stream().anyMatch(ps -> ps.id == id);
    }

    public static void tick() {
        active.removeIf(ps -> {
            int state = AL10.alGetSourcei((int)ps.source, (int)4112);
            if (state != 4114) {
                AL10.alDeleteSources((int)ps.source);
                AL10.alDeleteBuffers((int)ps.buffer);
                return true;
            }
            return false;
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static class PlayingSound {
        int source;
        int buffer;
        long id;

        private PlayingSound() {
        }
    }
}

