/*
 * Decompiled with CFR 0.152.
 */
package awildgoose.gooseboy;

import awildgoose.gooseboy.ConfigManager;
import awildgoose.gooseboy.Gooseboy;
import awildgoose.gooseboy.embedded.chicory.compiler.MachineFactoryCompiler;
import awildgoose.gooseboy.embedded.chicory.runtime.ImportValues;
import awildgoose.gooseboy.embedded.chicory.runtime.Instance;
import awildgoose.gooseboy.embedded.chicory.wasm.ChicoryException;
import awildgoose.gooseboy.embedded.chicory.wasm.Parser;
import awildgoose.gooseboy.embedded.chicory.wasm.UninstantiableException;
import awildgoose.gooseboy.embedded.chicory.wasm.WasmModule;
import awildgoose.gooseboy.embedded.chicory.wasm.types.MemoryLimits;
import awildgoose.gooseboy.lib.Registrar;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Wasm {
    public static final int WASM_PAGE_SIZE_KB = 64;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<byte[]> loadCrateFile(String relativePath) {
        Path wasmPath = Gooseboy.getGooseboyDirectory().resolve("crates").resolve(relativePath);
        if (!Files.exists(wasmPath, new LinkOption[0])) {
            try (InputStream in = Gooseboy.class.getResourceAsStream("/assets/gooseboy/crates/" + relativePath);){
                if (in == null) {
                    Optional<byte[]> optional2 = Optional.empty();
                    return optional2;
                }
                Optional<byte[]> optional = Optional.ofNullable(in.readAllBytes());
                return optional;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        try {
            return Optional.of(Files.readAllBytes(wasmPath));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static List<String> listWasmCrates() {
        HashSet<String> crates;
        block20: {
            crates = new HashSet<String>();
            Consumer<Stream> addWasmFiles = stream -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().toLowerCase().endsWith(".wasm")).map(f -> f.getFileName().toString()).forEach(crates::add);
            Path wasmPath = Gooseboy.getGooseboyDirectory().resolve("crates");
            if (Files.exists(wasmPath, new LinkOption[0])) {
                try (Stream<Path> stream22 = Files.list(wasmPath);){
                    addWasmFiles.accept(stream22);
                }
                catch (IOException stream22) {
                    // empty catch block
                }
            }
            try {
                URL resource = Gooseboy.class.getResource("/assets/gooseboy/crates/");
                if (resource == null) break block20;
                if ("jar".equals(resource.getProtocol())) {
                    JarURLConnection jarConnection = (JarURLConnection)resource.openConnection();
                    JarFile jarFile = jarConnection.getJarFile();
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith("assets/gooseboy/crates/") || !name.endsWith(".wasm")) continue;
                        crates.add(Paths.get(name, new String[0]).getFileName().toString());
                    }
                    break block20;
                }
                if (!"file".equals(resource.getProtocol())) break block20;
                Path dir = Paths.get(resource.toURI());
                try (Stream<Path> stream3 = Files.list(dir);){
                    addWasmFiles.accept(stream3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<String>(crates);
    }

    private static int kilobytesToPages(int kilobytes) {
        return (kilobytes + 64 - 1) / 64;
    }

    @Nullable
    public static Instance createInstance(String filename, int initialMemoryKilobytes, int maximumMemoryKilobytes) {
        Instance instance;
        block4: {
            Optional<byte[]> wasm = Wasm.loadCrateFile(filename);
            if (wasm.isEmpty()) {
                return null;
            }
            int initialPages = Wasm.kilobytesToPages(initialMemoryKilobytes);
            int maxPages = Wasm.kilobytesToPages(maximumMemoryKilobytes);
            WasmModule module = Parser.parse(wasm.get());
            Instance.Builder builder = Instance.builder(module).withImportValues(Registrar.register(ImportValues.builder()).build());
            if (!ConfigManager.getConfig().useInterpreter) {
                builder.withMachineFactory(MachineFactoryCompiler::compile).withMemoryLimits(new MemoryLimits(initialPages, maxPages));
            }
            try {
                instance = builder.build();
            }
            catch (ChicoryException e) {
                instance = null;
                e.printStackTrace();
                if (!(e instanceof UninstantiableException)) break block4;
                Gooseboy.LOGGER.error("You may need to set the EXTENDED_MEMORY permission for this crate to work");
            }
        }
        return instance;
    }
}

